/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.jobs.processors;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.ml.common.MLModel;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.jobs.processors.MLJobProcessor;
import org.opensearch.ml.stats.otel.counters.MLAdoptionMetricsCounter;
import org.opensearch.ml.stats.otel.metrics.AdoptionMetric;
import org.opensearch.remote.metadata.client.GetDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class MLStatsJobProcessor
extends MLJobProcessor {
    private static final Logger log = LogManager.getLogger(MLStatsJobProcessor.class);
    private static MLStatsJobProcessor instance;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;
    private final SdkClient sdkClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLStatsJobProcessor getInstance(ClusterService clusterService, Client client, ThreadPool threadPool, ConnectorAccessControlHelper connectorAccessControlHelper, SdkClient sdkClient) {
        if (instance != null) {
            return instance;
        }
        Class<MLStatsJobProcessor> clazz = MLStatsJobProcessor.class;
        synchronized (MLStatsJobProcessor.class) {
            if (instance != null) {
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return instance;
            }
            instance = new MLStatsJobProcessor(clusterService, client, threadPool, connectorAccessControlHelper, sdkClient);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return instance;
        }
    }

    public static synchronized void reset() {
        instance = null;
    }

    public MLStatsJobProcessor(ClusterService clusterService, Client client, ThreadPool threadPool, ConnectorAccessControlHelper connectorAccessControlHelper, SdkClient sdkClient) {
        super(clusterService, client, threadPool);
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.sdkClient = sdkClient;
    }

    @Override
    public void run() {
        if (!this.clusterService.state().metadata().indices().containsKey(".plugins-ml-model")) {
            log.info("Skipping ML Stats Collector job - ML model index not found");
            return;
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{".plugins-ml-model"});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"chunk_number"));
        searchSourceBuilder.query((QueryBuilder)boolQuery);
        searchSourceBuilder.size(10000);
        searchRequest.source(searchSourceBuilder);
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                for (SearchHit hit : searchResponse.getHits()) {
                    try {
                        XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                        parser.nextToken();
                        String algorithmName = hit.getSourceAsMap().get("algorithm").toString();
                        MLModel model = MLModel.parse((XContentParser)parser, (String)algorithmName);
                        if (model.getConnector() == null && model.getConnectorId() != null) {
                            try (ThreadContext.StoredContext context = MLStatsJobProcessor.this.client.threadPool().getThreadContext().stashContext();){
                                GetDataObjectRequest getDataObjectRequest = ((GetDataObjectRequest.Builder)((GetDataObjectRequest.Builder)GetDataObjectRequest.builder().index(".plugins-ml-connector")).id(model.getConnectorId())).build();
                                MLStatsJobProcessor.this.connectorAccessControlHelper.getConnector(MLStatsJobProcessor.this.sdkClient, MLStatsJobProcessor.this.client, context, getDataObjectRequest, model.getConnectorId(), (ActionListener<Connector>)ActionListener.wrap(connector -> MLAdoptionMetricsCounter.getInstance().incrementCounter(AdoptionMetric.MODEL_COUNT, model.getTags(connector)), e -> log.error("Failed to get connector for model: {}", (Object)model.getModelId(), e)));
                            }
                            return;
                        }
                        MLAdoptionMetricsCounter.getInstance().incrementCounter(AdoptionMetric.MODEL_COUNT, model.getTags());
                    }
                    catch (Exception e2) {
                        log.error("Failed to parse model from hit: {}", (Object)hit.getId(), (Object)e2);
                    }
                }
            }

            public void onFailure(Exception e) {
                log.error("Failed to fetch models", (Throwable)e);
            }
        });
    }
}

