/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.alerts;

import java.io.IOException;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.util.IndexUtilsKt;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 $2\u00020\u00012\u00020\u0002:\u0001$B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\tH\u00c6\u0003J\u001d\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\tH\u00d6\u0001J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006%"}, d2={"Lorg/opensearch/commons/alerting/alerts/AlertError;", "Lorg/opensearch/core/common/io/stream/Writeable;", "Lorg/opensearch/core/xcontent/ToXContent;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "timestamp", "Ljava/time/Instant;", "message", "", "(Ljava/time/Instant;Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "setMessage", "(Ljava/lang/String;)V", "getTimestamp", "()Ljava/time/Instant;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "common-utils"})
public final class AlertError
implements Writeable,
ToXContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Instant timestamp;
    @NotNull
    private String message;
    @NotNull
    public static final String TIMESTAMP_FIELD = "timestamp";
    @NotNull
    public static final String MESSAGE_FIELD = "message";

    public AlertError(@NotNull Instant timestamp, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)TIMESTAMP_FIELD);
        Intrinsics.checkNotNullParameter((Object)message, (String)MESSAGE_FIELD);
        this.timestamp = timestamp;
        this.message = message;
        this.message = Companion.obfuscateIPAddresses(this.message);
    }

    @NotNull
    public final Instant getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.message = string;
    }

    public AlertError(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        Instant instant = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"sin.readInstant()");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
        this(instant, string);
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeInstant(this.timestamp);
        out.writeString(this.message);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        XContentBuilder xContentBuilder = builder.startObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.startObject()");
        XContentBuilder xContentBuilder2 = IndexUtilsKt.optionalTimeField(xContentBuilder, TIMESTAMP_FIELD, this.timestamp).field(MESSAGE_FIELD, this.message).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder2, (String)"builder.startObject()\n  \u2026\n            .endObject()");
        return xContentBuilder2;
    }

    @NotNull
    public final Instant component1() {
        return this.timestamp;
    }

    @NotNull
    public final String component2() {
        return this.message;
    }

    @NotNull
    public final AlertError copy(@NotNull Instant timestamp, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)timestamp, (String)TIMESTAMP_FIELD);
        Intrinsics.checkNotNullParameter((Object)message, (String)MESSAGE_FIELD);
        return new AlertError(timestamp, message);
    }

    public static /* synthetic */ AlertError copy$default(AlertError alertError, Instant instant, String string, int n, Object object) {
        if ((n & 1) != 0) {
            instant = alertError.timestamp;
        }
        if ((n & 2) != 0) {
            string = alertError.message;
        }
        return alertError.copy(instant, string);
    }

    @NotNull
    public String toString() {
        return "AlertError(timestamp=" + this.timestamp + ", message=" + this.message + ")";
    }

    public int hashCode() {
        int result = this.timestamp.hashCode();
        result = result * 31 + this.message.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AlertError)) {
            return false;
        }
        AlertError alertError = (AlertError)other;
        if (!Intrinsics.areEqual((Object)this.timestamp, (Object)alertError.timestamp)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.message, (Object)alertError.message);
    }

    @JvmStatic
    @NotNull
    public static final AlertError parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @JvmStatic
    @NotNull
    public static final AlertError readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/opensearch/commons/alerting/alerts/AlertError$Companion;", "", "()V", "MESSAGE_FIELD", "", "TIMESTAMP_FIELD", "obfuscateIPAddresses", "exceptionMessage", "parse", "Lorg/opensearch/commons/alerting/alerts/AlertError;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "readFrom", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final AlertError parse(@NotNull XContentParser xcp) throws IOException {
            String string;
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Instant timestamp = null;
            String message = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string2 = fieldName;
                if (Intrinsics.areEqual((Object)string2, (Object)AlertError.TIMESTAMP_FIELD)) {
                    if (IndexUtilsKt.instant(xcp) != null) continue;
                    String string3 = "Required value was null.";
                    throw new IllegalArgumentException(string3.toString());
                }
                if (!Intrinsics.areEqual((Object)string2, (Object)AlertError.MESSAGE_FIELD)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"xcp.text()");
            }
            Instant instant = timestamp;
            if (instant == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)AlertError.TIMESTAMP_FIELD);
                instant = null;
            }
            if ((string = message) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)AlertError.MESSAGE_FIELD);
                string = null;
            }
            return new AlertError(instant, string);
        }

        @JvmStatic
        @NotNull
        public final AlertError readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new AlertError(sin);
        }

        @NotNull
        public final String obfuscateIPAddresses(@NotNull String exceptionMessage) {
            Intrinsics.checkNotNullParameter((Object)exceptionMessage, (String)"exceptionMessage");
            String ipAddressPattern = "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}";
            CharSequence charSequence = exceptionMessage;
            Regex regex = new Regex(ipAddressPattern);
            String string = "x.x.x.x";
            String obfuscatedMessage = regex.replace(charSequence, string);
            return obfuscatedMessage;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

