/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule.action;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.rule.autotagging.FeatureType;

@ExperimentalApi
public class DeleteRuleRequest
extends ActionRequest {
    private final String ruleId;
    private final FeatureType featureType;

    public DeleteRuleRequest(String ruleId, FeatureType featureType) {
        this.ruleId = ruleId;
        this.featureType = featureType;
    }

    public DeleteRuleRequest(StreamInput in) throws IOException {
        super(in);
        this.ruleId = in.readString();
        this.featureType = FeatureType.from(in.readString());
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.ruleId);
        this.featureType.writeTo(out);
    }

    public ActionRequestValidationException validate() {
        if (this.ruleId == null || this.ruleId.isEmpty()) {
            ActionRequestValidationException validationException = new ActionRequestValidationException();
            validationException.addValidationError("Rule ID is missing");
            return validationException;
        }
        return null;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    FeatureType getFeatureType() {
        return this.featureType;
    }
}

