/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.screens;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.screens.SystemScreen;
import com.install4j.runtime.installer.frontend.Messages;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.io.File;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class UninstallFailureScreen
extends SystemScreen {
    private JTextPane txaInfo;
    private JScrollPane scpInfo;
    private boolean failure;
    private boolean showDirectories = false;

    @Override
    public boolean isPreviousVisible() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return InstallerUtil.isWindows();
    }

    public boolean isShowDirectories() {
        return this.replaceWithTextOverride("showDirectories", this.showDirectories);
    }

    public void setShowDirectories(boolean showDirectories) {
        this.showDirectories = showDirectories;
    }

    @Override
    public void activated() {
        this.failure = this.checkFailure();
        if (this.failure) {
            super.activated();
        } else {
            this.getContext().goForward(1, true, true);
        }
    }

    @Override
    public void deactivated() {
        if (this.failure) {
            System.exit(1);
        } else {
            super.deactivated();
        }
    }

    @Override
    public boolean handleConsole(Console console) throws UserCanceledException {
        if (!super.handleConsole(console)) {
            return false;
        }
        this.setupControls();
        if (this.checkFailure()) {
            console.println(this.getMessage(".UninstallFailureLabel"));
            console.println(this.txaInfo.getText());
            System.exit(1);
        } else {
            this.getUninstallerContext().goForward(1, true, false);
        }
        return true;
    }

    @Override
    protected void setupControls() {
        super.setupControls();
        this.txaInfo = new JTextPane();
        this.txaInfo.setEditable(false);
        this.scpInfo = new JScrollPane(this.txaInfo);
    }

    @Override
    protected void addScreenContent(JPanel panel, GridBagConstraints gc) {
        String headerMessage = this.getMessage(".UninstallFailureLabel");
        if (headerMessage.trim().length() > 0) {
            this.addDisplayTextArea(headerMessage, panel, gc);
        }
        gc.insets.top = 5;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.insets.bottom = 10;
        panel.add((Component)this.scpInfo, gc);
        ++gc.gridy;
    }

    @Override
    public String getTitle() {
        return this.getMessage(".UninstallFailureTitle");
    }

    @Override
    public String getSubTitle() {
        return Messages.format(this.getMessage(".UninstallFailureSubTitle"), this.getApplicationName());
    }

    private boolean checkFailure() {
        String failureText;
        if (InstallerUtil.isWindows()) {
            return false;
        }
        List<File> stillUndeleted = FileInstaller.getInstance().deleteUndeleted();
        StringBuffer buffer = new StringBuffer();
        if (stillUndeleted.size() > 0) {
            this.addFailureText(stillUndeleted, buffer);
        }
        if ((failureText = buffer.toString()).length() > 0) {
            this.txaInfo.setText(failureText);
            return true;
        }
        return false;
    }

    private void addFailureText(List<File> files, StringBuffer buffer) {
        for (File file : files) {
            if (!this.isShowDirectories() && !file.isFile()) continue;
            buffer.append(file.getPath());
            buffer.append("\n");
        }
    }
}

