/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.jideoss.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideSplitButtonUI;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class FlatJideSplitButtonUI
extends BasicJideSplitButtonUI {
    protected String arrowType;
    protected Color buttonArrowColor;
    protected Color buttonDisabledArrowColor;

    public static ComponentUI createUI(JComponent c) {
        LookAndFeelFactory.installJideExtension();
        return new FlatJideSplitButtonUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.arrowType = UIManager.getString("Component.arrowType");
        this.buttonArrowColor = UIManager.getColor("JideSplitButton.buttonArrowColor");
        this.buttonDisabledArrowColor = UIManager.getColor("JideSplitButton.buttonDisabledArrowColor");
    }

    @Override
    protected int getRightMargin() {
        this._splitButtonMargin = UIScale.scale(14);
        this._splitButtonMarginOnMenu = UIScale.scale(20);
        return super.getRightMargin();
    }

    @Override
    protected Rectangle getButtonRect(JComponent c, int orientation, int width, int height) {
        return c.getComponentOrientation().isLeftToRight() ? new Rectangle(0, 0, width - this._splitButtonMargin + 1, height) : new Rectangle(this._splitButtonMargin - 1, 0, width - this._splitButtonMargin + 1, height);
    }

    @Override
    protected Rectangle getDropDownRect(JComponent c, int orientation, int width, int height) {
        return c.getComponentOrientation().isLeftToRight() ? new Rectangle(width - this._splitButtonMargin, 0, this._splitButtonMargin, height) : new Rectangle(0, 0, this._splitButtonMargin, height);
    }

    @Override
    protected void paintText(Graphics g2, JMenuItem menuItem, Rectangle textRect, String text) {
        ButtonModel model = menuItem.getModel();
        if (!model.isEnabled() || menuItem instanceof JideSplitButton && !((JideSplitButton)menuItem).isButtonEnabled()) {
            FontMetrics fm = menuItem.getFontMetrics(menuItem.getFont());
            if (!menuItem.getComponentOrientation().isLeftToRight() && menuItem.getComponentOrientation().isHorizontal()) {
                Rectangle2D rectText = fm.getStringBounds(text, g2);
                textRect.x = (int)((double)(menuItem.getWidth() - textRect.x) - rectText.getWidth() + (double)(4 + menuItem.getHeight() / 2 - 1));
            }
            g2.setColor(UIDefaultsLookup.getColor("Button.disabledForeground"));
            this.drawStringUnderlineCharAt(menuItem, g2, text, -1, textRect.x, textRect.y + fm.getAscent());
        } else {
            super.paintText(g2, menuItem, textRect, text);
        }
    }

    @Override
    protected void paintArrow(JMenuItem menuItem, Graphics g2) {
        g2.setColor(menuItem.isEnabled() ? this.buttonArrowColor : this.buttonDisabledArrowColor);
        int orientation = JideSwingUtilities.getOrientationOf(menuItem);
        int menuWidth = orientation == 0 ? menuItem.getWidth() : menuItem.getHeight();
        int menuHeight = orientation == 0 ? menuItem.getHeight() : menuItem.getWidth();
        Rectangle r = this.getDropDownRect(menuItem, orientation, menuWidth, menuHeight);
        Object[] oldRenderingHints = FlatUIUtils.setRenderingHints(g2);
        FlatUIUtils.paintArrow((Graphics2D)g2, r.x, r.y, r.width, r.height, 5, FlatUIUtils.isChevron(this.arrowType), 6, 1.0f, 0.0f, 0.0f);
        FlatUIUtils.resetRenderingHints(g2, oldRenderingHints);
    }
}

