/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter.condition;

import java.util.Collection;
import java.util.HashSet;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.map.NodeModel;

public class SelectedViewSnapshotCondition
extends ASelectableCondition {
    private static final String NAME = "selected_view_snapshot";
    private static String defaultDescription;
    private final String description;
    HashSet<NodeModel> selectedNodes;

    private static String defaultDescription() {
        if (defaultDescription == null) {
            defaultDescription = TextUtils.getText("filter_selected_node_view_snapshot");
        }
        return defaultDescription;
    }

    public SelectedViewSnapshotCondition(Collection<? extends NodeModel> selectedNodes) {
        this(selectedNodes, SelectedViewSnapshotCondition.defaultDescription());
    }

    public SelectedViewSnapshotCondition(Collection<? extends NodeModel> selectedNodes, String description) {
        this.description = description;
        this.selectedNodes = new HashSet();
        this.selectedNodes.addAll(selectedNodes);
    }

    @Override
    public boolean checkNode(NodeModel node) {
        return this.selectedNodes.contains(node);
    }

    @Override
    protected String createDescription() {
        return this.description;
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    public boolean canBePersisted() {
        return false;
    }
}

