/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources.components;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.OptionPanel;
import org.freeplane.core.resources.components.OptionPanelWindowConfigurationStorage;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.ui.menubuilders.generic.UserRole;
import org.freeplane.core.util.TextUtils;

public class ShowPreferencesAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    public static final String KEY = "ShowPreferencesAction";
    private final DefaultMutableTreeNode controls;
    private String selectedProperty;
    private boolean arePropertyValidatorsEnabled;

    public ShowPreferencesAction(DefaultMutableTreeNode controls, String selectedProperty, boolean arePropertyValidatorsEnabled) {
        super(KEY);
        this.controls = controls;
        this.selectedProperty = selectedProperty;
        this.arePropertyValidatorsEnabled = arePropertyValidatorsEnabled;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand;
        Object source;
        Dialog dialog = null;
        if (e != null && (source = e.getSource()) instanceof Component) {
            Window window = SwingUtilities.getWindowAncestor((Component)source);
            dialog = this.createDialog(window);
        }
        if (dialog == null) {
            dialog = this.createDialog((Window)UITools.getMenuComponent());
        }
        dialog.setResizable(true);
        dialog.setUndecorated(false);
        final OptionPanel options = new OptionPanel((JDialog)dialog, new OptionPanel.IOptionPanelFeedback(){

            @Override
            public void writeProperties(Properties props) {
                boolean propertiesChanged = false;
                for (Object keyObject : props.keySet()) {
                    String key = keyObject.toString();
                    String newProperty = props.getProperty(key);
                    propertiesChanged = propertiesChanged || !newProperty.equals(ResourceController.getResourceController().getProperty(key));
                    ResourceController.getResourceController().setProperty(key, newProperty);
                }
                if (propertiesChanged) {
                    JOptionPane.showMessageDialog(UITools.getMenuComponent(), TextUtils.getText("option_changes_may_require_restart"));
                    ResourceController.getResourceController().saveProperties();
                    UITools.resetMenuBarOnMac();
                }
            }
        });
        if (this.arePropertyValidatorsEnabled) {
            options.enablePropertyValidators();
        }
        String marshalled = ResourceController.getResourceController().getProperty("OptionPanel_Window_Properties");
        OptionPanelWindowConfigurationStorage storage = OptionPanelWindowConfigurationStorage.decorateDialog(marshalled, (JDialog)dialog);
        String string = actionCommand = e != null ? e.getActionCommand() : null;
        if (actionCommand != null && actionCommand.startsWith("OptionPanel.")) {
            options.setSelectedPanel(actionCommand);
        } else if (storage != null) {
            options.setSelectedPanel(storage.getPanel());
        }
        options.buildPanel(this.controls);
        options.setProperties();
        String title = TextUtils.getText("ShowPreferencesAction.dialog");
        dialog.setTitle(title);
        ((JDialog)dialog).setDefaultCloseOperation(2);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                options.closeWindow();
            }
        });
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent arg0) {
                options.closeWindow();
            }
        };
        UITools.addEscapeActionToDialog((JDialog)dialog, action);
        if (storage == null) {
            UITools.setBounds(dialog, -1, -1, dialog.getPreferredSize().width + 50, -1);
        }
        if (this.selectedProperty != null) {
            ComponentAdapter visibilityListener = new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent evt) {
                    options.highlight(ShowPreferencesAction.this.selectedProperty);
                }
            };
            dialog.addComponentListener(visibilityListener);
        }
        dialog.setVisible(true);
    }

    private JDialog createDialog(Window window) {
        JDialog dialog;
        if (window instanceof Dialog) {
            dialog = new JDialog((Dialog)window, true);
        } else if (window instanceof Frame) {
            dialog = new JDialog((Frame)window, true);
        } else {
            return null;
        }
        dialog.applyComponentOrientation(window.getComponentOrientation());
        return dialog;
    }

    @Override
    public void afterMapChange(UserRole userRole) {
    }
}

