/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.complexscripts.fonts.Positionable;
import org.apache.fop.complexscripts.fonts.Substitutable;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontLoader;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.FontUris;
import org.apache.fop.fonts.LazyFont;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.java2d.FontMetricsMapper;

public class CustomFontMetricsMapper
extends Typeface
implements FontMetricsMapper,
Substitutable,
Positionable {
    private Typeface typeface;
    private FontUris fontUris;
    private EmbedFontInfo configFontInfo;
    private InternalResourceResolver resourceResolver;
    private Font font;
    private float size = 1.0f;
    private static final int TYPE1_FONT = 1;

    public CustomFontMetricsMapper(CustomFont fontMetrics) throws FontFormatException, IOException {
        this.typeface = fontMetrics;
        this.initialize(fontMetrics.getInputStream());
    }

    public CustomFontMetricsMapper(LazyFont fontMetrics, InputStream fontSource) throws FontFormatException, IOException {
        this.typeface = fontMetrics;
        this.initialize(fontSource);
    }

    public CustomFontMetricsMapper(FontUris fontUris, EmbedFontInfo configFontInfo, InternalResourceResolver resourceResolver) {
        this.fontUris = fontUris;
        this.configFontInfo = configFontInfo;
        this.resourceResolver = resourceResolver;
    }

    private void initialize(InputStream inStream) throws FontFormatException, IOException {
        int type = 0;
        if (FontType.TYPE1.equals(this.getRealFont().getFontType())) {
            type = 1;
        }
        this.font = Font.createFont(type, inStream);
        inStream.close();
    }

    @Override
    public final String getEncodingName() {
        return null;
    }

    @Override
    public final boolean hasChar(char c) {
        this.getRealFont();
        return this.font.canDisplay(c);
    }

    @Override
    public final char mapChar(char c) {
        return this.getRealFont().mapChar(c);
    }

    @Override
    public final Font getFont(int size) {
        this.getRealFont();
        if (this.size == (float)size) {
            return this.font;
        }
        this.size = (float)size / 1000.0f;
        this.font = this.font.deriveFont(this.size);
        return this.font;
    }

    @Override
    public final int getAscender(int size) {
        return this.getRealFont().getAscender(size);
    }

    @Override
    public final int getCapHeight(int size) {
        return this.getRealFont().getCapHeight(size);
    }

    @Override
    public final int getDescender(int size) {
        return this.getRealFont().getDescender(size);
    }

    @Override
    public final String getEmbedFontName() {
        return this.getRealFont().getEmbedFontName();
    }

    @Override
    public final Set<String> getFamilyNames() {
        return this.getRealFont().getFamilyNames();
    }

    @Override
    public final String getFontName() {
        return this.getRealFont().getFontName();
    }

    @Override
    public final URI getFontURI() {
        return this.getRealFont().getFontURI();
    }

    @Override
    public final FontType getFontType() {
        return this.getRealFont().getFontType();
    }

    @Override
    public final String getFullName() {
        return this.getRealFont().getFullName();
    }

    public final Map getKerningInfo() {
        return this.getRealFont().getKerningInfo();
    }

    @Override
    public final int getWidth(int i, int size) {
        return this.getRealFont().getWidth(i, size);
    }

    @Override
    public final int[] getWidths() {
        return this.getRealFont().getWidths();
    }

    @Override
    public Rectangle getBoundingBox(int glyphIndex, int size) {
        return this.getRealFont().getBoundingBox(glyphIndex, size);
    }

    @Override
    public final int getXHeight(int size) {
        return this.getRealFont().getXHeight(size);
    }

    @Override
    public int getUnderlinePosition(int size) {
        return this.getRealFont().getUnderlinePosition(size);
    }

    @Override
    public int getUnderlineThickness(int size) {
        return this.getRealFont().getUnderlineThickness(size);
    }

    @Override
    public int getStrikeoutPosition(int size) {
        return this.getRealFont().getStrikeoutPosition(size);
    }

    @Override
    public int getStrikeoutThickness(int size) {
        return this.getRealFont().getStrikeoutThickness(size);
    }

    @Override
    public final boolean hasKerningInfo() {
        return this.getRealFont().hasKerningInfo();
    }

    @Override
    public boolean isMultiByte() {
        return this.getRealFont().isMultiByte();
    }

    @Override
    public boolean performsPositioning() {
        if (this.getRealFont() instanceof Positionable) {
            return ((Positionable)((Object)this.typeface)).performsPositioning();
        }
        return false;
    }

    @Override
    public int[][] performPositioning(CharSequence cs, String script, String language, int fontSize) {
        if (this.getRealFont() instanceof Positionable) {
            return ((Positionable)((Object)this.typeface)).performPositioning(cs, script, language, fontSize);
        }
        return null;
    }

    @Override
    public int[][] performPositioning(CharSequence cs, String script, String language) {
        if (this.getRealFont() instanceof Positionable) {
            return ((Positionable)((Object)this.typeface)).performPositioning(cs, script, language);
        }
        return null;
    }

    @Override
    public boolean performsSubstitution() {
        if (this.getRealFont() instanceof Substitutable) {
            return ((Substitutable)((Object)this.typeface)).performsSubstitution();
        }
        return false;
    }

    @Override
    public CharSequence performSubstitution(CharSequence cs, String script, String language, List associations, boolean retainControls) {
        if (this.getRealFont() instanceof Substitutable) {
            return ((Substitutable)((Object)this.typeface)).performSubstitution(cs, script, language, associations, retainControls);
        }
        return cs;
    }

    @Override
    public CharSequence reorderCombiningMarks(CharSequence cs, int[][] gpa, String script, String language, List associations) {
        if (this.getRealFont() instanceof Substitutable) {
            return ((Substitutable)((Object)this.typeface)).reorderCombiningMarks(cs, gpa, script, language, associations);
        }
        return cs;
    }

    public Typeface getRealFont() {
        if (this.typeface == null) {
            try {
                CustomFont fontMetrics = FontLoader.loadFont(this.fontUris, this.configFontInfo.getSubFontName(), true, this.configFontInfo.getEmbeddingMode(), this.configFontInfo.getEncodingMode(), this.configFontInfo.getKerning(), this.configFontInfo.getAdvanced(), this.resourceResolver, this.configFontInfo.getSimulateStyle(), this.configFontInfo.getEmbedAsType1(), this.configFontInfo.getUseSVG());
                this.typeface = fontMetrics;
                this.initialize(fontMetrics.getInputStream());
            }
            catch (FontFormatException | IOException e) {
                throw new RuntimeException("Failed to read font file " + this.fontUris.getEmbed() + " " + e.getMessage(), e);
            }
        }
        return this.typeface;
    }
}

