<a id="readme-top"></a>

# Automated Migration of HyperSwap Volumes to Policy-Based High Availability (PBHA)

This directory contains an Ansible playbook for automating the migration of HyperSwap volumes to Policy-Based High Availability (PBHA). The solution aims to simplify the migration process while ensuring data availability and minimal downtime.

# Table of Contents

- [Overview](#overview)
- [Prerequisites](#prerequisites)
- [Playbooks](#playbooks)
- [Variables](#variables)
- [Migration Steps](#migration-steps)
- [Logs and Output](#logs-and-output)

# Overview

This automation simplifies the migration of HyperSwap volumes to PBHA by handling pool mappings, volume relationships, and high availability configurations, ensuring minimal downtime and reliable transition.

# Prerequisites
- IBM Storage Virtualize ansible collection plugins must be installed.
- Both primary and secondary clusters must be on a PBHA-supported SVC level. Supported SVC levels are: 8.6.0.X & 8.7.0.X

# Playbooks

Migrating HyperSwap to PBHA can be achieved using 2 executable playbooks:
1. migrate_dependent_volumes.yaml :-  
    - Migrates non-HyperSwap (standard) volumes of the site to be removed (e.g. site2) to a pool at the retained site (e.g. site1).
    - Removes the auxiliary copies of HyperSwap volumes.
> [!WARNING] 
> After executing this playbook, a HyperSwap volumes file (`Hyperswap_volumes_of_<system_name>.json`) is created. **DO NOT REMOVE THIS FILE** as it is required for subsequent steps.

2. migrate_hyperswap_to_pbha.yaml :-
    - Changes topology from HyperSwap to standard volumes.
    - Creates a cluster partnership and links pools between clusters.
    - Migrates HyperSwap volumes to PBHA partitions.

> [!IMPORTANT]
> This playbook requires the `HyperSwap_volumes_of_<system_name>.json` file generated by the first playbook.

**CHECK Proposed Folder Structure**  
These playbooks can be found in the repository as - 
```
ibm.storage_virtualize    
│
└─playbooks
  │
  └─hyperswap_to_pbha_migration
    │
    └─migrate_dependent_volumes.yaml
    └─migrate_hyperswap_to_pbha.yaml
    └─inventory.ini
    └─README.md
    └─...
...
```
<p align="right">(<a href="#readme-top">back to top</a>)</p>

# Variables

| Variable                         | Required | Default                    | Notes                                                                                                                 |
|----------------------------------|----------|----------------------------|-----------------------------------------------------------------------------------------------------------------------|
| primary_clustername              | yes      | X                          | Cluster name of the primary system.                                                                                   |
| primary_cluster_username         | yes      | X                          | Username for authentication on the primary system.                                                                    |
| primary_cluster_password         | yes      | X                          | Password for authentication on the primary system.                                                                    |
| target_pool                      | yes      | X                          | Name of the pool to which the volumes from the site being removed will be migrates.                                   |
| site_to_retain                   | no       | site1                      | Name of the site to be retained during migration.                                                                     |
| site_to_remove                   | no       | site2                      | Name of the site to be removed during migration.                                                                      |
| secondary_clustername            | yes      | X                          | Cluster name of the auxiliary (secondary) system.                                                                     |
| secondary_cluster_username       | yes      | X                          | Username for authentication on the auxiliary system.                                                                  |
| secondary_cluster_password       | yes      | X                          | Password for authentication on the auxiliary system.                                                                  |
| drive_counts                     | yes      | X                          | Array containing the count of drives in each pool, used for validation.For e.g., for 2 pools, the required format is [X, X].|
| volume_group_name                | no       | ha_volume_grp              | Name of the volume group to be created or used.                                                                       |
| location_1_iogrp                 | no       | 0                          | ID of the IO Group on the primary cluster for replication policy.                                                     |
| location_2_iogrp                 | no       | 0                          | ID of the IO Group on the secondary cluster for replication policy.                                                   |
| ha_replication_policy_name       | no       | ha_rep_policy_0            | Name of the High availability replication policy to be created or applied.                                            |
| ha_partition_name                | no       | ha_partition               | Name of the partition to be created or used for PBHA.                                                                 |
| partnership_type                 | yes      | X                          | Type of partnership between clusters. Options are `fc` or `rdma`(Remote Direct Memory Access).                        |
| truststore_name                  | no       | ts_0                       | Name of the truststore to be created or managed.                                                                      |
| use_existing_certificates        | no       | true                       | Specifies whether the system should use a existing certificate.                                                       |
| linkbandwidth_mbits              | no       | 8000                       | Maximum link bandwidth (in Mbps) for replication between clusters.                                                    |
| background_copyrate              | no       | 50                         | Background copy rate (in percentage) during the migration.                                                            |
| portset_name                     | no       | hse1                       | Name of the RDMA port set to be used. *(Required for `rdma` partnership)*                                             |
| ip_for_primary_cluster           | yes      | X                          | IP address of the primary cluster. *(Required for `rdma` partnership)*                           |
| primary_cluster_node_name        | yes      | X                          | Node name of the primary cluster . *(Required for `rdma` partnership)*                            |
| primary_cluster_port_id          | yes      | X                          | Port ID on the primary cluster . *(Required for `rdma` partnership)*                              |
| primary_cluster_subnet_prefix    | yes      | X                          | Subnet prefix for the primary cluster . *(Required for `rdma` partnership)*                       |
| ip_for_secondary_cluster         | yes      | X                          | IP address of the secondary cluster . *(Required for `rdma` partnership)*                         |
| secondary_cluster_node_name      | yes      | X                          | Node name of the secondary cluster . *(Required for `rdma` partnership)*                          |
| secondary_cluster_port_id        | yes      | X                          | Port ID on the secondary cluster . *(Required for `rdma` partnership)*                            |
| secondary_cluster_subnet_prefix  | yes      | X                          | Subnet prefix for the secondary cluster . *(Required for `rdma` partnership)*                     |
| rdma_partnership_type            | no       | ipv4                       | Type of IP protocol used  (e.g., ipv4 or ipv6). *(Required for `rdma` partnership)*               |

**Example inventory.ini File**  
Here is an example inventory.ini file that demonstrates how to configure the variables:
```
primary_clustername: x.x.x.x
primary_cluster_username: superuser
primary_cluster_password: passw0rd
target_pool: pool_0
site_to_retain: site1
site_to_remove: site2
secondary_clustername: y.y.y.y
secondary_cluster_username: superuser
secondary_cluster_password: passw0rd
drive_counts: [2, 2, 2]
volume_group_name: HA_Vol_Grp_0
location_1_iogrp: 0
location_2_iogrp: 0
ha_replication_policy_name: HA_policy_0
ha_partition_name: HA_Partition_0
partnership_type: fc
truststore_name: ts_0
use_existing_certificates: true
linkbandwidth_mbits: 10000
background_copyrate: 50

# Required only for RDMA partnership
portset_name: test_hse
ip_for_primary_cluster: a.a.a.a
primary_cluster_node_name: node1
primary_cluster_port_id: 7
primary_cluster_subnet_prefix: 24
ip_for_secondary_cluster: b.b.b.b
secondary_cluster_node_name: node1
secondary_cluster_port_id: 7
secondary_cluster_subnet_prefix: 24
rdma_partnership_type: ipv4
```
<p align="right">(<a href="#readme-top">back to top</a>)</p>

# Migration Steps  

### migrate_dependent_volumes.yml  
Tasks performed via this playbook:  
- Verify that the target pool exists and is compatible.  
- Migrate volumes to the target pool.
- Save information about the HyperSwap volumes for use in subsequent tasks.
- Remove the auxiliary volume copy after the migration.  
- Free up secondary site's space by removing unused pool.

> [!IMPORTANT]
> After completing these steps, the user must remove site2 nodes from cluster, create a new cluster with these nodes, and update the inventory with the new cluster details.

### migrate_hyperswap_to_pbha.yml
Tasks performed via this playbook:
- Change topology from HyperSwap to standard.  
- Create a partnership between clusters.
- Create new pool(s) on the secondary cluster and link it with the corresponding pool on primary cluster.  
- Create a volume group and add the HyperSwap volumes to it.  
- Create a partition, add volume group(s) to it, publish it and make it highly available by assigning HA replication policy.

> [!Note]
> After the successful execution of the playbooks, the quorum application is set up. The user must transfer the application to the designated host and run it to complete the configuration. Ensure that the host environment meets all necessary prerequisites for running the quorum application.

# Logs and Output
- **Log File**: `HyperSwap_PBHA_migration_of_<system1>_and_<system2>.log` contains detailed information about the migration process.

- **JSON File:** `HyperSwap_volumes_of_<system_name>.json` required for subsequent steps. Do not delete unless the migration process is complete.


# Authors:
- Sumit Kumar Gupta (sumit.gupta16@ibm.com)  
- Aditya Bhosale (aditya.bhosale5@ibm.com)

<p align="right">(<a href="#readme-top">back to top</a>)</p>
