
// Mage Boss (Menelkir) -----------------------------------------------------

class MageBoss : Actor
{
	Default
	{
		Health 800;
		PainChance 50;
		Speed 25;
		Radius 16;
		Height 64;
		Monster;
		+FLOORCLIP +TELESTOMP
		+DONTMORPH
		PainSound "PlayerMagePain";
		DeathSound "PlayerMageCrazyDeath";
		Obituary "$OB_MBOSS";
		Tag "$FN_MBOSS";
	}

	States
	{
	Spawn:
		MAGE A 2;
		MAGE A 3 A_ClassBossHealth;
		MAGE A 5 A_Look;
		Wait;
	See:
		MAGE ABCD 4 A_FastChase;
		Loop;
	Pain:
		MAGE G 4;
		MAGE G 4 A_Pain;
		Goto See;
	Melee:
	Missile:
		MAGE E 8 A_FaceTarget;
		MAGE F 8 Bright A_MageAttack;
		Goto See;
	Death:
		MAGE H 6;
		MAGE I 6 A_Scream;
		MAGE JK 6;
		MAGE L 6 A_NoBlocking;
		MAGE M 6;
		MAGE N -1;
		Stop;
	XDeath:
		MAGE O 5 A_Scream;
		MAGE P 5;
		MAGE R 5 A_NoBlocking;
		MAGE S 5;
		MAGE T 5;
		MAGE U 5;
		MAGE V 5;
		MAGE W 5;
		MAGE X -1;
		Stop;
	Ice:
		MAGE Y 5 A_FreezeDeath;
		MAGE Y 1 A_FreezeDeathChunks;
		Wait;
	Burn:
		FDTH E 5 Bright A_StartSound("PlayerMageBurnDeath");
		FDTH F 4 Bright;
		FDTH G 5 Bright;
		FDTH H 4 Bright A_Scream;
		FDTH I 5 Bright;
		FDTH J 4 Bright;
		FDTH K 5 Bright;
		FDTH L 4 Bright;
		FDTH M 5 Bright;
		FDTH N 4 Bright;
		FDTH O 5 Bright;
		FDTH P 4 Bright;
		FDTH Q 5 Bright;
		FDTH R 4 Bright;
		FDTH S 5 Bright A_NoBlocking;
		FDTH T 4 Bright;
		FDTH U 5 Bright;
		FDTH V 4 Bright;
		Stop;
	}

	//============================================================================
	//
	// MStaffSpawn2 - for use by mage class boss
	//
	//============================================================================

	void MStaffSpawn2 (double angle)
	{
		Actor mo = SpawnMissileAngleZ (pos.z + 40, "MageStaffFX2", angle, 0.);
		if (mo)
		{
			mo.target = self;
			mo.tracer = RoughMonsterSearch(10, true, true);
		}
	}

	//============================================================================
	//
	// A_MStaffAttack2 - for use by mage class boss
	//
	//============================================================================

	void A_MageAttack()
	{
		if (target == NULL)
		{
			return;
		}
		MStaffSpawn2(angle);
		MStaffSpawn2(angle - 5);
		MStaffSpawn2(angle + 5);
		A_StartSound("MageStaffFire", CHAN_WEAPON);
	}
	
}
