/*
 * graph.c: Edge/vertex functionality for rotoscope.
 *
 * 
 * Copyright 2006, James Foster
 *
 * This file is part of rotoscope.
 *
 * Rotoscope is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rotoscope is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with rotoscope; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>

#include "graph.h"

Vertex* create_vertex( unsigned int x, unsigned int y )
{
	Vertex* v = malloc( sizeof(Vertex) );
	if( NULL == v )
	{
		return NULL;
	}
	v->x = x;
	v->y = y;
	return v;
}

gboolean save_graph_to_file( GList* edges, char* filename )
{
	Edge* e;
	
	/* Open the file */
	FILE* f = fopen( filename, "w" );
	if( NULL == f )
	{
		return FALSE;
	}
	
	/* Write the graph to the file */
	while( NULL != edges )
	{
		e = edges->data;
		
		if( fprintf(f, "%u %u %u %u\n", e->a.x, e->a.y, e->b.x, e->b.y) < 0 )
		{
			return FALSE;
		}
		edges = g_list_next( edges );
	}

	fclose( f );
}

GList* load_graph_from_file( char* filename )
{
	Edge* e;
	GList* edges = NULL;
	
	/* Open the file */
	FILE* f = fopen( filename, "r" );
	if( NULL == f )
	{
		return NULL;
	}
	
	/* Read the edges into the GList */
	while( 1 )
	{
		e = malloc( sizeof(Edge) );
		if( NULL == e )
		{
			/* TODO: Free the GList and then return NULL */
		}
		if( EOF == fscanf(f, "%u%u%u%u", &e->a.x, &e->a.y, &e->b.x, &e->b.y) )
		{
			free( e );
			break;
		}
		edges = g_list_prepend( edges, e );
	}

	fclose( f );
	return edges;
}

