/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.sh.psi.ShIncludeCommand;
import com.intellij.sh.psi.ShSimpleCommandElement;
import com.intellij.sh.psi.ShString;
import com.intellij.sh.psi.impl.ShCommandImpl;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ShIncludeCommandMixin
extends ShCommandImpl
implements ShIncludeCommand {
    ShIncludeCommandMixin(ASTNode node) {
        super(node);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        List commandsList;
        if (processor == null) {
            ShIncludeCommandMixin.$$$reportNull$$$0(0);
        }
        if (state == null) {
            ShIncludeCommandMixin.$$$reportNull$$$0(1);
        }
        if (place == null) {
            ShIncludeCommandMixin.$$$reportNull$$$0(2);
        }
        if ((commandsList = this.getSimpleCommandElementList()).size() <= 0) {
            return true;
        }
        ShSimpleCommandElement simpleCommandElement = (ShSimpleCommandElement)commandsList.get(0);
        PsiFile includedPsiFile = this.getReferencingFile(simpleCommandElement);
        if (includedPsiFile == null) {
            return true;
        }
        VirtualFile sourceFile = place.getContainingFile().getVirtualFile();
        if (includedPsiFile.getVirtualFile().equals(sourceFile)) {
            return true;
        }
        return includedPsiFile.processDeclarations(processor, state, (PsiElement)this, place);
    }

    @Nullable
    public PsiFile getReferencingFile(@NotNull PsiElement element) {
        PsiDirectory containingDirectory;
        if (element == null) {
            ShIncludeCommandMixin.$$$reportNull$$$0(3);
        }
        String relativeFilePath = element.getText();
        if (element instanceof ShString) {
            ShString shString = (ShString)element;
            if (relativeFilePath.length() >= 2 && shString.getOpenQuote() != null && shString.getCloseQuote() != null || shString.getRawString() != null && relativeFilePath.startsWith("'") && relativeFilePath.endsWith("'")) {
                relativeFilePath = relativeFilePath.substring(1, relativeFilePath.length() - 1);
            }
        } else if (relativeFilePath.contains("\\ ")) {
            relativeFilePath = relativeFilePath.replace("\\ ", " ");
        }
        if ((containingDirectory = this.getContainingFile().getContainingDirectory()) == null) {
            return null;
        }
        VirtualFile relativeFile = VfsUtilCore.findRelativeFile((String)relativeFilePath, (VirtualFile)containingDirectory.getVirtualFile());
        if (relativeFile == null) {
            return null;
        }
        return PsiManager.getInstance((Project)this.getProject()).findFile(relativeFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sh/psi/impl/ShIncludeCommandMixin";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferencingFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

