/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.components;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.graph.impl.view.DefaultBackgroundRendererImpl;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.components.ZoomableViewport;
import com.intellij.ui.components.ZoomingDelegate;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UmlGraphZoomableViewport
extends JBPanelWithEmptyText
implements ZoomableViewport,
Magnificator,
UISettingsListener,
EditorColorsListener,
Disposable {
    private Graph2DView myView;
    private ZoomingDelegate myDelegate;
    private DiagramBuilder myBuilder;

    public UmlGraphZoomableViewport(DiagramBuilder builder) {
        super((LayoutManager)new BorderLayout());
        this.myBuilder = builder;
        this.myView = builder.getView();
        this.setBackground(this.myBuilder.getColorScheme().getDefaultBackground());
        Component component = this.myView.getComponent();
        for (JComponent c : UIUtil.uiTraverser((Component)component).filter(JComponent.class)) {
            c.setOpaque(true);
        }
        this.add(component, "Center");
    }

    @Nullable
    public DiagramBuilder getBuilder() {
        return this.myBuilder;
    }

    public void dispose() {
        this.myBuilder = null;
        this.myView = null;
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            UmlGraphZoomableViewport.$$$reportNull$$$0(0);
        }
        this.updateView();
    }

    public void globalSchemeChange(@Nullable EditorColorsScheme scheme) {
        this.updateView();
    }

    protected void updateView() {
        this.setBackground(this.myBuilder.getColorScheme().getDefaultBackground());
        DiagramPresentationModelImpl.updateColorsOf(this.myBuilder);
        this.myBuilder.queryUpdate().withDataReload().withPresentationUpdate().run();
        this.repaint();
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.myView != null) {
            ((DefaultBackgroundRendererImpl)this.myView.getBackgroundRenderer()).setColor(bg);
        }
    }

    public Magnificator getMagnificator() {
        return this;
    }

    public void paint(Graphics g) {
        if (this.myDelegate != null && this.myDelegate.isActive()) {
            this.myDelegate.paint(g);
        } else {
            super.paint(g);
        }
    }

    public Point magnify(double scale, Point at) {
        double oldZoom = this.myBuilder.getZoom();
        double newZoom = oldZoom * scale;
        double oldX = this.myView.toWorldCoordX(at.x);
        double oldY = this.myView.toWorldCoordY(at.y);
        this.myBuilder.setZoom(newZoom);
        this.myBuilder.getGraphBuilder().setZoom(newZoom, true, () -> {
            double newX = this.myView.toWorldCoordX(at.x);
            double newY = this.myView.toWorldCoordY(at.y);
            double cx = this.myView.getCenter().getX();
            double cy = this.myView.getCenter().getY();
            this.myView.setCenter(cx + oldX - newX, cy + oldY - newY);
        });
        return new Point(0, 0);
    }

    public void magnificationStarted(Point at) {
        this.myDelegate = new ZoomingDelegate(this, (JComponent)this.myView.getComponent(), (JComponent)((Object)this)){

            protected void scrollTo(int voffset, int hoffset) {
            }

            protected Point convertToContentCoordinates(Point point) {
                return point;
            }
        };
        this.myDelegate.magnificationStarted(at);
    }

    public void magnificationFinished(double magnification) {
        this.myDelegate.magnificationFinished(magnification);
        this.myDelegate = null;
    }

    public void magnify(double magnification) {
        this.myDelegate.magnify(magnification);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiSettings", "com/intellij/uml/components/UmlGraphZoomableViewport", "uiSettingsChanged"));
    }
}

