/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.components;

import com.intellij.diagram.util.DiagramIconUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.services.GraphExportService;
import com.intellij.openapi.graph.util.Futures;
import com.intellij.openapi.util.Iconable;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import javax.swing.Icon;
import net.jcip.annotations.GuardedBy;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiagramNodeDeferredIconsEvaluator {
    private static final int EVALUATION_DELAY = 200;
    @GuardedBy(value="myEvaluationStartAlarmLock")
    @NotNull
    private final Alarm myEvaluationStartAlarm = new Alarm();
    @NotNull
    private final Object myEvaluationStartAlarmLock = new Object();
    @NotNull
    private static final DiagramNodeDeferredIconsEvaluator INSTANCE = new DiagramNodeDeferredIconsEvaluator();
    @GuardedBy(value="myPendingIconsLock")
    @NotNull
    private final List<MyIconEvaluationTask> myPendingIcons = new ArrayList<MyIconEvaluationTask>();
    @NotNull
    private final Object myPendingIconsLock = new Object();

    @NotNull
    public static DiagramNodeDeferredIconsEvaluator getInstance() {
        DiagramNodeDeferredIconsEvaluator diagramNodeDeferredIconsEvaluator = INSTANCE;
        if (diagramNodeDeferredIconsEvaluator == null) {
            DiagramNodeDeferredIconsEvaluator.$$$reportNull$$$0(0);
        }
        return diagramNodeDeferredIconsEvaluator;
    }

    private DiagramNodeDeferredIconsEvaluator() {
    }

    @Nullable
    public Icon registerEvaluationOrGetReadyIcon(@NotNull Iconable iconOwner, @Nullable Consumer<Icon> onEvaluationDone) {
        if (iconOwner == null) {
            DiagramNodeDeferredIconsEvaluator.$$$reportNull$$$0(1);
        }
        return this.registerEvaluationOrGetReadyIcon(iconOwner.getIcon(1), onEvaluationDone);
    }

    @Contract(value="_, _ -> param2")
    @Nullable
    public Icon registerEvaluationOrGetReadyIcon(@Nullable Icon icon, @Nullable Consumer<Icon> onEvaluationDone) {
        if (icon != null && DiagramIconUtil.isDeferred(icon)) {
            if (GraphExportService.getInstance().isExportMode() || GraphExportService.getInstance().isPrintMode()) {
                return DiagramNodeDeferredIconsEvaluator.evaluateIconNow(icon, onEvaluationDone);
            }
            this.requestIconEvaluation(icon, onEvaluationDone);
        }
        return icon;
    }

    @NotNull
    private static Icon evaluateIconNow(@NotNull Icon icon, @Nullable Consumer<Icon> onEvaluationDone) {
        if (icon == null) {
            DiagramNodeDeferredIconsEvaluator.$$$reportNull$$$0(2);
        }
        MyIconEvaluationTask evaluationTask = new MyIconEvaluationTask(icon, onEvaluationDone);
        evaluationTask.evaluate();
        Icon icon2 = evaluationTask.getCurrentIcon();
        if (icon2 == null) {
            DiagramNodeDeferredIconsEvaluator.$$$reportNull$$$0(3);
        }
        return icon2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestIconEvaluation(@NotNull Icon icon, @Nullable Consumer<Icon> onEvaluationDone) {
        if (icon == null) {
            DiagramNodeDeferredIconsEvaluator.$$$reportNull$$$0(4);
        }
        Object object = this.myPendingIconsLock;
        synchronized (object) {
            this.myPendingIcons.add(new MyIconEvaluationTask(icon, onEvaluationDone));
            this.rescheduleIconEvaluation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rescheduleIconEvaluation() {
        Object object = this.myEvaluationStartAlarmLock;
        synchronized (object) {
            this.myEvaluationStartAlarm.cancelAllRequests();
            this.myEvaluationStartAlarm.addRequest(() -> this.runDeferredIconsEvaluationAsync(), 200);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private List<MyIconEvaluationTask> retrieveIconEvaluationRequests() {
        Object object = this.myPendingIconsLock;
        // MONITORENTER : object
        ArrayList<MyIconEvaluationTask> tasks = new ArrayList<MyIconEvaluationTask>(this.myPendingIcons);
        this.myPendingIcons.clear();
        ArrayList<MyIconEvaluationTask> arrayList = tasks;
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        DiagramNodeDeferredIconsEvaluator.$$$reportNull$$$0(5);
        return arrayList;
    }

    @NotNull
    private CompletableFuture<Void> runDeferredIconsEvaluationAsync() {
        CompletionStage completionStage = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            List<MyIconEvaluationTask> tasks = this.retrieveIconEvaluationRequests();
            ArrayList<Runnable> callbacks = new ArrayList<Runnable>();
            for (MyIconEvaluationTask task : tasks) {
                task.evaluate();
                Consumer<Icon> callback = task.getCallback();
                if (callback == null) continue;
                callbacks.add(() -> callback.accept(task.getCurrentIcon()));
            }
            return callbacks;
        }, AppExecutorUtil.getAppExecutorService()).thenAcceptAsync(callbacks -> callbacks.forEach(it -> it.run()), Futures.inEdt())).whenComplete(Futures.logIfFailed(DiagramNodeDeferredIconsEvaluator.class));
        if (completionStage == null) {
            DiagramNodeDeferredIconsEvaluator.$$$reportNull$$$0(6);
        }
        return completionStage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/components/DiagramNodeDeferredIconsEvaluator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconOwner";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/components/DiagramNodeDeferredIconsEvaluator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateIconNow";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveIconEvaluationRequests";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "runDeferredIconsEvaluationAsync";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerEvaluationOrGetReadyIcon";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "evaluateIconNow";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "requestIconEvaluation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4 -> new IllegalArgumentException(string);
        };
    }

    private static final class MyIconEvaluationTask {
        @NotNull
        private volatile Icon myCurrentIcon;
        @Nullable
        private final Consumer<Icon> myCallback;

        private MyIconEvaluationTask(@NotNull Icon currentIcon, @Nullable Consumer<Icon> onEvaluationDone) {
            if (currentIcon == null) {
                MyIconEvaluationTask.$$$reportNull$$$0(0);
            }
            this.myCurrentIcon = currentIcon;
            this.myCallback = onEvaluationDone;
        }

        private void evaluate() {
            try {
                Icon evaluated;
                this.myCurrentIcon = evaluated = (Icon)ReadAction.compute(() -> DiagramIconUtil.evaluateDeferred(this.myCurrentIcon));
            }
            catch (Exception e) {
                Logger.getInstance(MyIconEvaluationTask.class).error((Throwable)e);
            }
        }

        @NotNull
        private Icon getCurrentIcon() {
            Icon icon = this.myCurrentIcon;
            if (icon == null) {
                MyIconEvaluationTask.$$$reportNull$$$0(1);
            }
            return icon;
        }

        @Nullable
        private Consumer<Icon> getCallback() {
            return this.myCallback;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentIcon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/components/DiagramNodeDeferredIconsEvaluator$MyIconEvaluationTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/components/DiagramNodeDeferredIconsEvaluator$MyIconEvaluationTask";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

