/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.codeInsight.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.liquibase.codeInsight.LiquibaseProperty;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Key;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lcom/intellij/liquibase/codeInsight/completion/LiquibasePropertyRenderer;", "Lcom/intellij/codeInsight/lookup/LookupElementRenderer;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "<init>", "()V", "LIQUIBASE_CONFIG_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/liquibase/codeInsight/LiquibaseProperty;", "getLIQUIBASE_CONFIG_KEY", "()Lcom/intellij/openapi/util/Key;", "renderElement", "", "element", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "intellij.liquibase"})
final class LiquibasePropertyRenderer
extends LookupElementRenderer<LookupElement> {
    @NotNull
    public static final LiquibasePropertyRenderer INSTANCE = new LiquibasePropertyRenderer();
    @NotNull
    private static final Key<LiquibaseProperty> LIQUIBASE_CONFIG_KEY;

    private LiquibasePropertyRenderer() {
    }

    @NotNull
    public final Key<LiquibaseProperty> getLIQUIBASE_CONFIG_KEY() {
        return LIQUIBASE_CONFIG_KEY;
    }

    public void renderElement(@NotNull LookupElement element, @NotNull LookupElementPresentation presentation) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Object object = element.getUserData(LIQUIBASE_CONFIG_KEY);
        Intrinsics.checkNotNull((Object)object);
        LiquibaseProperty item = (LiquibaseProperty)object;
        presentation.setIcon(IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Property));
        presentation.setTypeText(item.getType());
        presentation.setItemText(element.getLookupString());
        if (item.getDefaultValue() != null) {
            TextAttributes attrs = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PropertiesComponent.PROPERTY_VALUE.getTextAttributesKey());
            presentation.setTailText("=" + item.getDefaultValue(), attrs.getForegroundColor());
        }
        if (item.getDescription() != null) {
            presentation.appendTailText(" (" + item.getDescription() + ")", true);
        }
    }

    static {
        Key key = Key.create((String)"LIQUIBASE_CONFIG_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        LIQUIBASE_CONFIG_KEY = key;
    }
}

