/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.data.ql;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.constants.JpaAnnotationConstants;
import com.intellij.javaee.utils.persistence.data.QLInjectorContext;
import com.intellij.jpa.DefaultQlModel;
import com.intellij.jpa.facet.JpaConfigurationModel;
import com.intellij.jpa.ql.QlFile;
import com.intellij.jpa.ql.model.QlModel;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.micronaut.data.MicronautDataUtil;
import com.intellij.micronaut.data.ql.MicronautDataDomainModel;
import com.intellij.micronaut.data.ql.language.MicronautDataQLLanguage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.sql.psi.SqlLanguage;
import java.util.List;
import java.util.Set;
import kotlin.Pair;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UStringConcatenationsFacade;

final class MicronautDataQLInjector
implements MultiHostInjector {
    private static final Set<String> QUERY_ANNOTATIONS = Set.of("io.micronaut.data.annotation.Query");

    MicronautDataQLInjector() {
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List list = QLInjectorContext.elementsToInjectIn();
        if (list == null) {
            MicronautDataQLInjector.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        if (registrar == null) {
            MicronautDataQLInjector.$$$reportNull$$$0(1);
        }
        if (context == null) {
            MicronautDataQLInjector.$$$reportNull$$$0(2);
        }
        if (!QLInjectorContext.isInjectionTarget((PsiElement)context)) {
            return;
        }
        Project project = context.getProject();
        if (!MicronautDataUtil.hasMicronautDataSupport(project)) {
            return;
        }
        UStringConcatenationsFacade concatenationsFacade = UStringConcatenationsFacade.getConcatenationsFacade((PsiElement)context);
        if (concatenationsFacade == null) {
            return;
        }
        if (!concatenationsFacade.getUastOperands().iterator().hasNext()) {
            return;
        }
        Sequence hosts = concatenationsFacade.getPsiLanguageInjectionHosts();
        PsiLanguageInjectionHost theFirstHost = (PsiLanguageInjectionHost)SequencesKt.firstOrNull((Sequence)hosts);
        if (theFirstHost != null && this.isQueryAnnotationHost((PsiElement)theFirstHost)) {
            Language languageToInject = MicronautDataQLInjector.getLanguageToInject(theFirstHost);
            registrar.startInjecting(languageToInject);
            for (PsiLanguageInjectionHost host : SequencesKt.asIterable((Sequence)hosts)) {
                registrar.addPlace(null, null, host, ElementManipulators.getValueTextRange((PsiElement)host));
            }
            registrar.doneInjecting();
            theFirstHost.putUserData(QlFile.PERSISTENCE_MODEL_KEY, (Object)MicronautDataQLInjector.getQlModel((PsiElement)theFirstHost));
        }
    }

    public boolean isQueryAnnotationHost(@NotNull PsiElement host) {
        String annotationParamName;
        Pair annotationEntry;
        if (host == null) {
            MicronautDataQLInjector.$$$reportNull$$$0(3);
        }
        if (host instanceof PsiLanguageInjectionHost && (annotationEntry = UAnnotationUtils.getContainingUAnnotationEntry((UElement)UastContextKt.toUElement((PsiElement)host))) != null && ((annotationParamName = (String)annotationEntry.getSecond()) == null || "value".equals(annotationParamName) || "countQuery".equals(annotationParamName))) {
            UAnnotation annotation = (UAnnotation)annotationEntry.getFirst();
            return !host.getProject().isDefault() && MicronautDataQLInjector.isQueryAnnotation(annotation);
        }
        return false;
    }

    private static boolean isQueryAnnotation(@NotNull UAnnotation psiAnnotation) {
        String name;
        if (psiAnnotation == null) {
            MicronautDataQLInjector.$$$reportNull$$$0(4);
        }
        return (name = psiAnnotation.getQualifiedName()) != null && QUERY_ANNOTATIONS.contains(name);
    }

    private static Language getLanguageToInject(PsiLanguageInjectionHost host) {
        UAnnotation sqlRepoAnnotation;
        UElement uHost = UastContextKt.toUElement((PsiElement)host);
        Pair annotationEntry = UAnnotationUtils.getContainingAnnotationEntry((UElement)uHost);
        if (annotationEntry == null) {
            return MicronautDataQLLanguage.INSTANCE;
        }
        UClass declaredInClass = (UClass)UastUtils.findContaining((PsiElement)host, UClass.class);
        if (declaredInClass != null && (sqlRepoAnnotation = MicronautDataQLInjector.findSqlRepositoryAnnotation(declaredInClass)) != null) {
            Object dialectNameValue;
            UExpression dialectNameAttr;
            String dialectName = null;
            UExpression dialectAttr = sqlRepoAnnotation.findAttributeValue("dialect");
            if (dialectAttr instanceof UReferenceExpression) {
                dialectName = ((UReferenceExpression)dialectAttr).getResolvedName();
            }
            if ((dialectNameAttr = sqlRepoAnnotation.findAttributeValue("dialectName")) != null && (dialectNameValue = dialectNameAttr.evaluate()) instanceof String) {
                dialectName = (String)dialectNameValue;
            }
            return MicronautDataQLInjector.getDialect(dialectName);
        }
        PsiAnnotation annotation = (PsiAnnotation)annotationEntry.getFirst();
        if (annotation.getProject().isDefault()) {
            return MicronautDataQLLanguage.INSTANCE;
        }
        PsiAnnotationMemberValue nativeQueryMemberValue = annotation.findAttributeValue("nativeQuery");
        if (nativeQueryMemberValue == null) {
            return MicronautDataQLLanguage.INSTANCE;
        }
        Boolean value = (Boolean)JamCommonUtil.getObjectValue((PsiElement)nativeQueryMemberValue, Boolean.class);
        if (value != null && value.booleanValue()) {
            return SqlLanguage.INSTANCE;
        }
        return MicronautDataQLLanguage.INSTANCE;
    }

    @Nullable
    private static UAnnotation findSqlRepositoryAnnotation(UClass declaredInClass) {
        UAnnotation sqlRepoAnnotation = declaredInClass.findAnnotation("io.micronaut.data.jdbc.annotation.JdbcRepository");
        if (sqlRepoAnnotation == null) {
            sqlRepoAnnotation = declaredInClass.findAnnotation("io.micronaut.data.r2dbc.annotation.R2dbcRepository");
        }
        return sqlRepoAnnotation;
    }

    private static Language getDialect(@Nullable String dialectEnumValue) {
        if (dialectEnumValue == null) {
            return SqlLanguage.INSTANCE;
        }
        Language sqlLanguage = switch (dialectEnumValue) {
            case "H2" -> Language.findLanguageByID((String)"H2");
            case "MYSQL" -> Language.findLanguageByID((String)"MySQL");
            case "POSTGRES" -> Language.findLanguageByID((String)"PostgreSQL");
            case "SQL_SERVER" -> Language.findLanguageByID((String)"TSQL");
            case "ORACLE" -> Language.findLanguageByID((String)"Oracle");
            default -> null;
        };
        return sqlLanguage != null ? sqlLanguage : SqlLanguage.INSTANCE;
    }

    @NotNull
    private static QlModel getQlModel(PsiElement host) {
        PsiClass domainClass;
        PsiElement originalElement = host.getOriginalElement();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)originalElement);
        MicronautDataDomainModel model = new MicronautDataDomainModel(originalElement);
        if (module != null && JpaConfigurationModel.hasJpaSupport((Module)module) && (domainClass = model.getDomainClass(originalElement)) != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)domainClass, (String)JpaAnnotationConstants.ENTITY_ANNO.fqn(module), (int)1)) {
            return new DefaultQlModel(false, module);
        }
        MicronautDataDomainModel micronautDataDomainModel = model;
        if (micronautDataDomainModel == null) {
            MicronautDataQLInjector.$$$reportNull$$$0(5);
        }
        return micronautDataDomainModel;
    }

    static {
        MicronautDataQLLanguage.INSTANCE.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/micronaut/data/ql/MicronautDataQLInjector";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/micronaut/data/ql/MicronautDataQLInjector";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getQlModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isQueryAnnotationHost";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isQueryAnnotation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

