/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.utils;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInspection.dataFlow.StringExpressionHelper;
import com.intellij.facet.FacetFinder;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.model.search.SearchContext;
import com.intellij.model.search.SearchService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.uast.UCallExpressionPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PackageScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.semantic.SemService;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringSchemaVersion;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamPsiMemberSpringBean;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.stereotype.SpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringComponentScan;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.stereotype.SpringJamPropertySource;
import com.intellij.spring.model.jam.stereotype.SpringPropertySources;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.xml.BeanNameProvider;
import com.intellij.spring.model.xml.BeanTypeProvider;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.DomSpringBeanPointer;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.CollectionElements;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public final class SpringCommonUtils {
    public static final String SPRING_DELIMITERS = ",; ";
    public static final CharFilter ourFilter = ch -> SPRING_DELIMITERS.indexOf(ch) >= 0;
    private static final Key<ParameterizedCachedValue<Boolean, Module>> IS_SPRING_CONFIGURED_KEY = Key.create((String)"IS_SPRING_CONFIGURED_IN_MODULE");
    private static final List<String> ENTRY_POINTS = List.of("org.springframework.context.annotation.Bean", "org.springframework.jmx.export.annotation.ManagedOperation", "org.springframework.jmx.export.annotation.ManagedAttribute", "org.springframework.scheduling.annotation.Scheduled", "org.springframework.scheduling.annotation.Schedules", "org.springframework.context.event.EventListener", "org.springframework.transaction.event.TransactionalEventListener", "javax.annotation.PostConstruct", "jakarta.annotation.PostConstruct", "javax.annotation.PreDestroy", "jakarta.annotation.PreDestroy");
    private static final ParameterizedCachedValueProvider<Boolean, Module> IS_SPRING_CONFIGURED_PROVIDER = new ParameterizedCachedValueProvider<Boolean, Module>(){

        public CachedValueProvider.Result<Boolean> compute(Module module) {
            return CachedValueProvider.Result.create((Object)1.isSpringFacetConfigured(module), (Object[])new Object[]{JavaLibraryModificationTracker.getInstance((Project)module.getProject()), FacetFinder.getInstance((Project)module.getProject()).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID)});
        }

        private static boolean isSpringFacetConfigured(@NotNull Module module) {
            if (module == null) {
                1.$$$reportNull$$$0(0);
            }
            if (SpringFacet.exists(module)) {
                return true;
            }
            for (Module dependent : ModuleUtilCore.getAllDependentModules((Module)module)) {
                if (!SpringFacet.exists(dependent)) continue;
                return true;
            }
            HashSet dependencies = new HashSet();
            ModuleUtilCore.getDependencies((Module)module, dependencies);
            for (Module dependency : dependencies) {
                if (!SpringFacet.exists(dependency)) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/model/utils/SpringCommonUtils$1", "isSpringFacetConfigured"));
        }
    };

    private SpringCommonUtils() {
    }

    public static List<String> tokenize(@NotNull String str) {
        if (str == null) {
            SpringCommonUtils.$$$reportNull$$$0(0);
        }
        return SpringCommonUtils.tokenize(str, SPRING_DELIMITERS);
    }

    @NotNull
    public static List<String> tokenize(@NotNull String str, @NotNull String delimiters) {
        if (str == null) {
            SpringCommonUtils.$$$reportNull$$$0(1);
        }
        if (delimiters == null) {
            SpringCommonUtils.$$$reportNull$$$0(2);
        }
        SmartList list = new SmartList();
        StringTokenizer st = new StringTokenizer(str, delimiters);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.isEmpty()) continue;
            list.add(token);
        }
        SmartList smartList = list;
        if (smartList == null) {
            SpringCommonUtils.$$$reportNull$$$0(3);
        }
        return smartList;
    }

    @NotNull
    public static List<PsiType> resolveGenerics(PsiClassType classType) {
        PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null) {
            PsiSubstitutor substitutor = resolveResult.getSubstitutor();
            SmartList generics = new SmartList();
            for (PsiTypeParameter typeParameter : psiClass.getTypeParameters()) {
                generics.add(substitutor.substitute(typeParameter));
            }
            SmartList smartList = generics;
            if (smartList == null) {
                SpringCommonUtils.$$$reportNull$$$0(4);
            }
            return smartList;
        }
        List<PsiType> list = Collections.emptyList();
        if (list == null) {
            SpringCommonUtils.$$$reportNull$$$0(5);
        }
        return list;
    }

    public static boolean isSpringConfigured(@NotNull Project project) {
        if (project == null) {
            SpringCommonUtils.$$$reportNull$$$0(6);
        }
        return SpringFacet.exists(project) || SpringLibraryUtil.hasSpringLibrary((Project)project);
    }

    @Contract(value="null -> false")
    public static boolean isSpringConfigured(@Nullable Module module) {
        return SpringFacet.exists(module) || SpringLibraryUtil.hasSpringLibrary((Module)module);
    }

    public static boolean isConfiguration(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringCommonUtils.$$$reportNull$$$0(7);
        }
        return SpringCommonUtils.isSpringBeanCandidateClass(psiClass) && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.springframework.context.annotation.Configuration", (int)0);
    }

    public static boolean isConfigurationOrMeta(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringCommonUtils.$$$reportNull$$$0(8);
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return false;
        }
        return JamService.getJamService((Project)psiClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)psiClass) != null;
    }

    public static boolean isComponentOrMeta(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringCommonUtils.$$$reportNull$$$0(9);
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return false;
        }
        return JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringComponent.META}) != null;
    }

    public static boolean isStereotypeComponentOrMeta(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringCommonUtils.$$$reportNull$$$0(10);
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return false;
        }
        return JamService.getJamService((Project)psiClass.getProject()).getJamElement(JamPsiMemberSpringBean.PSI_MEMBER_SPRING_BEAN_JAM_KEY, (PsiElement)psiClass) != null;
    }

    public static boolean isMappedBeanClass(@Nullable PsiClass psiClass, boolean forMembers) {
        return SpringCommonUtils.isMappedBeanClass(psiClass, forMembers, (Condition<PsiMethod>)((Condition)SpringCommonUtils::isEntryPoint));
    }

    public static boolean isMappedBeanClass(@Nullable PsiClass psiClass, boolean forMembers, Condition<PsiMethod> methodPredicate) {
        if (psiClass == null) {
            return false;
        }
        if (psiClass.isInterface()) {
            return false;
        }
        if (SpringCommonUtils.isComponentOrMeta(psiClass)) {
            if (SpringCommonUtils.hasSuperClasses(psiClass) || ContainerUtil.exists((Object[])psiClass.getMethods(), methodPredicate)) {
                return true;
            }
            if (!forMembers) {
                return false;
            }
        }
        return false;
    }

    private static boolean hasSuperClasses(@NotNull PsiClass element) {
        if (element == null) {
            SpringCommonUtils.$$$reportNull$$$0(11);
        }
        for (PsiClass superClass : element.getSupers()) {
            if (superClass == null || "java.lang.Record".equals(superClass.getQualifiedName()) || "java.lang.Object".equals(superClass.getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isEntryPoint(@NotNull PsiMethod method) {
        if (method == null) {
            SpringCommonUtils.$$$reportNull$$$0(12);
        }
        return !method.hasModifier(JvmModifier.ABSTRACT) && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, ENTRY_POINTS, (int)0);
    }

    @Contract(value="null->false")
    public static boolean isSpringBeanCandidateClass(@Nullable PsiClass psiClass) {
        return psiClass != null && psiClass.isValid() && !(psiClass instanceof PsiTypeParameter) && !psiClass.isAnnotationType() && psiClass.getQualifiedName() != null && !PsiUtil.isLocalOrAnonymousClass((PsiClass)psiClass);
    }

    public static PsiElement createSpringXmlConfigFile(String newName, PsiDirectory directory) throws Exception {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)directory);
        FileTemplate template = SpringCommonUtils.getSpringXmlTemplate(module);
        Object fileName = FileUtilRt.getExtension((String)newName).isEmpty() ? newName + ".xml" : newName;
        return FileTemplateUtil.createFromTemplate((FileTemplate)template, (String)fileName, null, (PsiDirectory)directory);
    }

    public static FileTemplate getSpringXmlTemplate(Module ... modules) {
        for (Module module : modules) {
            String version = JarVersionDetectionUtil.detectJarVersion((String)"org.springframework.core.SpringVersion", (Module)module);
            if (version == null) continue;
            return version.startsWith("1") ? SpringSchemaVersion.SPRING_1_DTD.getTemplate(module.getProject()) : SpringSchemaVersion.SPRING_SCHEMA.getTemplate(module.getProject());
        }
        return SpringSchemaVersion.SPRING_SCHEMA.getTemplate(modules[0].getProject());
    }

    @Contract(value="null -> false")
    public static boolean isSpringFacetConfigured(@Nullable Module module) {
        if (module == null) {
            return false;
        }
        return (Boolean)CachedValuesManager.getManager((Project)module.getProject()).getParameterizedCachedValue((UserDataHolder)module, IS_SPRING_CONFIGURED_KEY, IS_SPRING_CONFIGURED_PROVIDER, false, (Object)module);
    }

    @Contract(value="null->false")
    public static boolean isSpringBeanCandidateClassInSpringProject(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (SpringCommonUtils.isSpringConfigured(module)) {
            return true;
        }
        return module == null;
    }

    public static boolean isInSpringEnabledModule(@Nullable UElement uElement) {
        PsiElement psi = UElementKt.getSourcePsiElement((UElement)uElement);
        if (psi == null) {
            return false;
        }
        return SpringCommonUtils.isSpringConfigured(ModuleUtilCore.findModuleForPsiElement((PsiElement)psi));
    }

    @Nullable
    public static GlobalSearchScope getConfigFilesScope(Project project, GlobalSearchScope scope) {
        PsiPackage metaInfPackage = JavaPsiFacade.getInstance((Project)project).findPackage("META-INF");
        if (metaInfPackage == null) {
            return null;
        }
        GlobalSearchScope packageScope = PackageScope.packageScope((PsiPackage)metaInfPackage, (boolean)false);
        return scope.intersectWith(packageScope);
    }

    public static <T extends PsiFile> List<T> findConfigFilesInMetaInf(Module module, boolean withTests, String filename, Class<T> psiFileType) {
        GlobalSearchScope moduleScope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)withTests);
        return SpringCommonUtils.findConfigFilesInMetaInf(moduleScope, filename, psiFileType);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public static <T extends PsiFile> List<T> findConfigFilesInMetaInf(GlobalSearchScope scope, String fileName, Class<T> psiFileType) {
        Project project = scope.getProject();
        if (project == null) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringCommonUtils.$$$reportNull$$$0(13);
            }
            return list;
        }
        GlobalSearchScope searchScope = SpringCommonUtils.getConfigFilesScope(project, scope);
        if (searchScope == null) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringCommonUtils.$$$reportNull$$$0(14);
            }
            return list;
        }
        Collection virtualFiles = FilenameIndex.getVirtualFilesByName((String)fileName, (GlobalSearchScope)scope);
        if (virtualFiles.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                SpringCommonUtils.$$$reportNull$$$0(15);
            }
            return list;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        @NotNull List psiFiles = ContainerUtil.mapNotNull((Collection)virtualFiles, arg_0 -> ((PsiManager)psiManager).findFile(arg_0));
        List list = ContainerUtil.findAll((Collection)psiFiles, psiFileType);
        if (list == null) {
            SpringCommonUtils.$$$reportNull$$$0(16);
        }
        return list;
    }

    @Nullable
    public static PsiClass findLibraryClass(@Nullable Module module, @NotNull String className) {
        if (className == null) {
            SpringCommonUtils.$$$reportNull$$$0(17);
        }
        if (module == null || module.isDisposed()) {
            return null;
        }
        Project project = module.getProject();
        Map cache = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            ConcurrentMap map = ConcurrentFactoryMap.createMap(key -> SpringCommonUtils.findLibraryClass(project, key, GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false)));
            return CachedValueProvider.Result.createSingleDependency((Object)map, (Object)JavaLibraryModificationTracker.getInstance((Project)module.getProject()));
        });
        return (PsiClass)cache.get(className);
    }

    @Nullable
    private static PsiClass findLibraryClass(@NotNull Project project, @NotNull String fqn, @NotNull GlobalSearchScope searchScope) {
        if (project == null) {
            SpringCommonUtils.$$$reportNull$$$0(18);
        }
        if (fqn == null) {
            SpringCommonUtils.$$$reportNull$$$0(19);
        }
        if (searchScope == null) {
            SpringCommonUtils.$$$reportNull$$$0(20);
        }
        return (PsiClass)DumbService.getInstance((Project)project).runReadActionInSmartMode(() -> JavaPsiFacade.getInstance((Project)project).findClass(fqn, searchScope));
    }

    @NotNull
    public static Set<UExpression> findParameterExpressionInMethodCalls(@NotNull Set<UCallExpression> calls, int forParam) {
        if (calls == null) {
            SpringCommonUtils.$$$reportNull$$$0(21);
        }
        Set<UExpression> set = calls.stream().map(uCallExpression -> uCallExpression.getArgumentForParameter(forParam)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (set == null) {
            SpringCommonUtils.$$$reportNull$$$0(22);
        }
        return set;
    }

    @NotNull
    public static List<UExpression> getReturnedUExpression(@Nullable PsiMethod method) {
        final UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)method, UMethod.class);
        if (uMethod == null) {
            List<UExpression> list = Collections.emptyList();
            if (list == null) {
                SpringCommonUtils.$$$reportNull$$$0(23);
            }
            return list;
        }
        SmartList result = new SmartList();
        uMethod.accept((UastVisitor)new AbstractUastVisitor((List)result){
            final /* synthetic */ List val$result;
            {
                this.val$result = list;
            }

            public boolean visitReturnExpression(@NotNull UReturnExpression node) {
                if (node == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (node.getJumpTarget() == uMethod) {
                    ContainerUtil.addIfNotNull((Collection)this.val$result, (Object)node.getReturnExpression());
                }
                return super.visitReturnExpression(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/spring/model/utils/SpringCommonUtils$2", "visitReturnExpression"));
            }
        });
        SmartList smartList = result;
        if (smartList == null) {
            SpringCommonUtils.$$$reportNull$$$0(24);
        }
        return smartList;
    }

    @Nullable
    public static String evaluateStringExpression(@Nullable UExpression expression) {
        Pair pair;
        PsiElement sourcePsi;
        if (expression == null) {
            return null;
        }
        String evaluateString = UastUtils.evaluateString((UExpression)expression);
        if (evaluateString == null && (sourcePsi = expression.getSourcePsi()) instanceof PsiExpression && (pair = StringExpressionHelper.evaluateExpression((PsiElement)sourcePsi)) != null) {
            return (String)pair.second;
        }
        return evaluateString;
    }

    @NotNull
    public static BeanTypeProvider getBeanTypeProvider(Class<? extends BeanTypeProvider> providerClass) {
        BeanTypeProvider beanTypeProvider;
        try {
            beanTypeProvider = providerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Couldn't instantiate " + String.valueOf(providerClass), e);
        }
        if (beanTypeProvider == null) {
            SpringCommonUtils.$$$reportNull$$$0(25);
        }
        return beanTypeProvider;
    }

    @NotNull
    public static BeanNameProvider getBeanNameProvider(Class<? extends BeanNameProvider> providerClass) {
        BeanNameProvider beanNameProvider;
        try {
            beanNameProvider = providerClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Couldn't instantiate " + String.valueOf(providerClass), e);
        }
        if (beanNameProvider == null) {
            SpringCommonUtils.$$$reportNull$$$0(26);
        }
        return beanNameProvider;
    }

    @NotNull
    public static Set<SpringBeanPointer<?>> filterInnerClassBeans(@NotNull Collection<SpringBeanPointer<?>> pointers) {
        if (pointers == null) {
            SpringCommonUtils.$$$reportNull$$$0(27);
        }
        Set<SpringBeanPointer<?>> set = pointers.stream().filter(pointer -> !SpringCommonUtils.isDefinedAsCollectionElement(pointer)).collect(Collectors.toSet());
        if (set == null) {
            SpringCommonUtils.$$$reportNull$$$0(28);
        }
        return set;
    }

    @NotNull
    public static Set<SpringBeanPointer<?>> filterDefaultCandidates(@NotNull Set<SpringBeanPointer<?>> pointers) {
        if (pointers == null) {
            SpringCommonUtils.$$$reportNull$$$0(29);
        }
        if (pointers.size() == 1) {
            Set<SpringBeanPointer<?>> set = pointers;
            if (set == null) {
                SpringCommonUtils.$$$reportNull$$$0(30);
            }
            return set;
        }
        Set filtered = pointers.stream().filter(pointer -> {
            Object bean = pointer.getSpringBean();
            if (bean instanceof ContextJavaBean) {
                return ((ContextJavaBean)bean).isDefaultCandidate();
            }
            return true;
        }).collect(Collectors.toSet());
        Set<SpringBeanPointer<Object>> set = filtered.isEmpty() ? pointers : filtered;
        if (set == null) {
            SpringCommonUtils.$$$reportNull$$$0(31);
        }
        return set;
    }

    @NotNull
    public static Set<SpringBeanPointer<?>> filterFallbackCandidates(@NotNull Set<SpringBeanPointer<?>> pointers) {
        Set filteredPointers;
        if (pointers == null) {
            SpringCommonUtils.$$$reportNull$$$0(32);
        }
        Set<SpringBeanPointer<Object>> set = (filteredPointers = pointers.stream().filter(pointer -> !pointer.getSpringBean().isFallback()).collect(Collectors.toSet())).isEmpty() ? pointers : filteredPointers;
        if (set == null) {
            SpringCommonUtils.$$$reportNull$$$0(33);
        }
        return set;
    }

    public static boolean isDefinedAsCollectionElement(@Nullable SpringBeanPointer<?> pointer) {
        if (pointer instanceof DomSpringBeanPointer) {
            return ((DomSpringBean)((DomSpringBeanPointer)pointer).getSpringBean()).getParent() instanceof CollectionElements;
        }
        return false;
    }

    @NotNull
    public static Collection<? extends UCallExpression> findMethodCallsByPattern(@NotNull Project project, @NotNull String methodName, @NotNull SearchScope scope, UCallExpressionPattern ... patterns) {
        if (project == null) {
            SpringCommonUtils.$$$reportNull$$$0(34);
        }
        if (methodName == null) {
            SpringCommonUtils.$$$reportNull$$$0(35);
        }
        if (scope == null) {
            SpringCommonUtils.$$$reportNull$$$0(36);
        }
        Collection collection = SearchService.getInstance().searchWord(project, methodName).inContexts(SearchContext.inCode(), new SearchContext[0]).inScope(scope).buildQuery(occurrence -> {
            if (occurrence.getOffsetInStart() != 0) {
                return Collections.emptySet();
            }
            UCallExpression uCallExpression = SpringCommonUtils.getUCallExpression(occurrence.getStart());
            if (uCallExpression == null) {
                return Collections.emptySet();
            }
            for (UCallExpressionPattern callExpressionPattern : patterns) {
                if (!callExpressionPattern.accepts((Object)uCallExpression)) continue;
                return Collections.singleton(uCallExpression);
            }
            return Collections.emptySet();
        }).findAll();
        if (collection == null) {
            SpringCommonUtils.$$$reportNull$$$0(37);
        }
        return collection;
    }

    @Nullable
    private static UCallExpression getUCallExpression(@NotNull PsiElement leafNode) {
        UElement uastParent;
        UElement element;
        if (leafNode == null) {
            SpringCommonUtils.$$$reportNull$$$0(38);
        }
        if ((element = UastContextKt.toUElement((PsiElement)leafNode)) instanceof UCallExpression) {
            return (UCallExpression)element;
        }
        if (element instanceof UIdentifier && (uastParent = element.getUastParent()) instanceof UCallExpression) {
            return (UCallExpression)uastParent;
        }
        return null;
    }

    public static boolean hasSpringXmlInResolveScope(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringCommonUtils.$$$reportNull$$$0(39);
        }
        return SpringCommonUtils.hasSpringXmlInResolveScopeCached(psiClass) || SpringCommonUtils.hasSpringXmlInFacet(psiClass);
    }

    private static boolean hasSpringXmlInResolveScopeCached(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringCommonUtils.$$$reportNull$$$0(40);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
            GlobalSearchScope searchScope = module == null ? GlobalSearchScope.allScope((Project)psiClass.getProject()) : SpringGlobalSearchScopes.moduleWithDependencies(module);
            boolean has = !DomService.getInstance().getDomFileCandidates(Beans.class, searchScope).isEmpty();
            return CachedValueProvider.Result.create((Object)has, (Object[])new Object[]{PsiModificationTracker.getInstance((Project)psiClass.getProject())});
        });
    }

    private static boolean hasSpringXmlInFacet(@NotNull PsiClass psiClass) {
        Module module;
        if (psiClass == null) {
            SpringCommonUtils.$$$reportNull$$$0(41);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass)) == null) {
            return false;
        }
        return (Boolean)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create((Object)SpringCommonUtils.hasSpringXmlInFacetWithDependent(module), (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject()), FacetFinder.getInstance((Project)module.getProject()).getAllFacetsOfTypeModificationTracker(SpringFacet.FACET_TYPE_ID)}));
    }

    private static boolean hasSpringXmlInFacetWithDependent(@NotNull Module module) {
        if (module == null) {
            SpringCommonUtils.$$$reportNull$$$0(42);
        }
        if (SpringCommonUtils.hasSpringXmlInFacet(module)) {
            return true;
        }
        LinkedHashSet dependentModules = new LinkedHashSet();
        ModuleUtilCore.collectModulesDependsOn((Module)module, dependentModules);
        for (Module dependentModule : dependentModules) {
            if (dependentModule.equals((Object)module) || !SpringCommonUtils.hasSpringXmlInFacet(dependentModule)) continue;
            return true;
        }
        LinkedHashSet dependencies = new LinkedHashSet();
        ModuleUtilCore.getDependencies((Module)module, dependencies);
        for (Module dependency : dependencies) {
            if (dependency.equals((Object)module) || !SpringCommonUtils.hasSpringXmlInFacet(dependency)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSpringXmlInFacet(@NotNull Module module) {
        SpringFacet springFacet;
        if (module == null) {
            SpringCommonUtils.$$$reportNull$$$0(43);
        }
        if ((springFacet = SpringFacet.getInstance(module)) == null) {
            return false;
        }
        for (SpringFileSet fileSet : springFacet.getFileSets()) {
            if (fileSet.getXmlFiles().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static Set<Module> getRelatedModules(@Nullable PsiFile psiFile) {
        if (psiFile == null) {
            return Collections.emptySet();
        }
        VirtualFile virtualFile = psiFile.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return Collections.emptySet();
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)psiFile.getProject()).getFileIndex();
        if (!fileIndex.isInLibraryClasses(virtualFile) && !fileIndex.isInLibrarySource(virtualFile)) {
            return Collections.emptySet();
        }
        return fileIndex.getOrderEntriesForFile(virtualFile).stream().map(OrderEntry::getOwnerModule).collect(Collectors.toSet());
    }

    @NotNull
    public static List<SpringJamPropertySource> getPropertySources(@Nullable Module module) {
        if (module == null || DumbService.isDumb((Project)module.getProject())) {
            List<SpringJamPropertySource> list = Collections.emptyList();
            if (list == null) {
                SpringCommonUtils.$$$reportNull$$$0(44);
            }
            return list;
        }
        List list = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            GlobalSearchScope scope = SpringGlobalSearchScopes.runtime(module);
            SmartList propertySources = new SmartList();
            JamService jamService = JamService.getJamService((Project)module.getProject());
            propertySources.addAll(jamService.getJamClassElements(SpringJamPropertySource.META, "org.springframework.context.annotation.PropertySource", scope));
            for (SpringPropertySources springPropertySources : jamService.getJamClassElements(SpringPropertySources.META, "org.springframework.context.annotation.PropertySources", scope)) {
                propertySources.addAll(springPropertySources.getPropertySources());
            }
            return CachedValueProvider.Result.create((Object)propertySources, (Object[])SpringModificationTrackersManager.getInstance(module.getProject()).getOuterModelsDependencies());
        });
        if (list == null) {
            SpringCommonUtils.$$$reportNull$$$0(45);
        }
        return list;
    }

    public static boolean canBeScannedFromNonSpringLibraries(@NotNull PsiClass searchClass) {
        Module module;
        if (searchClass == null) {
            SpringCommonUtils.$$$reportNull$$$0(46);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)searchClass)) == null) {
            return false;
        }
        String qualifiedName = searchClass.getQualifiedName();
        if (qualifiedName == null) {
            return false;
        }
        for (String packageName : SpringCommonUtils.getScannedPackagesFromNonSpringLibraries(module)) {
            if (!qualifiedName.startsWith(packageName)) continue;
            return SpringCommonUtils.isStereotypeComponentOrMeta(searchClass) || SpringCommonUtils.isScannable(searchClass);
        }
        return false;
    }

    public static Set<String> getScannedPackagesFromNonSpringLibraries(@NotNull Module module) {
        if (module == null) {
            SpringCommonUtils.$$$reportNull$$$0(47);
        }
        return (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            Set componentScanPackages = SpringCommonUtils.getConfigurationsFromNonSpringLibraries(module).stream().flatMap(aClass -> SemService.getSemService((Project)module.getProject()).getSemElements(SpringComponentScan.COMPONENT_SCAN_JAM_KEY, (PsiElement)aClass).stream()).flatMap(scan -> scan.getPsiPackages().stream()).map(aPackage -> aPackage.getQualifiedName()).collect(Collectors.toSet());
            return CachedValueProvider.Result.create(componentScanPackages, (Object[])new Object[]{JavaLibraryModificationTracker.getInstance((Project)module.getProject())});
        });
    }

    @NotNull
    private static Set<PsiClass> getConfigurationsFromNonSpringLibraries(@NotNull Module module) {
        if (module == null) {
            SpringCommonUtils.$$$reportNull$$$0(48);
        }
        Set<PsiClass> set = MetaAnnotationUtil.getAnnotationNamesWithChildren((Module)module, (String)"org.springframework.context.annotation.Configuration", (boolean)false).stream().flatMap(s -> SpringCommonUtils.getConfigurations(module, s)).map(configuration -> configuration.getPsiElement()).filter(aClass -> aClass instanceof PsiCompiledElement).filter(aClass -> {
            String qualifiedName = aClass.getQualifiedName();
            return qualifiedName != null && !qualifiedName.startsWith("org.springframework");
        }).collect(Collectors.toSet());
        if (set == null) {
            SpringCommonUtils.$$$reportNull$$$0(49);
        }
        return set;
    }

    private static boolean isScannable(@NotNull PsiClass searchClass) {
        if (searchClass == null) {
            SpringCommonUtils.$$$reportNull$$$0(50);
        }
        return JamService.getJamService((Project)searchClass.getProject()).getJamElement(SpringComponentScan.SCANNABLE_COMPONENT_JAM_KEY, (PsiElement)searchClass) != null;
    }

    @NotNull
    private static Stream<SpringConfiguration> getConfigurations(@NotNull Module module, @NotNull String annotationName) {
        if (module == null) {
            SpringCommonUtils.$$$reportNull$$$0(51);
        }
        if (annotationName == null) {
            SpringCommonUtils.$$$reportNull$$$0(52);
        }
        Stream<SpringConfiguration> stream = JamService.getJamService((Project)module.getProject()).getJamClassElements(SpringConfiguration.JAM_KEY, annotationName, module.getModuleWithLibrariesScope()).stream();
        if (stream == null) {
            SpringCommonUtils.$$$reportNull$$$0(53);
        }
        return stream;
    }

    public static List<PsiClass> getAllSupersExceptBaseClasses(PsiClass psiClass) {
        return InheritanceUtil.getSuperClasses((PsiClass)psiClass).stream().filter(s -> s.getQualifiedName() != null && !s.getQualifiedName().startsWith("java.") && !s.getQualifiedName().startsWith("kotlin.")).toList();
    }

    public static List<CommonSpringBean> getSpringBeans(PsiClass psiClass) {
        if (!SpringCommonUtils.isSpringBeanCandidateClass(psiClass)) {
            return List.of();
        }
        SpringJavaClassInfo.MappedBeanInfo classInfo = SpringJavaClassInfo.getSpringJavaClassInfo(psiClass).resolve();
        if (classInfo == null || !classInfo.isMapped()) {
            if (SpringCommonUtils.isInLibrary(psiClass)) {
                SpringStereotypeElement stereotypeElement = SpringJamUtils.getInstance().findStereotypeElement(psiClass);
                return stereotypeElement != null ? Collections.singletonList(stereotypeElement) : List.of();
            }
            return List.of();
        }
        Set<SpringBeanPointer<?>> beans2 = classInfo.getBeans();
        if (beans2 == null) {
            return List.of();
        }
        return ContainerUtil.map(beans2, it -> it.getSpringBean());
    }

    private static boolean isInLibrary(PsiClass psiClass) {
        PsiElement originalElement = psiClass.getOriginalElement();
        if (originalElement instanceof PsiCompiledElement) {
            return true;
        }
        VirtualFile file = originalElement.getContainingFile().getVirtualFile();
        return file != null && ProjectRootManager.getInstance((Project)originalElement.getProject()).getFileIndex().isInLibrary(file);
    }

    public static boolean isAnnotatedComponent(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SpringCommonUtils.$$$reportNull$$$0(54);
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClassInSpringProject(psiClass) || psiClass.isRecord()) {
            return false;
        }
        SpringTestContextUtil testContextUtil = SpringTestContextUtil.getInstance();
        return SpringCommonUtils.isStereotypeComponentOrMeta(psiClass) || SpringCommonUtils.isConfigurationOrMeta(psiClass) || testContextUtil != null && testContextUtil.isTestContextConfigurationClass(psiClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 13, 14, 15, 16, 22, 23, 24, 25, 26, 28, 30, 31, 33, 37, 44, 45, 49, 53 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delimiters";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 37: 
            case 44: 
            case 45: 
            case 49: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/utils/SpringCommonUtils";
                break;
            }
            case 6: 
            case 18: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 39: 
            case 40: 
            case 41: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calls";
                break;
            }
            case 27: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafNode";
                break;
            }
            case 42: 
            case 43: 
            case 47: 
            case 48: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 46: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchClass";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/utils/SpringCommonUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGenerics";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findConfigFilesInMetaInf";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findParameterExpressionInMethodCalls";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnedUExpression";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanTypeProvider";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanNameProvider";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "filterInnerClassBeans";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDefaultCandidates";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "filterFallbackCandidates";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodCallsByPattern";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertySources";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationsFromNonSpringLibraries";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 37: 
            case 44: 
            case 45: 
            case 49: 
            case 53: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSpringConfigured";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationOrMeta";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isComponentOrMeta";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isStereotypeComponentOrMeta";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasSuperClasses";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isEntryPoint";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryClass";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findParameterExpressionInMethodCalls";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "filterInnerClassBeans";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "filterDefaultCandidates";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "filterFallbackCandidates";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findMethodCallsByPattern";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getUCallExpression";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "hasSpringXmlInResolveScope";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "hasSpringXmlInResolveScopeCached";
                break;
            }
            case 41: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "hasSpringXmlInFacet";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "hasSpringXmlInFacetWithDependent";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "canBeScannedFromNonSpringLibraries";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getScannedPackagesFromNonSpringLibraries";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationsFromNonSpringLibraries";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isScannable";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurations";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatedComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 13, 14, 15, 16, 22, 23, 24, 25, 26, 28, 30, 31, 33, 37, 44, 45, 49, 53 -> new IllegalStateException(string);
        };
    }
}

