/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.profile;

import com.intellij.ide.presentation.Presentation;
import com.intellij.jam.JamConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.reflect.JamAnnotationArchetype;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PartiallyKnownString;
import com.intellij.semantic.SemKey;
import com.intellij.spring.model.jam.profile.SpringContextProfile;
import com.intellij.spring.profiles.SpringProfilesFactory;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.expressions.UStringConcatenationsFacade;

@Presentation(typeName="@Profile")
public final class SpringJamProfile
extends CommonModelElement.PsiBase
implements SpringContextProfile {
    public static final String PROFILE_DELIMITERS = "()&|";
    private final PsiElementRef<PsiAnnotation> myPsiAnnotation;
    private final PsiMember myPsiMember;
    public static final SemKey<JamAnnotationMeta> JAM_ANNO_META_KEY = CONTEXT_PROFILE_JAM_ANNOTATION_KEY.subKey("SpringJamProfile", new SemKey[0]);
    private static final SemKey<SpringJamProfile> JAM_KEY = SpringContextProfile.CONTEXT_PROFILE_JAM_KEY.subKey("SpringJamProfile", new SemKey[0]);
    public static final JamMemberMeta<PsiMember, SpringJamProfile> META = new JamMemberMeta(null, SpringJamProfile::new, JAM_KEY);
    private static final JamStringAttributeMeta.Collection<String> VALUE_ATTR_META = JamAttributeMeta.collectionString((String)"value", (JamConverter)new SpringProfileConverter("()&|", true));
    private static final JamAnnotationArchetype ARCHETYPE = new JamAnnotationArchetype().addAttribute(VALUE_ATTR_META);
    public static final JamAnnotationMeta ANNO_META = new JamAnnotationMeta("org.springframework.context.annotation.Profile", ARCHETYPE, JAM_ANNO_META_KEY);

    private SpringJamProfile(@NotNull PsiElementRef<?> psiRef) {
        PsiMember psiMember;
        if (psiRef == null) {
            SpringJamProfile.$$$reportNull$$$0(0);
        }
        this.myPsiMember = psiMember = (PsiMember)Objects.requireNonNull(psiRef.getPsiElement());
        this.myPsiAnnotation = ANNO_META.getAnnotationRef((PsiModifierListOwner)psiMember);
    }

    @Override
    @NotNull
    public Set<String> getExpressions() {
        LinkedHashSet<String> profiles = new LinkedHashSet<String>();
        for (JamStringAttributeElement<String> element : this.getValueElements()) {
            String value = element.getStringValue();
            if (StringUtil.isEmptyOrSpaces((String)value)) continue;
            profiles.add(value.trim());
        }
        LinkedHashSet<String> linkedHashSet = profiles;
        if (linkedHashSet == null) {
            SpringJamProfile.$$$reportNull$$$0(1);
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public List<JamStringAttributeElement<String>> getValueElements() {
        List list = (List)ANNO_META.getAttribute((PsiModifierListOwner)this.myPsiMember, VALUE_ATTR_META);
        if (list == null) {
            SpringJamProfile.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public PsiMember getPsiElement() {
        PsiMember psiMember = this.myPsiMember;
        if (psiMember == null) {
            SpringJamProfile.$$$reportNull$$$0(3);
        }
        return psiMember;
    }

    @Override
    @Nullable
    public PsiAnnotation getAnnotation() {
        return (PsiAnnotation)this.myPsiAnnotation.getPsiElement();
    }

    static {
        META.addAnnotation(ANNO_META);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiRef";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/profile/SpringJamProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/profile/SpringJamProfile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    public static class SpringProfileConverter
    extends JamConverter<String> {
        private final String myDelimiters;
        private final boolean myIsDefinition;

        public SpringProfileConverter(String delimiters, boolean isDefinition) {
            this.myDelimiters = delimiters;
            this.myIsDefinition = isDefinition;
        }

        public String fromString(@Nullable String s, JamStringAttributeElement<String> context) {
            return s;
        }

        public PsiReference @NotNull [] createReferences(@NotNull JamStringAttributeElement<String> context, @NotNull PsiLanguageInjectionHost injectionHost) {
            if (context == null) {
                SpringProfileConverter.$$$reportNull$$$0(0);
            }
            if (injectionHost == null) {
                SpringProfileConverter.$$$reportNull$$$0(1);
            }
            PsiReference[] psiReferenceArray = this.createReferences(injectionHost);
            if (psiReferenceArray == null) {
                SpringProfileConverter.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }

        public PsiReference @NotNull [] createReferences(@NotNull PsiLanguageInjectionHost injectionHost) {
            UExpression uExpression;
            if (injectionHost == null) {
                SpringProfileConverter.$$$reportNull$$$0(3);
            }
            if ((uExpression = (UExpression)UastContextKt.toUElement((PsiElement)injectionHost, UExpression.class)) == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    SpringProfileConverter.$$$reportNull$$$0(4);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            UStringConcatenationsFacade facade = UStringConcatenationsFacade.createFromTopConcatenation((UExpression)uExpression);
            if (facade == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    SpringProfileConverter.$$$reportNull$$$0(5);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            PartiallyKnownString pks = facade.asPartiallyKnownString();
            if (pks.getSegments().size() > 1) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    SpringProfileConverter.$$$reportNull$$$0(6);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)injectionHost);
            if (module == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    SpringProfileConverter.$$$reportNull$$$0(7);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            PsiReference[] psiReferenceArray = SpringProfilesFactory.getInstance().getProfilesReferences(module, (PsiElement)injectionHost, pks.getValueIfKnown(), 0, this.myDelimiters, this.myIsDefinition);
            if (psiReferenceArray == null) {
                SpringProfileConverter.$$$reportNull$$$0(8);
            }
            return psiReferenceArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 5, 6, 7, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "injectionHost";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/model/jam/profile/SpringJamProfile$SpringProfileConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/model/jam/profile/SpringJamProfile$SpringProfileConverter";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createReferences";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createReferences";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4, 5, 6, 7, 8 -> new IllegalStateException(string);
            };
        }
    }
}

