/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.util.Ref;
import com.intellij.spring.contexts.model.SpringSizeLimitedCache;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringCachingProcessor<InParams extends SpringModelSearchParameters> {
    private static final int DEFAULT_CACHE_SIZE = 42;
    private static final String CACHE_SIZE_PROPERTY_NAME = "idea.spring.model.processing.cache.size";
    private static final int CONFIGURED_CACHE_SIZE = SystemProperties.getIntProperty((String)"idea.spring.model.processing.cache.size", (int)42);
    private final SpringSizeLimitedCache<InParams, Collection<SpringBeanPointer<?>>> myFindAllCache = new SpringSizeLimitedCache<InParams, Collection<SpringBeanPointer<?>>>(CONFIGURED_CACHE_SIZE){

        @Override
        @NotNull
        protected Collection<SpringBeanPointer<?>> createValue(InParams key) {
            Collection<SpringBeanPointer<?>> collection = SpringCachingProcessor.this.findPointers(key);
            if (collection == null) {
                1.$$$reportNull$$$0(0);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringCachingProcessor$1", "createValue"));
        }
    };
    private final SpringSizeLimitedCache<InParams, Ref<SpringBeanPointer<?>>> myFindFirstCache = new SpringSizeLimitedCache<InParams, Ref<SpringBeanPointer<?>>>(CONFIGURED_CACHE_SIZE){

        @Override
        @NotNull
        protected Ref<SpringBeanPointer<?>> createValue(InParams key) {
            Ref ref = Ref.create(SpringCachingProcessor.this.findFirstPointer(key));
            if (ref == null) {
                2.$$$reportNull$$$0(0);
            }
            return ref;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringCachingProcessor$2", "createValue"));
        }
    };

    protected SpringCachingProcessor() {
    }

    @NotNull
    protected abstract Collection<SpringBeanPointer<?>> findPointers(@NotNull InParams var1);

    @Nullable
    protected abstract SpringBeanPointer<?> findFirstPointer(@NotNull InParams var1);

    public boolean process(InParams params, Processor<? super SpringBeanPointer<?>> processor, Set<String> activeProfiles) {
        if (processor instanceof CommonProcessors.FindFirstProcessor && this.myFindAllCache.getCachedValue(params) == null) {
            SpringBeanPointer<?> first = this.getFirstBeanPointer(params);
            return SpringCachingProcessor.processBeansInActiveProfile(processor, first, activeProfiles);
        }
        for (SpringBeanPointer<?> pointer : this.getPointers(params)) {
            if (SpringCachingProcessor.processBeansInActiveProfile(processor, pointer, activeProfiles)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private Collection<SpringBeanPointer<?>> getPointers(InParams params) {
        if (params instanceof SpringModelSearchParameters.Immutable) {
            Collection<SpringBeanPointer<?>> collection = this.myFindAllCache.get(params);
            if (collection == null) {
                SpringCachingProcessor.$$$reportNull$$$0(0);
            }
            return collection;
        }
        Collection<SpringBeanPointer<?>> collection = this.findPointers(params);
        if (collection == null) {
            SpringCachingProcessor.$$$reportNull$$$0(1);
        }
        return collection;
    }

    private SpringBeanPointer<?> getFirstBeanPointer(InParams params) {
        if (params instanceof SpringModelSearchParameters.Immutable) {
            return (SpringBeanPointer)this.myFindFirstCache.get(params).get();
        }
        return this.findFirstPointer(params);
    }

    private static boolean processBeansInActiveProfile(Processor<? super SpringBeanPointer<?>> processor, @Nullable SpringBeanPointer<?> pointer, Set<String> activeProfiles) {
        if (pointer == null) {
            return true;
        }
        if (ContainerUtil.isEmpty(activeProfiles)) {
            return processor.process(pointer);
        }
        if (!SpringProfileUtils.isInActiveProfiles(pointer.getSpringBean(), activeProfiles)) {
            return true;
        }
        return processor.process(pointer);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/SpringCachingProcessor", "getPointers"));
    }
}

