/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.template;

import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.filters.FilterPositionUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001b\u0010\r\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f0\u000eH\u0014\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0012\u001a\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010H$R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/spring/mvc/template/AbstractBaseSpringTemplateContextType;", "Lcom/intellij/codeInsight/template/TemplateContextType;", "languageId", "", "presentableName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getLanguageId", "()Ljava/lang/String;", "isInContext", "", "templateActionContext", "Lcom/intellij/codeInsight/template/TemplateActionContext;", "expectedParentTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "()[Ljava/lang/Class;", "matchesContext", "uElement", "intellij.spring.mvc.impl"})
public abstract class AbstractBaseSpringTemplateContextType
extends TemplateContextType {
    @NotNull
    private final String languageId;

    public AbstractBaseSpringTemplateContextType(@NotNull String languageId, @NlsContexts.Label @NotNull String presentableName) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        Intrinsics.checkNotNullParameter((Object)presentableName, (String)"presentableName");
        super(presentableName);
        this.languageId = languageId;
    }

    @NotNull
    protected final String getLanguageId() {
        return this.languageId;
    }

    public boolean isInContext(@NotNull TemplateActionContext templateActionContext) {
        Intrinsics.checkNotNullParameter((Object)templateActionContext, (String)"templateActionContext");
        PsiFile psiFile = templateActionContext.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile psiFile2 = psiFile;
        if (!Intrinsics.areEqual((Object)psiFile2.getLanguage().getID(), (Object)this.languageId)) {
            return false;
        }
        Project project = psiFile2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return false;
        }
        PsiElement psiElement = psiFile2.findElementAt(templateActionContext.getStartOffset() - 1);
        if (psiElement == null) {
            return false;
        }
        PsiElement psiElementAtCaret = psiElement;
        if (psiElementAtCaret instanceof PsiComment) {
            return false;
        }
        PsiElement prevElement = FilterPositionUtil.searchNonSpaceNonCommentBack((PsiElement)psiElementAtCaret);
        if (prevElement instanceof PsiKeyword) {
            return false;
        }
        UElement uElement = UastContextKt.getUastParentOfTypes((PsiElement)psiElementAtCaret.getParent(), (Class[])this.expectedParentTypes(), (boolean)false);
        if (uElement == null) {
            return false;
        }
        UElement uParentAtCaret = uElement;
        return this.matchesContext(uParentAtCaret);
    }

    @NotNull
    protected Class<? extends UElement>[] expectedParentTypes() {
        Class[] classArray = new Class[]{UMethod.class, UClass.class};
        return classArray;
    }

    protected abstract boolean matchesContext(@Nullable UElement var1);
}

