/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.config.anno;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.spring.SpringAutodetectedFilesetsSearcher;
import com.intellij.spring.facet.SpringAutodetectedFileSet;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.SpringMvcLibraryUtil;
import com.intellij.spring.mvc.config.ServletFileSet;
import com.intellij.spring.mvc.config.anno.CodeConfigurationPropertiesParser;
import com.intellij.spring.mvc.config.anno.PsiBasedServlet;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationConfigSpringWebModelContributor
implements SpringAutodetectedFilesetsSearcher {
    private static final String ABSTRACT_ANNOTATION_INITIALIZER = "org.springframework.web.servlet.support.AbstractAnnotationConfigDispatcherServletInitializer";

    @NotNull
    public List<? extends SpringAutodetectedFileSet> getFilesets(@NotNull SpringFacet springFacet) {
        Module module;
        if (springFacet == null) {
            AnnotationConfigSpringWebModelContributor.$$$reportNull$$$0(0);
        }
        if (DumbService.isDumb((Project)(module = springFacet.getModule()).getProject()) || !SpringMvcLibraryUtil.hasSpringMvcLibrary(module)) {
            List list = Collections.emptyList();
            if (list == null) {
                AnnotationConfigSpringWebModelContributor.$$$reportNull$$$0(1);
            }
            return list;
        }
        Collection<PsiClass> initializers = AnnotationConfigSpringWebModelContributor.getCustomInitializers(module);
        SmartList fileSets = new SmartList();
        ContainerUtil.process(initializers, arg_0 -> AnnotationConfigSpringWebModelContributor.lambda$getFilesets$0(module, springFacet, (List)fileSets, arg_0));
        SmartList smartList = fileSets;
        if (smartList == null) {
            AnnotationConfigSpringWebModelContributor.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    @Nullable
    public static PsiBasedServlet getServlet(@NotNull PsiClass initializer, Module module) {
        if (initializer == null) {
            AnnotationConfigSpringWebModelContributor.$$$reportNull$$$0(3);
        }
        return AnnotationConfigSpringWebModelContributor.getServlet(initializer, module, new CodeConfigurationPropertiesParser(initializer));
    }

    @Nullable
    private static PsiBasedServlet getServlet(@NotNull PsiClass initializer, Module module, CodeConfigurationPropertiesParser parser2) {
        String servletName;
        if (initializer == null) {
            AnnotationConfigSpringWebModelContributor.$$$reportNull$$$0(4);
        }
        if (StringUtil.isEmptyOrSpaces((String)(servletName = parser2.getString("getServletName", true)))) {
            return null;
        }
        PsiClass servletClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.DispatcherServlet");
        PsiElement mappingDefinitionElement = (PsiElement)ArrayUtil.getFirstElement((Object[])initializer.findMethodsByName("getServletMappings", false));
        String[] servletMappings = parser2.getStringArray("getServletMappings", false);
        return new PsiBasedServlet(servletName, servletClass, (PsiElement)initializer, mappingDefinitionElement, servletMappings);
    }

    @NotNull
    public static Collection<PsiClass> getCustomInitializers(Module module) {
        PsiClass initializerClass = SpringCommonUtils.findLibraryClass((Module)module, (String)ABSTRACT_ANNOTATION_INITIALIZER);
        if (initializerClass == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                AnnotationConfigSpringWebModelContributor.$$$reportNull$$$0(5);
            }
            return list;
        }
        GlobalSearchScope inheritorsScope = SpringGlobalSearchScopes.runtime((Module)module, (boolean)false);
        Collection collection = ClassInheritorsSearch.search((PsiClass)initializerClass, (SearchScope)inheritorsScope, (boolean)true).findAll();
        if (collection == null) {
            AnnotationConfigSpringWebModelContributor.$$$reportNull$$$0(6);
        }
        return collection;
    }

    private static boolean isConfigurationOrComponent(PsiClass psiClass) {
        return SpringCommonUtils.isConfigurationOrMeta((PsiClass)psiClass) || SpringCommonUtils.isComponentOrMeta((PsiClass)psiClass);
    }

    private static /* synthetic */ boolean lambda$getFilesets$0(Module module, SpringFacet springFacet, List fileSets, PsiClass initializer) {
        CodeConfigurationPropertiesParser parser2 = new CodeConfigurationPropertiesParser(initializer);
        PsiBasedServlet implicitServlet = AnnotationConfigSpringWebModelContributor.getServlet(initializer, module, parser2);
        if (implicitServlet == null) {
            return true;
        }
        String servletName = implicitServlet.getServletName().getStringValue();
        if (servletName == null) {
            return true;
        }
        ServletFileSet initializerServletFileSet = new ServletFileSet("initializer " + initializer.getQualifiedName() + " servlet context", SpringMvcBundle.message("mvc.initializer.context.autodetected", servletName), implicitServlet, springFacet);
        List<PsiClass> servletConfigClasses = parser2.getPsiClasses("getServletConfigClasses", false);
        boolean hasServletContext = !servletConfigClasses.isEmpty();
        for (PsiClass servletConfigClass : servletConfigClasses) {
            if (!AnnotationConfigSpringWebModelContributor.isConfigurationOrComponent(servletConfigClass)) continue;
            ServletFileSet.addInFileset((SpringFileSet)initializerServletFileSet, servletConfigClass.getContainingFile());
        }
        fileSets.add(initializerServletFileSet);
        PsiBasedServlet rootContextImplicitServlet = hasServletContext ? null : implicitServlet;
        ServletFileSet rootContext = new ServletFileSet("initializer " + initializer.getQualifiedName() + " root context", "MVC " + servletName + " initializer root context", rootContextImplicitServlet, springFacet);
        for (PsiClass rootConfigClasses : parser2.getPsiClasses("getRootConfigClasses", false)) {
            if (!AnnotationConfigSpringWebModelContributor.isConfigurationOrComponent(rootConfigClasses)) continue;
            ServletFileSet.addInFileset((SpringFileSet)rootContext, rootConfigClasses.getContainingFile());
        }
        initializerServletFileSet.addDependency((SpringFileSet)rootContext);
        fileSets.add(rootContext);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springFacet";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/config/anno/AnnotationConfigSpringWebModelContributor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/config/anno/AnnotationConfigSpringWebModelContributor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesets";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomInitializers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilesets";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getServlet";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6 -> new IllegalStateException(string);
        };
    }
}

