/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import com.intellij.kubernetes.api.MockCommand;
import com.intellij.kubernetes.api.ProcessMock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u00a1\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0089\u0001\u0010\u0005\u001a\u0084\u0001\b\u0001\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012%\u0012#\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000b0\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0013J4\u0010\u0017\u001a&\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000b0\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u000b2\u0006\u0010\u0018\u001a\u00020\u0004H\u0002J6\u0010\u0019\u001a(\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000b0\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u0003\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u0004H\u0002J\b\u0010\u001b\u001a\u00020\u0004H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0004H\u0016J\u0016\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u001fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0096\u0001\u0010\u0005\u001a\u0084\u0001\b\u0001\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\n\u0012%\u0012#\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000b0\u0003\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\f\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0006\u00a2\u0006\n\n\u0002\u0010\u0016\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/intellij/kubernetes/api/KubectlMockCommand;", "Lcom/intellij/kubernetes/api/MockCommand;", "firstPositionalArguments", "", "", "handler", "Lkotlin/Function5;", "Lkotlin/ParameterName;", "name", "fullCommand", "positionalArgs", "Lkotlin/Pair;", "parameters2Values", "Lcom/intellij/kubernetes/api/ProcessMock;", "process", "Lkotlin/coroutines/Continuation;", "", "", "<init>", "(Ljava/util/List;Lkotlin/jvm/functions/Function5;)V", "getHandler", "()Lkotlin/jvm/functions/Function5;", "Lkotlin/jvm/functions/Function5;", "parseCommandLineArgs", "argsString", "parseCommandLine", "commandLineString", "toString", "canHandle", "", "handle", "(Lcom/intellij/kubernetes/api/ProcessMock;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nMockFlowProcessExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockFlowProcessExecutor.kt\ncom/intellij/kubernetes/api/KubectlMockCommand\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,352:1\n774#2:353\n865#2,2:354\n*S KotlinDebug\n*F\n+ 1 MockFlowProcessExecutor.kt\ncom/intellij/kubernetes/api/KubectlMockCommand\n*L\n252#1:353\n252#1:354,2\n*E\n"})
public final class KubectlMockCommand
implements MockCommand {
    @NotNull
    private final List<String> firstPositionalArguments;
    @NotNull
    private final Function5<String, List<String>, List<Pair<String, String>>, ProcessMock, Continuation<? super Integer>, Object> handler;

    public KubectlMockCommand(@NotNull List<String> firstPositionalArguments, @NotNull Function5<? super String, ? super List<String>, ? super List<Pair<String, String>>, ? super ProcessMock, ? super Continuation<? super Integer>, ? extends Object> handler) {
        Intrinsics.checkNotNullParameter(firstPositionalArguments, (String)"firstPositionalArguments");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.firstPositionalArguments = firstPositionalArguments;
        this.handler = handler;
    }

    @NotNull
    public final Function5<String, List<String>, List<Pair<String, String>>, ProcessMock, Continuation<? super Integer>, Object> getHandler() {
        return this.handler;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<List<Pair<String, String>>, List<String>> parseCommandLineArgs(String argsString) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        List parameters2Values = new ArrayList();
        Object object = argsString;
        Regex regex = new Regex("\\s+");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tokens = (List)destination$iv$iv;
        List positionalArgs = new ArrayList();
        for (int i = 0; i < tokens.size(); ++i) {
            String token = (String)tokens.get(i);
            if (StringsKt.startsWith$default((String)token, (String)"--", (boolean)false, (int)2, null)) {
                if (StringsKt.contains$default((CharSequence)token, (CharSequence)"=", (boolean)false, (int)2, null)) {
                    String[] $i$f$filterTo2 = new String[]{"="};
                    List list2 = StringsKt.split$default((CharSequence)token, (String[])$i$f$filterTo2, (boolean)false, (int)2, (int)2, null);
                    String key = (String)list2.get(0);
                    String value2 = (String)list2.get(1);
                    parameters2Values.add(TuplesKt.to((Object)key, (Object)value2));
                    continue;
                }
                if (i + 1 < tokens.size() && !StringsKt.startsWith$default((String)((String)tokens.get(i + 1)), (String)"--", (boolean)false, (int)2, null)) {
                    parameters2Values.add(TuplesKt.to((Object)token, tokens.get(i + 1)));
                    ++i;
                    continue;
                }
                parameters2Values.add(TuplesKt.to((Object)token, (Object)""));
                continue;
            }
            positionalArgs.add(token);
        }
        return TuplesKt.to((Object)parameters2Values, (Object)positionalArgs);
    }

    private final Pair<List<Pair<String, String>>, List<String>> parseCommandLine(String commandLineString) {
        Regex kubectlPrefixRegex = new Regex("kubectl\\s+(--kubeconfig\\s+(?:\"([^\"]+)\"|(\\S+))\\s+--context\\s+(\\S+)\\s+.*)", RegexOption.IGNORE_CASE);
        MatchResult matchResult = Regex.find$default((Regex)kubectlPrefixRegex, (CharSequence)commandLineString, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult matchResult2 = matchResult;
        String allArgs = (String)matchResult2.getGroupValues().get(1);
        Pair<List<Pair<String, String>>, List<String>> pair = this.parseCommandLineArgs(allArgs);
        List parameters2Values = (List)pair.component1();
        List positionalArgs = (List)pair.component2();
        if (!Intrinsics.areEqual((Object)CollectionsKt.take((Iterable)positionalArgs, (int)this.firstPositionalArguments.size()), this.firstPositionalArguments)) {
            return null;
        }
        return TuplesKt.to((Object)parameters2Values, (Object)positionalArgs);
    }

    @NotNull
    public String toString() {
        return "kubectlHandler(" + CollectionsKt.joinToString$default((Iterable)this.firstPositionalArguments, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + ")";
    }

    @Override
    public boolean canHandle(@NotNull String commandLineString) {
        Intrinsics.checkNotNullParameter((Object)commandLineString, (String)"commandLineString");
        return this.parseCommandLine(commandLineString) != null;
    }

    @Override
    @Nullable
    public Object handle(@NotNull ProcessMock process2, @NotNull Continuation<? super Integer> $completion) {
        Pair<List<Pair<String, String>>, List<String>> pair = this.parseCommandLine(process2.getCommandLineString());
        Intrinsics.checkNotNull(pair);
        Pair<List<Pair<String, String>>, List<String>> pair2 = pair;
        List parameters2Values = (List)pair2.component1();
        List positionalArgs = (List)pair2.component2();
        return this.handler.invoke((Object)process2.getCommandLineString(), (Object)positionalArgs, (Object)parameters2Values, (Object)process2, $completion);
    }
}

