/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.xml.custom;

import com.intellij.spring.model.xml.custom.CustomBeanParser;
import com.intellij.spring.model.xml.custom.LenientProblemReporter;
import com.intellij.spring.model.xml.custom.MyBeanDefinitionsRegistry;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.parsing.SourceExtractor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.DocumentLoader;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public final class CustomBeanParserUtil {
    static final String COPY_KEY = "CustomBeanParser.COPY_KEY";
    private static final int[] EMPTY_INT_ARRAY = new int[0];

    private CustomBeanParserUtil() {
    }

    static void parseCustomBean(String tagText, int timeout) {
        List result;
        try {
            result = CustomBeanParserUtil.getAdditionalBeans(tagText, timeout);
        }
        catch (Throwable throwable) {
            CustomBeanParser.printException(throwable);
            return;
        }
        if (result == null) {
            System.out.print("timeout\n\n##$%^$&%@^#%$#%^&$^&%*&^(*(^&*(&^*&%*&%&*^\n");
            return;
        }
        System.out.print("result\n");
        System.out.print(result.get(0));
        for (int i = 1; i < result.size(); ++i) {
            List s2 = (List)result.get(i);
            System.out.print("\ninfo\n");
            for (String s1 : s2) {
                System.out.print(s1 + "\n");
            }
            System.out.print("info_end");
        }
        System.out.print("\n\n##$%^$&%@^#%$#%^&$^&%*&^(*(^&*(&^*&%*&%&*^\n");
    }

    public static List getAdditionalBeans(String text, int timeout) throws Throwable {
        final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        MyBeanDefinitionsRegistry registry = new MyBeanDefinitionsRegistry();
        final XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)registry);
        reader.setValidationMode(0);
        reader.setNamespaceAware(true);
        reader.setDocumentLoader(new DocumentLoader(){

            public Document loadDocument(InputSource inputSource, EntityResolver entityResolver, ErrorHandler errorHandler, int validationMode, boolean namespaceAware) throws Exception {
                factory.setNamespaceAware(namespaceAware);
                factory.setValidating(false);
                DocumentBuilder builder = factory.newDocumentBuilder();
                if (entityResolver != null) {
                    builder.setEntityResolver(entityResolver);
                }
                if (errorHandler != null) {
                    builder.setErrorHandler(errorHandler);
                }
                Document document = builder.parse(inputSource);
                this.process(document.getDocumentElement(), EMPTY_INT_ARRAY);
                return document;
            }

            private void process(Element element, int[] path) {
                try {
                    element.setUserData(CustomBeanParserUtil.COPY_KEY, path, null);
                }
                catch (Throwable e) {
                    throw new RuntimeException("class " + element.getClass().getName() + " doesn't conform to the interface " + Element.class.getName() + " specification:\n     " + e + "\nCheck your classpath for outdated XML APIs (Xerces, etc.)");
                }
                int index = 0;
                NodeList nodes = element.getChildNodes();
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    if (!(node instanceof Element)) continue;
                    this.process((Element)node, CustomBeanParserUtil.append(path, index));
                    ++index;
                }
            }
        });
        reader.setProblemReporter((ProblemReporter)new LenientProblemReporter());
        reader.setSourceExtractor(new SourceExtractor(){

            public Object extractSource(Object sourceCandidate, Resource definingResource) {
                return sourceCandidate instanceof Element ? ((Element)sourceCandidate).getUserData(CustomBeanParserUtil.COPY_KEY) : null;
            }
        });
        final ByteArrayResource resource = new ByteArrayResource(text.getBytes());
        final SemaphoreCopy reads = new SemaphoreCopy();
        reads.down();
        final Throwable[] exception = new Throwable[1];
        Thread thread = new Thread("custom bean parse"){

            @Override
            public void run() {
                try {
                    reader.loadBeanDefinitions((Resource)resource);
                }
                catch (Throwable e) {
                    exception[0] = e;
                }
                finally {
                    reads.up();
                }
            }
        };
        thread.start();
        if (!reads.waitFor(timeout)) {
            return null;
        }
        Throwable throwable = exception[0];
        if (throwable != null) {
            Throwable cause;
            while (throwable instanceof BeanDefinitionStoreException && (cause = ((BeanDefinitionStoreException)throwable).getRootCause()) != null) {
                throwable = cause;
            }
            throw throwable;
        }
        return registry.getResult();
    }

    public static int[] append(int[] array, int value) {
        array = CustomBeanParserUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        return array;
    }

    public static int[] realloc(int[] array, int newSize) {
        if (newSize == 0) {
            return EMPTY_INT_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            return array;
        }
        int[] result = new int[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(oldSize, newSize));
        return result;
    }

    private static class SemaphoreCopy {
        private int mySemaphore = 0;

        private SemaphoreCopy() {
        }

        public synchronized void down() {
            ++this.mySemaphore;
        }

        public synchronized void up() {
            --this.mySemaphore;
            if (this.mySemaphore == 0) {
                this.notifyAll();
            }
        }

        public synchronized boolean waitFor(long timeout) {
            try {
                if (this.mySemaphore == 0) {
                    return true;
                }
                long startTime = System.currentTimeMillis();
                long waitTime = timeout;
                while (this.mySemaphore > 0) {
                    this.wait(waitTime);
                    long elapsed = System.currentTimeMillis() - startTime;
                    if (elapsed >= timeout) break;
                    waitTime = timeout - elapsed;
                }
                return this.mySemaphore == 0;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

