/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.refactoring;

import com.intellij.kotlin.jupyter.core.editor.find.FindUsagesHandlerKt;
import com.intellij.kotlin.jupyter.core.editor.find.KotlinNotebookElementFindUsagesHandler;
import com.intellij.kotlin.jupyter.core.editor.refactoring.NotebookMemberInplaceRenamer;
import com.intellij.kotlin.jupyter.core.editor.refactoring.NotebookRefactoringSupport;
import com.intellij.kotlin.jupyter.core.editor.refactoring.RenamingKt;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.notifications.KotlinNotebookNotifications;
import com.intellij.kotlin.jupyter.core.notifications.NotificationsKt;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerService;
import com.intellij.kotlin.jupyter.core.scriptingSupport.NotebookStructurePerFileTracker;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.inplace.MemberInplaceRenamer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.NotNullList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001c\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u00032\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013H\u0014J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u0014J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\b\u0010#\u001a\u0004\u0018\u00010$H\u0014J\u0018\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0013H\u0014JB\u0010'\u001a\u00020\u00032\b\u0010(\u001a\u0004\u0018\u00010\u00032\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\"0*2\u0018\u0010+\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020-0,0*2\u0006\u0010.\u001a\u00020\u0010H\u0014J\u0010\u0010/\u001a\u00020-2\u0006\u0010\u001d\u001a\u00020\u0003H\u0014J$\u00100\u001a\u00020\u000e2\u001a\u00101\u001a\u0016\u0012\u0004\u0012\u00020\u0013\u0018\u000102j\n\u0012\u0004\u0012\u00020\u0013\u0018\u0001`3H\u0016J\n\u00104\u001a\u0004\u0018\u00010\u0005H\u0014J$\u00105\u001a\u00020\u000e2\b\u00106\u001a\u0004\u0018\u00010\u00032\b\u00107\u001a\u0004\u0018\u00010\"2\u0006\u0010.\u001a\u00020\u0010H\u0014R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0011\u001a\u000f\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/refactoring/NotebookMemberInplaceRenamer;", "Lcom/intellij/refactoring/rename/inplace/MemberInplaceRenamer;", "substituted", "Lcom/intellij/psi/PsiElement;", "elementToRename", "Lcom/intellij/psi/PsiNamedElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "originalHostInvocation", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiNamedElement;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiLanguageInjectionHost;)V", "originalElement", "isSameScope", "", "foundRefsSize", "", "prevClassData", "", "", "Lorg/jetbrains/annotations/Nullable;", "fileSuffix", "getFileSuffix", "()Ljava/lang/String;", "topLevelDocument", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/NotNull;", "performRenameInner", "", "element", "newName", "getNameIdentifier", "collectRefs", "", "Lcom/intellij/psi/PsiReference;", "referencesSearchScope", "Lcom/intellij/psi/search/SearchScope;", "createRenameProcessor", "Lcom/intellij/refactoring/rename/RenameProcessor;", "getSelectedInEditorElement", "nameIdentifier", "refs", "", "stringUsages", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/util/TextRange;", "offset", "getRangeToRename", "performInplaceRefactoring", "nameSuggestions", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "getVariable", "isReferenceAtCaret", "selectedElement", "ref", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookMemberInplaceRenamer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookMemberInplaceRenamer.kt\ncom/intellij/kotlin/jupyter/core/editor/refactoring/NotebookMemberInplaceRenamer\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 3 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,244:1\n232#2:245\n13#3:246\n*S KotlinDebug\n*F\n+ 1 NotebookMemberInplaceRenamer.kt\ncom/intellij/kotlin/jupyter/core/editor/refactoring/NotebookMemberInplaceRenamer\n*L\n149#1:245\n208#1:246\n*E\n"})
public final class NotebookMemberInplaceRenamer
extends MemberInplaceRenamer {
    @Nullable
    private final PsiLanguageInjectionHost originalHostInvocation;
    @NotNull
    private final PsiElement originalElement;
    private final boolean isSameScope;
    private int foundRefsSize;
    @Nullable
    private final Set<String> prevClassData;
    @NotNull
    private final Document topLevelDocument;

    public NotebookMemberInplaceRenamer(@NotNull PsiElement substituted, @NotNull PsiNamedElement elementToRename, @NotNull Editor editor, @Nullable PsiLanguageInjectionHost originalHostInvocation) {
        Intrinsics.checkNotNullParameter((Object)substituted, (String)"substituted");
        Intrinsics.checkNotNullParameter((Object)elementToRename, (String)"elementToRename");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(elementToRename, (PsiElement)elementToRename, editor);
        this.originalHostInvocation = originalHostInvocation;
        this.originalElement = substituted;
        this.isSameScope = Intrinsics.areEqual((Object)this.originalElement.getContainingFile(), (Object)elementToRename.getContainingFile());
        PsiLanguageInjectionHost psiLanguageInjectionHost = this.originalHostInvocation;
        this.prevClassData = psiLanguageInjectionHost != null ? (Set)psiLanguageInjectionHost.getUserData(NotebookStructurePerFileTracker.Companion.getCELL_CLASS_NAME()) : null;
        Document document = PsiDocumentManagerBase.getTopLevelDocument((Document)this.myEditor.getDocument());
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getTopLevelDocument(...)");
        this.topLevelDocument = document;
    }

    private final String getFileSuffix() {
        Project project = this.originalElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return JupyterCompilerService.Companion.getInstance(project).getFileSuffix();
    }

    protected void performRenameInner(@Nullable PsiElement element, @Nullable String newName) {
        block2: {
            super.performRenameInner(element, newName);
            if (element == null) break block2;
            String string = newName;
            boolean bl = string != null ? ((CharSequence)string).length() > 0 : false;
            if (bl && this.prevClassData != null) {
                PsiLanguageInjectionHost psiLanguageInjectionHost = this.originalHostInvocation;
                if (psiLanguageInjectionHost != null) {
                    psiLanguageInjectionHost.putUserData(NotebookStructurePerFileTracker.Companion.getCELL_CLASS_NAME(), this.prevClassData);
                }
            }
        }
    }

    @Nullable
    protected PsiElement getNameIdentifier() {
        PsiNamedElement elem = this.myElementToRename;
        return elem instanceof KtClass ? ((KtClass)elem).getNameIdentifier() : (elem instanceof KtProperty ? ((KtProperty)elem).getNameIdentifier() : (elem instanceof KtNamedFunction ? ((KtNamedFunction)elem).getNameIdentifier() : (elem instanceof PsiNameIdentifierOwner ? ((PsiNameIdentifierOwner)elem).getNameIdentifier() : (PsiElement)elem)));
    }

    @NotNull
    protected Collection<PsiReference> collectRefs(@Nullable SearchScope referencesSearchScope) {
        Collection collection = super.collectRefs(referencesSearchScope);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"collectRefs(...)");
        return collection;
    }

    @NotNull
    protected RenameProcessor createRenameProcessor(@NotNull PsiElement element, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        return (RenameProcessor)new MemberInplaceRenamer.MyRenameProcessor(element, this, newName){
            private final KotlinNotebookElementFindUsagesHandler findUsagesNotebookHandler;
            private final InjectedLanguageManager injectedManager;
            private final PsiLanguageInjectionHost elementHost;
            private Collection<? extends TextRange> adjustmentTextRange;
            private Set<Integer> affectedCells;
            private final Editor topLevelEditor;
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ NotebookMemberInplaceRenamer this$0;
            {
                this.$element = $element;
                this.this$0 = $receiver;
                super((MemberInplaceRenamer)$receiver, $element, $newName);
                this.findUsagesNotebookHandler = new KotlinNotebookElementFindUsagesHandler($element, false, false, 6, null);
                this.injectedManager = InjectedLanguageManager.getInstance((Project)$element.getProject());
                this.elementHost = this.injectedManager.getInjectionHost((PsiElement)$element.getContainingFile());
                Editor editor = InjectedLanguageEditorUtil.getTopLevelEditor((Editor)NotebookMemberInplaceRenamer.access$getMyEditor$p$s1910781799($receiver));
                Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getTopLevelEditor(...)");
                this.topLevelEditor = editor;
            }

            public void performRefactoring(UsageInfo[] usages) {
                Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
                if (NotebookMemberInplaceRenamer.access$getFoundRefsSize$p(this.this$0) > 0) {
                    Project project = this.$element.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    NotificationsKt.getNotebookNotifications(project).showRerunActionNeeded();
                }
                ActionsKt.runReadAction(() -> createRenameProcessor.1.performRefactoring$lambda$0(this, usages));
            }

            /*
             * WARNING - void declaration
             */
            public UsageInfo[] findUsages() {
                void $this$forEach$iv;
                Iterable<E> thisCollection$iv;
                MoveRenameUsageInfo it;
                Object destination$iv$iv;
                List ans;
                int size = NotebookMemberInplaceRenamer.access$getFoundRefsSize$p(this.this$0);
                Project project = this.$element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                KotlinNotebookNotifications notificationUtility = NotificationsKt.getNotebookNotifications(project);
                do {
                    void $this$mapTo$iv$iv;
                    PsiNamedElement psiNamedElement = NotebookMemberInplaceRenamer.access$getMyElementToRename$p$s1910781799(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)psiNamedElement, (String)"access$getMyElementToRename$p$s1910781799(...)");
                    PsiElement psiElement = (PsiElement)psiNamedElement;
                    GlobalSearchScope globalSearchScope = this.$element.getResolveScope();
                    Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getResolveScope(...)");
                    Iterable $this$map$iv = this.findUsagesNotebookHandler.findReferencesToHighlight(psiElement, (SearchScope)globalSearchScope);
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        PsiReference psiReference = (PsiReference)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(RenamingKt.toMoveUsageInfo((PsiReference)it));
                    }
                    ans = (List)destination$iv$iv;
                    if (!ans.isEmpty()) continue;
                    notificationUtility.showRefactoringExistingUsagesMessage(size);
                    Collection $this$toTypedArray$iv = ans;
                    boolean $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    return thisCollection$iv.toArray(new UsageInfo[0]);
                } while (size > ans.size());
                notificationUtility.showRerunActionNeeded();
                Set targetHostRanges = new LinkedHashSet<E>();
                Set targetHostIndxs = new LinkedHashSet<E>();
                PsiLanguageInjectionHost psiLanguageInjectionHost = this.elementHost;
                if (psiLanguageInjectionHost != null && (psiLanguageInjectionHost = psiLanguageInjectionHost.getTextRange()) != null) {
                    PsiLanguageInjectionHost it2 = psiLanguageInjectionHost;
                    boolean bl = false;
                    targetHostRanges.add(it2);
                }
                thisCollection$iv = ans;
                destination$iv$iv = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (MoveRenameUsageInfo)element$iv;
                    boolean bl = false;
                    PsiElement psiElement = it.getElement();
                    Object el = psiElement != null ? psiElement.getContainingFile() : null;
                    if (el == null) continue;
                    PsiLanguageInjectionHost psiLanguageInjectionHost2 = this.injectedManager.getInjectionHost((PsiElement)el);
                    if (psiLanguageInjectionHost2 == null || (psiLanguageInjectionHost2 = psiLanguageInjectionHost2.getTextRange()) == null) continue;
                    PsiLanguageInjectionHost host2 = psiLanguageInjectionHost2;
                    boolean bl2 = false;
                    CollectionsKt.addIfNotNull((Collection)targetHostIndxs, (Object)NotebookVisualizationUiUtilKt.getCell((Editor)this.topLevelEditor, (int)NotebookMemberInplaceRenamer.access$getTopLevelDocument$p((NotebookMemberInplaceRenamer)((Object)destination$iv$iv)).getLineNumber(host2.getStartOffset())).getOrdinal());
                    targetHostRanges.add(host2);
                }
                if (!((Collection)targetHostRanges).isEmpty()) {
                    this.affectedCells = targetHostIndxs;
                    this.adjustmentTextRange = targetHostRanges;
                }
                Collection $this$toTypedArray$iv = ans;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv2 = $this$toTypedArray$iv;
                return thisCollection$iv2.toArray(new UsageInfo[0]);
            }

            private static final Unit performRefactoring$lambda$0(createRenameProcessor.1 this$0, UsageInfo[] $usages) {
                super.performRefactoring($usages);
                return Unit.INSTANCE;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected PsiElement getSelectedInEditorElement(@Nullable PsiElement nameIdentifier, @NotNull Collection<? extends PsiReference> refs, @NotNull Collection<? extends Pair<PsiElement, TextRange>> stringUsages, int offset) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter(refs, (String)"refs");
        Intrinsics.checkNotNullParameter(stringUsages, (String)"stringUsages");
        if (Intrinsics.areEqual((Object)nameIdentifier, (Object)this.myElementToRename) && this.isSameScope) {
            PsiNamedElement psiNamedElement = this.myElementToRename;
            Intrinsics.checkNotNullExpressionValue((Object)psiNamedElement, (String)"myElementToRename");
            psiElement = (PsiElement)psiNamedElement;
        } else {
            void $this$getParentOfType$iv;
            PsiElement psiElement2 = this.originalElement;
            boolean strict$iv = false;
            boolean $i$f$getParentOfType = false;
            KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtReferenceExpression.class, (boolean)strict$iv);
            psiElement = ktReferenceExpression != null ? (PsiElement)ktReferenceExpression : this.originalElement;
        }
        return psiElement;
    }

    @NotNull
    protected TextRange getRangeToRename(@NotNull PsiElement element) {
        TextRange textRange;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (NotebookRefactoringSupport.INSTANCE.isNotebookRefactoringSupported(element)) {
            String name = this.originalElement.getText();
            Ref.ObjectRef idRange = new Ref.ObjectRef();
            element.accept((PsiElementVisitor)new PsiRecursiveElementVisitor((Ref.ObjectRef<TextRange>)idRange, name){
                final /* synthetic */ Ref.ObjectRef<TextRange> $idRange;
                final /* synthetic */ String $name;
                {
                    this.$idRange = $idRange;
                    this.$name = $name;
                }

                public void visitElement(PsiElement element) {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    if (this.$idRange.element != null) {
                        return;
                    }
                    if (element instanceof LeafPsiElement && FindUsagesHandlerKt.isIdentifier(element) && Intrinsics.areEqual((Object)((LeafPsiElement)element).getText(), (Object)this.$name)) {
                        this.$idRange.element = ((LeafPsiElement)element).getTextRangeInParent();
                        return;
                    }
                    super.visitElement(element);
                }
            });
            textRange = (TextRange)idRange.element;
            if (textRange == null) {
                TextRange textRange2 = element.getTextRangeInParent();
                textRange = textRange2;
                Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"getTextRangeInParent(...)");
            }
        } else {
            TextRange textRange3 = super.getRangeToRename(element);
            textRange = textRange3;
            Intrinsics.checkNotNullExpressionValue((Object)textRange3, (String)"getRangeToRename(...)");
        }
        return textRange;
    }

    public boolean performInplaceRefactoring(@Nullable LinkedHashSet<String> nameSuggestions) {
        boolean bl;
        if (this.myEditor instanceof ImaginaryEditor && !Intrinsics.areEqual((Object)this.myEditor.getUserData(MemberInplaceRenamer.INPLACE_RENAME_ALLOWED), (Object)true)) {
            return false;
        }
        this.myNameSuggestions = nameSuggestions;
        if (InjectedLanguageUtil.isInInjectedLanguagePrefixSuffix((PsiElement)((PsiElement)this.myElementToRename))) {
            return false;
        }
        PsiNamedElement psiNamedElement = this.myElementToRename;
        Intrinsics.checkNotNullExpressionValue((Object)psiNamedElement, (String)"myElementToRename");
        KotlinNotebookElementFindUsagesHandler kotlinNotebookElementFindUsagesHandler = new KotlinNotebookElementFindUsagesHandler((PsiElement)psiNamedElement, false, false, 6, null);
        PsiNamedElement psiNamedElement2 = this.myElementToRename;
        Intrinsics.checkNotNullExpressionValue((Object)psiNamedElement2, (String)"myElementToRename");
        PsiElement psiElement = (PsiElement)psiNamedElement2;
        SearchScope searchScope = this.myElementToRename.getUseScope();
        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getUseScope(...)");
        Collection<PsiReference> references = kotlinNotebookElementFindUsagesHandler.findReferencesToHighlight(psiElement, searchScope);
        PsiElement psiElement2 = this.checkLocalScope();
        if (psiElement2 == null) {
            return false;
        }
        PsiElement scope = psiElement2;
        PsiFile psiFile = scope.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile containingFile = psiFile;
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)this.myProject, (PsiElement)((PsiElement)containingFile))) {
            return true;
        }
        this.myEditor.putUserData(MemberInplaceRenamer.INPLACE_RENAMER, (Object)this);
        this.foundRefsSize = references.size();
        List stringUsages = (List)new NotNullList();
        this.collectAdditionalElementsToRename(stringUsages);
        try {
            bl = this.buildTemplateAndStart(references, stringUsages, scope, containingFile);
        }
        catch (Throwable e) {
            this.myEditor.putUserData(MemberInplaceRenamer.INPLACE_RENAMER, null);
            FinishMarkAction.finish((Project)this.myProject, (Editor)this.myEditor, (StartMarkAction)this.myMarkAction);
            this.foundRefsSize = 0;
            if (e instanceof ProcessCanceledException) {
                throw e;
            }
            NotebookMemberInplaceRenamer $this$notebookLogger$iv = this;
            boolean $i$f$notebookLogger = false;
            KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(NotebookMemberInplaceRenamer.class)).warn("Error occurred during template", e);
            return false;
        }
        return bl;
    }

    @Nullable
    protected PsiNamedElement getVariable() {
        PsiFile psiFile;
        Class<PsiNameIdentifierOwner> clazz = this.myElementToRename != null ? this.myElementToRename.getClass() : PsiNameIdentifierOwner.class;
        PsiNamedElement psiNamedElement = this.myElementToRename;
        if (psiNamedElement != null) {
            PsiNamedElement toRename = psiNamedElement;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)this.myOldName, (Object)toRename.getName())) {
                return toRename;
            }
            if (this.myRenameOffset != null) {
                return (PsiNamedElement)PsiTreeUtil.findElementOfClassAtRange((PsiFile)toRename.getContainingFile(), (int)this.myRenameOffset.getStartOffset(), (int)this.myRenameOffset.getEndOffset(), clazz);
            }
        }
        if (this.myRenameOffset != null && (psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument())) != null) {
            PsiFile psiFile2 = psiFile;
            boolean bl = false;
            return (PsiNamedElement)PsiTreeUtil.findElementOfClassAtRange((PsiFile)psiFile2, (int)this.myRenameOffset.getStartOffset(), (int)this.myRenameOffset.getEndOffset(), clazz);
        }
        return this.myElementToRename;
    }

    protected boolean isReferenceAtCaret(@Nullable PsiElement selectedElement, @Nullable PsiReference ref, int offset) {
        Object object = selectedElement;
        return (object != null && (object = object.getContainingFile()) != null && (object = object.getName()) != null ? StringsKt.endsWith$default((String)object, (String)this.getFileSuffix(), (boolean)false, (int)2, null) : false) ? super.isReferenceAtCaret(selectedElement, ref) : super.isReferenceAtCaret(selectedElement, ref, offset);
    }

    public static final /* synthetic */ Editor access$getMyEditor$p$s1910781799(NotebookMemberInplaceRenamer $this) {
        return $this.myEditor;
    }

    public static final /* synthetic */ int access$getFoundRefsSize$p(NotebookMemberInplaceRenamer $this) {
        return $this.foundRefsSize;
    }

    public static final /* synthetic */ PsiNamedElement access$getMyElementToRename$p$s1910781799(NotebookMemberInplaceRenamer $this) {
        return $this.myElementToRename;
    }

    public static final /* synthetic */ Document access$getTopLevelDocument$p(NotebookMemberInplaceRenamer $this) {
        return $this.topLevelDocument;
    }
}

