/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.find;

import com.intellij.kotlin.jupyter.core.editor.find.NotebookReferenceExpressionResolver;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtReferenceExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000b\u001a\u00020\u0002H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0006H\u0014J\b\u0010\u000f\u001a\u00020\u0006H\u0016J\b\u0010\u0010\u001a\u00020\bH\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/find/NotebookReferenceWrapper;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "resolvedTo", "element", "range", "Lcom/intellij/openapi/util/TextRange;", "soft", "", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;Z)V", "resolve", "getValue", "", "calculateDefaultRangeInElement", "getRangeInElement", "isSoft", "handleElementRename", "newElementName", "intellij.kotlin.jupyter.core"})
public final class NotebookReferenceWrapper
extends PsiReferenceBase<PsiElement> {
    @NotNull
    private final PsiElement resolvedTo;
    @NotNull
    private final TextRange range;
    private final boolean soft;

    public NotebookReferenceWrapper(@NotNull PsiElement resolvedTo, @NotNull PsiElement element, @NotNull TextRange range, boolean soft) {
        Intrinsics.checkNotNullParameter((Object)resolvedTo, (String)"resolvedTo");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        super(element);
        this.resolvedTo = resolvedTo;
        this.range = range;
        this.soft = soft;
    }

    @NotNull
    public PsiElement resolve() {
        return this.resolvedTo;
    }

    @NotNull
    public String getValue() {
        String string = this.getElement().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }

    @NotNull
    protected TextRange calculateDefaultRangeInElement() {
        return this.range;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return this.range;
    }

    public boolean isSoft() {
        return this.soft;
    }

    @Nullable
    public PsiElement handleElementRename(@NotNull String newElementName) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)newElementName, (String)"newElementName");
        PsiElement psiElement2 = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"getElement(...)");
        PsiElement el = psiElement2;
        if (el instanceof KtReferenceExpression) {
            psiElement = NotebookReferenceExpressionResolver.INSTANCE.getReferenceExpressionManipulator().handleContentChange(el, newElementName);
        } else if (el instanceof LeafPsiElement) {
            psiElement = NotebookReferenceExpressionResolver.INSTANCE.getLeafPsiManipulator().handleContentChange(el, newElementName);
        } else {
            throw new IllegalStateException(("Can't handle rename for " + this.getElement()).toString());
        }
        return psiElement;
    }
}

