/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.helper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.JupyterJsonKt;
import com.intellij.jupyter.core.core.impl.file.JupyterNotebookLanguageUtils;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.jupyter.core.jupyter.helper.JupyterCellLinesExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCellBuilder;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookConverter;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookSchema;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookSchemaFactory;
import com.intellij.jupyter.core.jupyter.nbformat.schema.JupyterNotebookSchemaVersion;
import com.intellij.notebooks.jupyter.core.jupyter.JupyterFileType;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SlowOperations;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellTypeProvider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u0015\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u001eH\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/jupyter/core/jupyter/helper/JupyterFileUtils;", "", "<init>", "()V", "readNotebookOrNull", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookBase;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "text", "", "fileName", "", "readNotebook", "createEmptyNotebook", "schemaVersion", "Lcom/intellij/jupyter/core/jupyter/nbformat/schema/JupyterNotebookSchemaVersion;", "restoreJupyterNotebookFromSource", "virtualFile", "getOriginalFile", "restoreJsonFromText", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "notebook", "initFromJson", "json", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "restoreNotebookFromDocument", "document", "Lcom/intellij/openapi/editor/Document;", "isJsonFile", "", "Lcom/intellij/testFramework/LightVirtualFile;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterFileUtils.kt\ncom/intellij/jupyter/core/jupyter/helper/JupyterFileUtils\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,192:1\n23#2:193\n23#2:194\n*S KotlinDebug\n*F\n+ 1 JupyterFileUtils.kt\ncom/intellij/jupyter/core/jupyter/helper/JupyterFileUtils\n*L\n44#1:193\n54#1:194\n*E\n"})
public final class JupyterFileUtils {
    @NotNull
    public static final JupyterFileUtils INSTANCE = new JupyterFileUtils();

    private JupyterFileUtils() {
    }

    @Nullable
    public final JupyterNotebookBase readNotebookOrNull(@NotNull VirtualFile file) {
        JupyterNotebookBase jupyterNotebookBase;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file instanceof LightVirtualFile && VirtualFileUtil.originalFile((VirtualFile)file) == null) {
            return null;
        }
        try {
            jupyterNotebookBase = this.readNotebook(file);
        }
        catch (Throwable t) {
            if (t instanceof CancellationException) {
                throw t;
            }
            JupyterFileUtils $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterFileUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot read file " + file.getPath(), t);
            jupyterNotebookBase = null;
        }
        return jupyterNotebookBase;
    }

    @Nullable
    public final JupyterNotebookBase readNotebookOrNull(@NotNull CharSequence text, @NotNull String fileName) {
        JupyterNotebookBase jupyterNotebookBase;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        try {
            jupyterNotebookBase = this.readNotebook(text);
        }
        catch (Throwable t) {
            JupyterFileUtils $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterFileUtils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Cannot read file " + fileName, t);
            jupyterNotebookBase = null;
        }
        return jupyterNotebookBase;
    }

    public static /* synthetic */ JupyterNotebookBase readNotebookOrNull$default(JupyterFileUtils jupyterFileUtils, CharSequence charSequence, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "unknown";
        }
        return jupyterFileUtils.readNotebookOrNull(charSequence, string);
    }

    @NotNull
    public final JupyterNotebookBase readNotebook(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile originalFile = this.getOriginalFile(file);
        long fileSize = originalFile.getLength();
        if (fileSize == 0L || PlatformUtils.isJetBrainsClient()) {
            JupyterNotebookBase notebookBase = JupyterFileUtils.createEmptyNotebook$default(this, null, 1, null);
            notebookBase.addCell((Function1<? super JupyterCellBuilder, Unit>)((Function1)JupyterFileUtils::readNotebook$lambda$0));
            JupyterNotebookLanguageUtils.INSTANCE.setNotebookLanguage(originalFile, notebookBase.getLanguage());
            return notebookBase;
        }
        SlowOperations.assertSlowOperationsAreAllowed();
        byte[] cachedBytes = originalFile.getInputStream().readNBytes(FileUtilRt.LARGE_FOR_CONTENT_LOADING);
        CharSequence charSequence = LoadTextUtil.getTextByBinaryPresentation((byte[])cachedBytes, (VirtualFile)originalFile, (boolean)true, (boolean)true, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getTextByBinaryPresentation(...)");
        CharSequence text = charSequence;
        try {
            ObjectNode objectNode;
            if (fileSize < (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
                JsonNode jsonNode = JupyterJsonKt.getJackson().readTree(((Object)text).toString());
                Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
                objectNode = (ObjectNode)jsonNode;
            } else {
                JsonNode jsonNode = JupyterJsonKt.getJackson().readTree(originalFile.getInputStream());
                Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
                objectNode = (ObjectNode)jsonNode;
            }
            ObjectNode json = objectNode;
            JupyterNotebookBase notebook = this.initFromJson(json);
            JupyterNotebookLanguageUtils.INSTANCE.setNotebookLanguage(originalFile, notebook.getLanguage());
            return notebook;
        }
        catch (Throwable t) {
            if (t instanceof CancellationException) {
                throw t;
            }
            throw new IOException("Cannot read file " + originalFile.getPath(), t);
        }
    }

    @NotNull
    public final JupyterNotebookBase readNotebook(@NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        JsonNode jsonNode = JupyterJsonKt.getJackson().readTree(((Object)text).toString());
        Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        ObjectNode json = (ObjectNode)jsonNode;
        JupyterNotebookBase notebook = this.initFromJson(json);
        return notebook;
    }

    @NotNull
    public final JupyterNotebookBase createEmptyNotebook(@NotNull JupyterNotebookSchemaVersion schemaVersion) {
        Intrinsics.checkNotNullParameter((Object)schemaVersion, (String)"schemaVersion");
        JupyterNotebookSchema schema = JupyterNotebookSchemaFactory.INSTANCE.createSchema(schemaVersion);
        return new JupyterNotebookBase(schema.createEmptyNotebook(), schema);
    }

    public static /* synthetic */ JupyterNotebookBase createEmptyNotebook$default(JupyterFileUtils jupyterFileUtils, JupyterNotebookSchemaVersion jupyterNotebookSchemaVersion, int n, Object object) {
        if ((n & 1) != 0) {
            jupyterNotebookSchemaVersion = new JupyterNotebookSchemaVersion(4, 5);
        }
        return jupyterFileUtils.createEmptyNotebook(jupyterNotebookSchemaVersion);
    }

    @NotNull
    public final JupyterNotebookBase restoreJupyterNotebookFromSource(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            throw new IllegalStateException(("Try to save file " + virtualFile.getPath() + " without cached data and without document").toString());
        }
        JupyterNotebookBase jupyterNotebookBase = this.readNotebookOrNull(virtualFile);
        if (jupyterNotebookBase == null) {
            jupyterNotebookBase = JupyterFileUtils.createEmptyNotebook$default(this, null, 1, null);
        }
        JupyterNotebookBase notebook = jupyterNotebookBase;
        return this.restoreNotebookFromDocument(document, notebook);
    }

    @NotNull
    public final VirtualFile getOriginalFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (virtualFile instanceof LightVirtualFile && !Intrinsics.areEqual((Object)((LightVirtualFile)virtualFile).getOriginalFile(), (Object)virtualFile) && !this.isJsonFile((LightVirtualFile)virtualFile)) {
            VirtualFile virtualFile2 = ((LightVirtualFile)virtualFile).getOriginalFile();
            if (Intrinsics.areEqual((Object)(virtualFile2 != null ? virtualFile2.getFileType() : null), (Object)JupyterFileType.INSTANCE)) {
                VirtualFile virtualFile3 = ((LightVirtualFile)virtualFile).getOriginalFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"getOriginalFile(...)");
                return this.getOriginalFile(virtualFile3);
            }
        }
        return virtualFile;
    }

    @NotNull
    public final JupyterNotebook restoreJsonFromText(@NotNull CharSequence text, @NotNull JupyterNotebook notebook) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        DocumentImpl document = new DocumentImpl(text);
        return this.restoreNotebookFromDocument((Document)document, notebook);
    }

    public static /* synthetic */ JupyterNotebook restoreJsonFromText$default(JupyterFileUtils jupyterFileUtils, CharSequence charSequence, JupyterNotebook jupyterNotebook, int n, Object object) {
        if ((n & 2) != 0) {
            jupyterNotebook = JupyterFileUtils.createEmptyNotebook$default(jupyterFileUtils, null, 1, null);
        }
        return jupyterFileUtils.restoreJsonFromText(charSequence, jupyterNotebook);
    }

    @NotNull
    public final JupyterNotebookBase initFromJson(@NotNull ObjectNode json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        JupyterNotebookSchema schema = JupyterNotebookSchemaFactory.INSTANCE.createSchema(json);
        JupyterNotebookBase notebook = new JupyterNotebookBase(json, schema);
        JupyterNotebookConverter.Companion.convertAfterLoading(notebook);
        return notebook;
    }

    private final JupyterNotebookBase restoreNotebookFromDocument(Document document, JupyterNotebook notebook) {
        NotebookCellLines.Interval interval;
        int i;
        NotebookCellLines notebookCellLines = new JupyterCellLinesProvider().create(document);
        List intervals = notebookCellLines.getIntervals();
        int toUpdateCounts = Math.min(intervals.size(), notebook.cellsCount());
        int toAddNewCells = Math.max(0, intervals.size() - notebook.cellsCount());
        int toRemoveNewCells = Math.max(0, notebook.cellsCount() - intervals.size());
        for (i = 0; i < toUpdateCounts; ++i) {
            JupyterCell cell = notebook.getCell(i);
            interval = (NotebookCellLines.Interval)intervals.get(i);
            cell.setSource(((Object)interval.getContentText(document)).toString());
            JupyterCellType jupyterCellType = JupyterCellLinesProvider.Util.INSTANCE.getJupyterCellType(interval);
            if (jupyterCellType == null) {
                jupyterCellType = JupyterCellType.Companion.getCODE();
            }
            cell.setCellTypeProvider(JupyterCellTypeProvider.Companion.providerByType(jupyterCellType));
        }
        int n = intervals.size();
        for (i = intervals.size() - toAddNewCells; i < n; ++i) {
            interval = (NotebookCellLines.Interval)intervals.get(i);
            notebook.addCell(i, (Function1<? super JupyterCellBuilder, Unit>)((Function1)arg_0 -> JupyterFileUtils.restoreNotebookFromDocument$lambda$0(interval, document, arg_0)));
        }
        n = notebook.cellsCount();
        for (i = notebook.cellsCount() - toRemoveNewCells; i < n; ++i) {
            notebook.removeCell(i);
        }
        Intrinsics.checkNotNull((Object)notebook, (String)"null cannot be cast to non-null type com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase");
        return (JupyterNotebookBase)notebook;
    }

    private final boolean isJsonFile(LightVirtualFile virtualFile) {
        CharSequence charSequence = virtualFile.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getContent(...)");
        return StringsKt.startsWith$default((CharSequence)charSequence, (CharSequence)"{", (boolean)false, (int)2, null);
    }

    private static final Unit readNotebook$lambda$0(JupyterCellBuilder $this$addCell) {
        Intrinsics.checkNotNullParameter((Object)$this$addCell, (String)"$this$addCell");
        $this$addCell.setCellType(JupyterCellType.Companion.getCODE());
        return Unit.INSTANCE;
    }

    private static final Unit restoreNotebookFromDocument$lambda$0(NotebookCellLines.Interval $interval, Document $document, JupyterCellBuilder $this$addCell) {
        Intrinsics.checkNotNullParameter((Object)$this$addCell, (String)"$this$addCell");
        $this$addCell.setSource(((Object)$interval.getContentText($document)).toString());
        $this$addCell.setCellType(JupyterCellLinesExtensionsKt.toJupyterCellType($interval, $document));
        return Unit.INSTANCE;
    }
}

