/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor;

import com.intellij.lang.Language;
import com.intellij.notebooks.jupyter.core.lang.NotebookLanguage;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.NotebookIntervalPointerFactory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f\u001a\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\f\u001a\u0018\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\n\u001a\u00020\u0002\u001a\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0017\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"isNotebook", "", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/editor/Editor;)Z", "language", "Lcom/intellij/lang/Language;", "getLanguage", "(Lcom/intellij/openapi/editor/Editor;)Lcom/intellij/lang/Language;", "getInterval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "editor", "psiCell", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "getIntervalPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "cell", "index", "", "getAllIntervalPointers", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookMarkdownEditorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookMarkdownEditorManager.kt\ncom/intellij/jupyter/core/editor/NotebookMarkdownEditorManagerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1#2:102\n1563#3:103\n1634#3,3:104\n*S KotlinDebug\n*F\n+ 1 NotebookMarkdownEditorManager.kt\ncom/intellij/jupyter/core/editor/NotebookMarkdownEditorManagerKt\n*L\n96#1:103\n96#1:104,3\n*E\n"})
public final class NotebookMarkdownEditorManagerKt {
    public static final boolean isNotebook(@NotNull Editor $this$isNotebook) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotebook, (String)"<this>");
        Language language = NotebookMarkdownEditorManagerKt.getLanguage($this$isNotebook);
        return Intrinsics.areEqual((Object)(language != null ? language.getBaseLanguage() : null), (Object)NotebookLanguage.INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final Language getLanguage(@NotNull Editor $this$language) {
        Project project;
        Intrinsics.checkNotNullParameter((Object)$this$language, (String)"<this>");
        Project project3 = $this$language.getProject();
        project3 = project3;
        if (project2 == null) return null;
        Project it = project = project3;
        boolean bl = false;
        if (it.isDisposed()) return null;
        boolean bl2 = true;
        if (!bl2) return null;
        Project project3 = project;
        project3 = project3;
        if (project4 == null) return null;
        Project p0 = project3;
        boolean bl3 = false;
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)p0);
        project3 = psiDocumentManager;
        if (psiDocumentManager == null) return null;
        PsiFile psiFile = project3.getPsiFile($this$language.getDocument());
        project3 = psiFile;
        if (psiFile == null) return null;
        Language language = project3.getLanguage();
        return language;
    }

    @Nullable
    public static final NotebookCellLines.Interval getInterval(@NotNull Editor editor, @NotNull JupyterPsiCell psiCell) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiCell, (String)"psiCell");
        if (PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)psiCell)) == PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)psiCell))) {
            return null;
        }
        int line = editor.getDocument().getLineNumber(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)psiCell)));
        return (NotebookCellLines.Interval)NotebookCellLines.Companion.get(editor).intervalsIterator(line).next();
    }

    @Nullable
    public static final NotebookIntervalPointer getIntervalPointer(@NotNull Editor editor, @NotNull JupyterPsiCell cell) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        NotebookCellLines.Interval interval = NotebookMarkdownEditorManagerKt.getInterval(editor, cell);
        if (interval == null) {
            return null;
        }
        NotebookCellLines.Interval interval2 = interval;
        return NotebookIntervalPointerFactory.Companion.get(editor).create(interval2);
    }

    @Nullable
    public static final NotebookIntervalPointer getIntervalPointer(@NotNull Editor editor, int index) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        NotebookCellLines.Interval interval = (NotebookCellLines.Interval)CollectionsKt.getOrNull((List)NotebookCellLines.Companion.get(editor).getIntervals(), (int)index);
        if (interval == null) {
            return null;
        }
        NotebookCellLines.Interval interval2 = interval;
        return NotebookIntervalPointerFactory.Companion.get(editor).create(interval2);
    }

    @NotNull
    public static final List<NotebookIntervalPointer> getAllIntervalPointers(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = editor.getProject();
        if (project == null) {
            return CollectionsKt.emptyList();
        }
        Project project2 = project;
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        return NotebookMarkdownEditorManagerKt.getAllIntervalPointers(project2, document);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<NotebookIntervalPointer> getAllIntervalPointers(@NotNull Project project, @NotNull Document document) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        NotebookIntervalPointerFactory notebookIntervalPointerFactory = NotebookIntervalPointerFactory.Companion.getOrNull(project, document);
        if (notebookIntervalPointerFactory == null) {
            return CollectionsKt.emptyList();
        }
        NotebookIntervalPointerFactory factory = notebookIntervalPointerFactory;
        Iterable $this$map$iv = NotebookCellLines.Companion.get(document).getIntervals();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            NotebookCellLines.Interval interval = (NotebookCellLines.Interval)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(factory.create((NotebookCellLines.Interval)p0));
        }
        return (List)destination$iv$iv;
    }
}

