/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties.references;

import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.NameValueGetter;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaReferenceDesc;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.meta.BasicResolveAssistant;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.database.model.properties.references.BasicRefImporter;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BasicKeyByIndexReference
implements BasicReference {
    public final BasicReference indexRef;

    private BasicKeyByIndexReference(BasicReference indexRef) {
        this.indexRef = indexRef;
    }

    @Override
    @Nullable
    public String getName() {
        return null;
    }

    @Override
    public long getObjectId() {
        return Long.MIN_VALUE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicKeyByIndexReference)) {
            return false;
        }
        BasicKeyByIndexReference reference = (BasicKeyByIndexReference)o;
        return this.indexRef.equals(reference.indexRef);
    }

    @Override
    public boolean isPortable() {
        return this.indexRef.isPortable();
    }

    @Override
    public boolean isCrossPortable() {
        return this.indexRef.isCrossPortable();
    }

    public int hashCode() {
        return Objects.hash(this.indexRef);
    }

    @Nullable
    public static BasicKeyByIndexReference create(@Nullable BasicReference indexRef) {
        return indexRef == null ? null : new BasicKeyByIndexReference(indexRef);
    }

    @Override
    @NotNull
    public <S extends BasicElement, T extends BasicElement> JBIterable<T> multiResolve(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull BasicResolveAssistant assistant) {
        BasicElement base;
        BasicElement root;
        if (source == null) {
            BasicKeyByIndexReference.$$$reportNull$$$0(0);
        }
        if (meta == null) {
            BasicKeyByIndexReference.$$$reportNull$$$0(1);
        }
        if (assistant == null) {
            BasicKeyByIndexReference.$$$reportNull$$$0(2);
        }
        BasicElement basicElement = root = (base = BasicMetaUtils.getResolveBase(source, meta, assistant)) == null ? null : assistant.getRestrictedRoot(base, 1, meta.targets);
        if (root == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                BasicKeyByIndexReference.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.of((Object[])meta.targets).flatten(target -> {
            Family family;
            Family family2 = family = target.kindOf(BasicKey.class) ? (Family)BasicMetaUtils.getFamily(root, target) : null;
            if (family == null) {
                return JBIterable.empty();
            }
            return family.jbi().filter(o -> this.matches(source, meta, o));
        });
        if (jBIterable == null) {
            BasicKeyByIndexReference.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @Override
    public <S extends BasicElement, T extends BasicElement> boolean matches(@NotNull S source, @NotNull BasicMetaReferenceDesc<S, T> meta, @NotNull T target) {
        BasicKey key;
        BasicReferenceInfo<? extends BasicIndex> info;
        if (source == null) {
            BasicKeyByIndexReference.$$$reportNull$$$0(5);
        }
        if (meta == null) {
            BasicKeyByIndexReference.$$$reportNull$$$0(6);
        }
        if (target == null) {
            BasicKeyByIndexReference.$$$reportNull$$$0(7);
        }
        BasicReferenceInfo<? extends BasicIndex> basicReferenceInfo = info = (key = (BasicKey)ObjectUtils.tryCast(target, BasicKey.class)) == null ? null : key.getUnderlyingIndexRefInfo();
        if (info == null) {
            return false;
        }
        if (this.indexRef.isEquivalent(info.getReference())) {
            return true;
        }
        BasicIndex index = info.getTarget();
        if (index == null) {
            return false;
        }
        return info.with(this.indexRef).matches(index);
    }

    @Override
    public void exportProperties(@NotNull NameValueConsumer<? super String> consumer) {
        if (consumer == null) {
            BasicKeyByIndexReference.$$$reportNull$$$0(8);
        }
        this.indexRef.exportProperties(BasicRefImporter.wrap(consumer, "Index"));
    }

    @Nullable
    public static BasicKeyByIndexReference importProperties(@NotNull NameValueGetter<String> properties, @NotNull Function<? super NameValueGetter<String>, ? extends BasicReference> sub) {
        NameValueGetter<String> wrapped;
        if (properties == null) {
            BasicKeyByIndexReference.$$$reportNull$$$0(9);
        }
        if (sub == null) {
            BasicKeyByIndexReference.$$$reportNull$$$0(10);
        }
        return (wrapped = BasicRefImporter.wrap(properties, "Index")) == null ? null : BasicKeyByIndexReference.create((BasicReference)sub.fun(wrapped));
    }

    public String toString() {
        return "index=[" + String.valueOf(this.indexRef) + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assistant";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/references/BasicKeyByIndexReference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/references/BasicKeyByIndexReference";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "multiResolve";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "exportProperties";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "importProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

