/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.editor.additionalParams;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.spring.boot.run.SpringBootRunSharedBundle;
import com.intellij.spring.boot.run.editor.additionalParams.columns.SimplePropertyNameColumn;
import com.intellij.spring.boot.run.editor.additionalParams.columns.SimplePropertyValueColumn;
import com.intellij.spring.boot.run.editor.additionalParams.columns.SpringBootParameterToggleColumn;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.LanguageTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.TableView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class SimpleSpringBootAdditionalParamsTableView
extends TableView<SpringBootAdditionalParameter> {
    protected final Project myProject;
    protected final Disposable myParent;
    protected final ListTableModel<SpringBootAdditionalParameter> myAdditionalParamsModel;

    public SimpleSpringBootAdditionalParamsTableView(@NotNull Project project, @NotNull Disposable parent) {
        if (project == null) {
            SimpleSpringBootAdditionalParamsTableView.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            SimpleSpringBootAdditionalParamsTableView.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myParent = parent;
        this.myAdditionalParamsModel = new ListTableModel(new ColumnInfo[]{SimpleSpringBootAdditionalParamsTableView.getCheckBoxColumn(), this.getPropertyNameColumn(), this.getPropertyValueColumn()});
        this.setModelAndUpdateColumns(this.myAdditionalParamsModel);
        this.getTableHeader().setReorderingAllowed(false);
        TableUtil.setupCheckboxColumn((TableColumn)this.getColumnModel().getColumn(0), (int)this.getColumnModel().getColumnMargin());
        StatusText emptyText = this.getEmptyText();
        emptyText.setText(SpringBootRunSharedBundle.message("additional.params.table.empty.text", new Object[0]));
        emptyText.appendSecondaryText(SpringBootRunSharedBundle.message("additional.params.table.add", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleSpringBootAdditionalParamsTableView.this.addAdditionalParameter();
            }
        });
        ShortcutSet shortcutSet = CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.ADD);
        Shortcut shortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])shortcutSet.getShortcuts());
        if (shortcut != null) {
            emptyText.appendSecondaryText(" (" + KeymapUtil.getShortcutText((Shortcut)shortcut) + ")", StatusText.DEFAULT_ATTRIBUTES, null);
        }
        this.setShowGrid(false);
        this.setColumnSelectionAllowed(false);
        this.setRowHeight(new LanguageTextField().getPreferredSize().height * 2 + JBUIScale.scale((int)1));
        this.setVisibleRowCount(6);
        TableSpeedSearch.installOn((JTable)((Object)this));
    }

    @NotNull
    protected ColumnInfo<SpringBootAdditionalParameter, String> getPropertyValueColumn() {
        return new SimplePropertyValueColumn(this.myProject);
    }

    @NotNull
    protected ColumnInfo<SpringBootAdditionalParameter, String> getPropertyNameColumn() {
        return new SimplePropertyNameColumn(this.myProject);
    }

    @NotNull
    private static ColumnInfo<SpringBootAdditionalParameter, Boolean> getCheckBoxColumn() {
        return new SpringBootParameterToggleColumn();
    }

    public final List<SpringBootAdditionalParameter> getAdditionalParameters() {
        return this.myAdditionalParamsModel.getItems();
    }

    public final void setAdditionalParameters(List<SpringBootAdditionalParameter> parameters) {
        ArrayList<SpringBootAdditionalParameter> copy = new ArrayList<SpringBootAdditionalParameter>();
        for (SpringBootAdditionalParameter parameter : parameters) {
            copy.add(new SpringBootAdditionalParameter(parameter.getEnabled(), parameter.getName(), parameter.getValue()));
        }
        this.myAdditionalParamsModel.setItems(copy);
    }

    public void addAdditionalParameter() {
        this.stopEditing();
        this.myAdditionalParamsModel.addRow((Object)new SpringBootAdditionalParameter(true, "", ""));
        int index = this.myAdditionalParamsModel.getRowCount() - 1;
        this.setRowSelectionInterval(index, index);
        SwingUtilities.invokeLater(() -> {
            TableUtil.scrollSelectionToVisible((JTable)((Object)this));
            TableUtil.editCellAt((JTable)((Object)this), (int)index, (int)1);
        });
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (e.isAltDown() || e.isMetaDown() || e.getID() != 401) {
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        if (e.isControlDown()) {
            if (e.getKeyCode() == 10 && this.isEditing()) {
                this.stopEditing();
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }
        if (this.isEditing() && (e.getKeyCode() == 9 || (e.getKeyCode() == 38 || e.getKeyCode() == 40) && e.getModifiers() == 0)) {
            int row = this.getSelectedRow();
            int column = this.getSelectedColumn();
            boolean result = super.processKeyBinding(ks, e, condition, pressed);
            if (!(this.isEditing() || row == this.getSelectedRow() && column == this.getSelectedColumn())) {
                TableUtil.editCellAt((JTable)((Object)this), (int)this.getSelectedRow(), (int)this.getSelectedColumn());
                e.consume();
                return true;
            }
            return result;
        }
        if (e.getKeyCode() == 10 && e.getModifiers() == 0) {
            if (this.isEditing()) {
                this.stopEditing();
            } else {
                TableUtil.editCellAt((JTable)((Object)this), (int)this.getSelectedRow(), (int)this.getSelectedColumn());
            }
            e.consume();
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    @NotNull
    public static TableCellEditor createDefaultParameterEditor(Project project, String value) {
        final LanguageTextField field = new LanguageTextField((Language)PlainTextLanguage.INSTANCE, project, value);
        return new AbstractTableCellEditor(){

            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return field;
            }

            public Object getCellEditorValue() {
                return field.getText();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/run/editor/additionalParams/SimpleSpringBootAdditionalParamsTableView";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

