/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.json.JsonFileType;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.inspections.ES6ConvertRequireIntoImportQuickFix;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class ES6ConvertRequireIntoImportInspection
extends JSInspection {
    public static final String ES6_CONVERT_REQUIRE_INTO_IMPORT = "ES6ConvertRequireIntoImport";
    public boolean myScopeOption;

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6ConvertRequireIntoImportInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6ConvertRequireIntoImportInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            public void visitJSCallExpression(@NotNull JSCallExpression call) {
                boolean isBatch;
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!DialectDetector.hasFeature((PsiElement)call, (JSLanguageFeature)JSLanguageFeature.IMPORT_DECLARATIONS)) {
                    return;
                }
                if (!call.isRequireCall()) {
                    return;
                }
                JSExpression[] arguments = call.getArguments();
                boolean bl = isBatch = !holder.isOnTheFly();
                if (arguments.length == 1 && arguments[0] instanceof JSLiteralExpression && ((JSLiteralExpression)arguments[0]).isQuotedLiteral()) {
                    if (!ES6ConvertRequireIntoImportInspection.checkArgument(StringUtil.unquoteString((String)arguments[0].getText())) || isBatch && !ES6ConvertRequireIntoImportInspection.this.myScopeOption && !ES6ConvertRequireIntoImportInspection.checkElementIsOnTopLevel((JSElement)call)) {
                        return;
                    }
                    holder.registerProblem((PsiElement)call, JavaScriptBundle.message((String)"js.convert.require.into.es6.import.inspection.text", (Object[])new Object[0]), new LocalQuickFix[]{new ES6ConvertRequireIntoImportQuickFix(call)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportInspection$1", "visitJSCallExpression"));
            }
        };
    }

    private static boolean checkArgument(@NotNull String requireArgument) {
        String extension;
        if (requireArgument == null) {
            ES6ConvertRequireIntoImportInspection.$$$reportNull$$$0(2);
        }
        if ((extension = FileUtilRt.getExtension((String)ES6ConvertRequireIntoImportInspection.cutRelativePathStartAndForwardSlash(requireArgument))).isEmpty() || "node".equals(extension)) {
            return true;
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(extension);
        return fileType instanceof LanguageFileType && ((LanguageFileType)fileType).getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE) || JsonFileType.INSTANCE.equals(fileType);
    }

    @NotNull
    public static String cutRelativePathStartAndForwardSlash(@NotNull String argument) {
        if (argument == null) {
            ES6ConvertRequireIntoImportInspection.$$$reportNull$$$0(3);
        }
        String[] parts = argument.replace('\\', '/').split("/");
        StringBuilder sb = new StringBuilder();
        boolean started = false;
        for (String part : parts) {
            if (!(".".equals(part) || "..".equals(part) || part.isEmpty())) {
                if (!started) {
                    started = true;
                }
            } else if (!started) continue;
            if (!sb.isEmpty()) {
                sb.append("/");
            }
            sb.append(part);
        }
        String string = sb.toString();
        if (string == null) {
            ES6ConvertRequireIntoImportInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    static boolean checkElementIsOnTopLevel(@NotNull JSElement element2) {
        JSSourceElement immediateSourceElement;
        if (element2 == null) {
            ES6ConvertRequireIntoImportInspection.$$$reportNull$$$0(5);
        }
        if ((immediateSourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)element2, JSSourceElement.class)) == null) {
            return false;
        }
        if (immediateSourceElement.getParent() instanceof PsiFile && element2.getContainingFile().equals((Object)immediateSourceElement.getParent())) {
            return true;
        }
        return immediateSourceElement.getParent() instanceof JSEmbeddedContent;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myScopeOption", (String)JavaScriptBundle.message((String)"js.convert.require.into.es6.import.inspection.withConditional.option", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0]).description(JavaScriptBundle.message((String)"js.convert.require.into.es6.import.inspection.withConditional.option.description", (Object[])new Object[0]))});
        if (optPane == null) {
            ES6ConvertRequireIntoImportInspection.$$$reportNull$$$0(6);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requireArgument";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportInspection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "cutRelativePathStartAndForwardSlash";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkArgument";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cutRelativePathStartAndForwardSlash";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkElementIsOnTopLevel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6 -> new IllegalStateException(string);
        };
    }
}

