/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.codeInsight;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.navigation.actions.IdeKt;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.JSDisposable;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenInstalledPackageQuickFix
implements LocalQuickFix {
    private static final String VERSION_NAME = "version";
    private final VirtualFile myPackageDir;
    private final String myPackageName;

    public OpenInstalledPackageQuickFix(@NotNull VirtualFile packageDir, @NotNull String packageName) {
        if (packageDir == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(0);
        }
        if (packageName == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(1);
        }
        this.myPackageDir = packageDir;
        this.myPackageName = packageName;
    }

    @IntentionName
    @NotNull
    public String getName() {
        String string = JavaScriptBundle.message((String)"intention.name.navigate.to", (Object[])new Object[]{this.myPackageName + "/package.json"});
        if (string == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"intention.name.navigate.to", (Object[])new Object[]{"package.json"});
        if (string == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(4);
        }
        if (previewDescriptor == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(5);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(6);
        }
        return intentionPreviewInfo;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(7);
        }
        if (descriptor == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(8);
        }
        ReadAction.nonBlocking(() -> OpenInstalledPackageQuickFix.createPackageJsonNavigatable(project, this.myPackageDir, true)).expireWith((Disposable)JSDisposable.getInstance((Project)project)).finishOnUiThread(ModalityState.nonModal(), navigationRequest -> {
            if (navigationRequest != null) {
                IdeKt.navigateRequest((Project)project, (NavigationRequest)navigationRequest);
            }
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @Nullable
    public static NavigationRequest createPackageJsonNavigatable(@NotNull Project project, @NotNull VirtualFile packageDir, boolean navigateToVersion) {
        VirtualFile packageJson;
        if (project == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(9);
        }
        if (packageDir == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(10);
        }
        if ((packageJson = PackageJsonUtil.findChildPackageJsonFile(packageDir)) != null) {
            JsonLiteral version2;
            PsiFile file = PsiManager.getInstance((Project)project).findFile(packageJson);
            int offset = -1;
            if (navigateToVersion && file instanceof JsonFile && (version2 = OpenInstalledPackageQuickFix.findVersionValueElement((JsonFile)file)) != null) {
                offset = version2.getTextOffset() + 1;
            }
            return NavigationRequest.sourceNavigationRequest((Project)project, (VirtualFile)packageJson, (int)offset);
        }
        PsiDirectory dir = PsiManager.getInstance((Project)project).findDirectory(packageDir);
        if (dir != null) {
            return NavigationRequest.directoryNavigationRequest((PsiDirectory)dir);
        }
        return null;
    }

    @Nullable
    private static JsonLiteral findVersionValueElement(@NotNull JsonFile file) {
        if (file == null) {
            OpenInstalledPackageQuickFix.$$$reportNull$$$0(11);
        }
        for (JsonValue root : file.getAllTopLevelValues()) {
            JsonProperty version2;
            JsonObject rootObj = (JsonObject)ObjectUtils.tryCast((Object)root, JsonObject.class);
            if (rootObj == null || (version2 = rootObj.findProperty(VERSION_NAME)) == null) continue;
            return (JsonLiteral)ObjectUtils.tryCast((Object)version2.getValue(), JsonLiteral.class);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/OpenInstalledPackageQuickFix";
                break;
            }
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/OpenInstalledPackageQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createPackageJsonNavigatable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findVersionValueElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 6 -> new IllegalStateException(string);
        };
    }
}

