/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public final class NodeAsdfUtil {
    public static final String SHIMS = "shims";
    public static final String INSTALLS_NODEJS = "installs/nodejs";
    private static final String ASDF_DIR_SYSTEM_INDEPENDENT = NodeAsdfUtil.findAsdfDirSystemIndependentPath();
    private static final String SHIMS_DIR_SYSTEM_INDEPENDENT = StringUtil.trimEnd((String)ASDF_DIR_SYSTEM_INDEPENDENT, (char)'/') + "/shims/";

    private NodeAsdfUtil() {
    }

    @NotNull
    private static String findAsdfDirSystemIndependentPath() {
        String asdfDirPath = EnvironmentUtil.getValue((String)"ASDF_DIR");
        if (asdfDirPath != null && Path.of(asdfDirPath, new String[0]).isAbsolute()) {
            String string = FileUtil.toSystemIndependentName((String)asdfDirPath);
            if (string == null) {
                NodeAsdfUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = FileUtil.toSystemIndependentName((String)(SystemProperties.getUserHome() + "/.asdf"));
        if (string == null) {
            NodeAsdfUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String getAsdfDirSystemIndependentPath() {
        String string = ASDF_DIR_SYSTEM_INDEPENDENT;
        if (string == null) {
            NodeAsdfUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    static boolean isShimsNode(@NotNull NodeJsLocalInterpreter interpreter2) {
        String path2;
        if (interpreter2 == null) {
            NodeAsdfUtil.$$$reportNull$$$0(3);
        }
        if ((path2 = interpreter2.getInterpreterSystemIndependentPath()).startsWith(SHIMS_DIR_SYSTEM_INDEPENDENT)) {
            return !StringUtil.contains((CharSequence)path2, (int)SHIMS_DIR_SYSTEM_INDEPENDENT.length(), (int)path2.length(), (char)'/');
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/local/NodeAsdfUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "findAsdfDirSystemIndependentPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAsdfDirSystemIndependentPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/local/NodeAsdfUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isShimsNode";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }
}

