/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.js.graalvm.crypto.rsa;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/JoseDerUtils;", "", "<init>", "()V", "Companion", "intellij.httpClient.executor"})
public final class JoseDerUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final byte[] derToJose(@Nullable byte[] derSignature, int expectedLength) throws Exception {
        return Companion.derToJose(derSignature, expectedLength);
    }

    @JvmStatic
    @NotNull
    public static final byte[] joseToDer(@NotNull int[] rawJoseSignature) throws Exception {
        return Companion.joseToDer(rawJoseSignature);
    }

    @JvmStatic
    public static final int joseSelectionExpectedSection(int bits) {
        return Companion.joseSelectionExpectedSection(bits);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\bH\u0007J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/JoseDerUtils$Companion;", "", "<init>", "()V", "derToJose", "", "derSignature", "expectedLength", "", "joseToDer", "rawJoseSignature", "", "joseSelectionExpectedSection", "bits", "toUnsignedFixedLength", "value", "Ljava/math/BigInteger;", "length", "intellij.httpClient.executor"})
    @SourceDebugExtension(value={"SMAP\nRsaCryptoSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RsaCryptoSupport.kt\ncom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/JoseDerUtils$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,518:1\n11591#2:519\n11926#2,3:520\n*S KotlinDebug\n*F\n+ 1 RsaCryptoSupport.kt\ncom/intellij/httpClient/http/request/run/js/graalvm/crypto/rsa/JoseDerUtils$Companion\n*L\n44#1:519\n44#1:520,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final byte[] derToJose(@Nullable byte[] derSignature, int expectedLength) throws Exception {
            ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray((byte[])derSignature);
            Intrinsics.checkNotNull((Object)aSN1Primitive, (String)"null cannot be cast to non-null type org.bouncycastle.asn1.ASN1Sequence");
            ASN1Sequence seq = (ASN1Sequence)aSN1Primitive;
            ASN1Encodable aSN1Encodable = seq.getObjectAt(0);
            Object object = aSN1Encodable instanceof ASN1Integer ? (ASN1Integer)aSN1Encodable : null;
            if (object == null || (object = object.getValue()) == null) {
                throw new IllegalArgumentException("Invalid DER signature");
            }
            Object r = object;
            ASN1Encodable aSN1Encodable2 = seq.getObjectAt(1);
            Object object2 = aSN1Encodable2 instanceof ASN1Integer ? (ASN1Integer)aSN1Encodable2 : null;
            if (object2 == null || (object2 = object2.getValue()) == null) {
                throw new IllegalArgumentException("Invalid DER signature");
            }
            Object s = object2;
            byte[] rBytes = this.toUnsignedFixedLength((BigInteger)r, expectedLength / 2);
            byte[] sBytes = this.toUnsignedFixedLength((BigInteger)s, expectedLength / 2);
            byte[] jose = new byte[expectedLength];
            System.arraycopy(rBytes, 0, jose, 0, rBytes.length);
            System.arraycopy(sBytes, 0, jose, rBytes.length, sBytes.length);
            return jose;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final byte[] joseToDer(@NotNull int[] rawJoseSignature) throws Exception {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)rawJoseSignature, (String)"rawJoseSignature");
            int[] $this$map$iv = rawJoseSignature;
            boolean $i$f$map = false;
            int[] nArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var11_12 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((byte)it);
            }
            byte[] joseSignature = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
            int length2 = joseSignature.length / 2;
            BigInteger r = new BigInteger(1, ArraysKt.copyOfRange((byte[])joseSignature, (int)0, (int)length2));
            BigInteger s = new BigInteger(1, ArraysKt.copyOfRange((byte[])joseSignature, (int)length2, (int)joseSignature.length));
            ASN1EncodableVector vec = new ASN1EncodableVector();
            vec.add((ASN1Encodable)new ASN1Integer(r));
            vec.add((ASN1Encodable)new ASN1Integer(s));
            byte[] byArray = new DERSequence(vec).getEncoded("DER");
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
            return byArray;
        }

        @JvmStatic
        public final int joseSelectionExpectedSection(int bits) {
            return switch (bits) {
                case 256 -> 64;
                case 384 -> 96;
                case 512 -> 132;
                default -> throw new IllegalArgumentException("JOSE: conversion invalid signature length: " + bits + " bits");
            };
        }

        private final byte[] toUnsignedFixedLength(BigInteger value2, int length2) {
            byte[] raw = value2.toByteArray();
            if (raw.length == length2) {
                Intrinsics.checkNotNull((Object)raw);
                return raw;
            }
            if (raw.length == length2 + 1 && raw[0] == 0) {
                byte[] byArray = Arrays.copyOfRange(raw, 1, raw.length);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOfRange(...)");
                return byArray;
            }
            byte[] result2 = new byte[length2];
            System.arraycopy(raw, Math.max(0, raw.length - length2), result2, Math.max(0, length2 - raw.length), Math.min(raw.length, length2));
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

