/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.ssl;

import com.intellij.httpClient.execution.HttpClientExecutorBundle;
import com.intellij.httpClient.execution.ssl.HttpRequestSslConfigurationException;
import com.intellij.httpClient.execution.ssl.PemHelper;
import com.intellij.httpClient.execution.ssl.SslConfigurationContext;
import com.intellij.httpClient.execution.ssl.SslErrorDescriptor;
import com.intellij.httpClient.execution.ssl.SslFilesFormatGuessStrategy;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Path;
import java.security.PrivateKey;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH$J)\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0012"}, d2={"Lcom/intellij/httpClient/execution/ssl/PrivateKeyFormat;", "", "<init>", "(Ljava/lang/String;I)V", "PEM", "DER", "readKeyInfo", "Lorg/bouncycastle/asn1/pkcs/PrivateKeyInfo;", "path", "Ljava/nio/file/Path;", "passphrase", "", "readKey", "Ljava/security/PrivateKey;", "context", "Lcom/intellij/httpClient/execution/ssl/SslConfigurationContext;", "readKey$intellij_httpClient_executor", "Companion", "intellij.httpClient.executor"})
@SourceDebugExtension(value={"SMAP\nsslFormats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 sslFormats.kt\ncom/intellij/httpClient/execution/ssl/PrivateKeyFormat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 sslErrors.kt\ncom/intellij/httpClient/execution/ssl/SslErrorsKt\n*L\n1#1,160:1\n1#2:161\n24#3,4:162\n*S KotlinDebug\n*F\n+ 1 sslFormats.kt\ncom/intellij/httpClient/execution/ssl/PrivateKeyFormat\n*L\n142#1:162,4\n*E\n"})
public abstract class PrivateKeyFormat
extends Enum<PrivateKeyFormat> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final String guessExplanation;
    public static final /* enum */ PrivateKeyFormat PEM;
    public static final /* enum */ PrivateKeyFormat DER;
    private static final /* synthetic */ PrivateKeyFormat[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private PrivateKeyFormat() {
    }

    @NotNull
    protected abstract PrivateKeyInfo readKeyInfo(@NotNull Path var1, @Nullable String var2) throws IOException;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final PrivateKey readKey$intellij_httpClient_executor(@NotNull Path path, @Nullable String passphrase, @NotNull SslConfigurationContext context2) throws HttpRequestSslConfigurationException {
        void $this$getOrRethrowSslException$iv;
        Object object;
        Object object2;
        Object $i$a$-runCatching-PrivateKeyFormat$readKey$22;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        try {
            boolean $i$a$-runCatching-PrivateKeyFormat$readKey$22 = false;
            $i$a$-runCatching-PrivateKeyFormat$readKey$22 = Result.constructor-impl((Object)this.readKeyInfo(path, passphrase));
        }
        catch (Throwable throwable) {
            $i$a$-runCatching-PrivateKeyFormat$readKey$22 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        if (Result.isSuccess-impl((Object)$i$a$-runCatching-PrivateKeyFormat$readKey$22)) {
            Object object3 = $i$a$-runCatching-PrivateKeyFormat$readKey$22;
            try {
                object2 = object3;
                PrivateKeyInfo it = (PrivateKeyInfo)object2;
                boolean bl = false;
                object2 = Result.constructor-impl((Object)new JcaPEMKeyConverter().getPrivateKey(it));
            }
            catch (Throwable it) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it));
            }
            object = object2;
        } else {
            object = Result.constructor-impl((Object)$i$a$-runCatching-PrivateKeyFormat$readKey$22);
        }
        $i$a$-runCatching-PrivateKeyFormat$readKey$22 = object;
        boolean $i$f$getOrRethrowSslException = false;
        object2 = $this$getOrRethrowSslException$iv;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            HttpRequestSslConfigurationException httpRequestSslConfigurationException;
            Throwable it$iv = throwable;
            boolean bl = false;
            if (it$iv instanceof HttpRequestSslConfigurationException) {
                httpRequestSslConfigurationException = (HttpRequestSslConfigurationException)it$iv;
            } else {
                Throwable it = it$iv;
                boolean bl2 = false;
                Object[] objectArray = new Object[]{it.getLocalizedMessage()};
                Throwable throwable2 = it$iv;
                String string = context2.getErrorMessage(SslErrorDescriptor.KEY, HttpClientExecutorBundle.message("http.request.ssl.cannot.read.key.error", objectArray));
                httpRequestSslConfigurationException = new HttpRequestSslConfigurationException(string, throwable2);
            }
            HttpRequestSslConfigurationException exception$iv = httpRequestSslConfigurationException;
            throw exception$iv;
        }
        return (PrivateKey)object2;
    }

    public static PrivateKeyFormat[] values() {
        return (PrivateKeyFormat[])$VALUES.clone();
    }

    public static PrivateKeyFormat valueOf(String value2) {
        return Enum.valueOf(PrivateKeyFormat.class, value2);
    }

    @NotNull
    public static EnumEntries<PrivateKeyFormat> getEntries() {
        return $ENTRIES;
    }

    @JvmStatic
    @Nullable
    public static PrivateKeyFormat guessFormat(@NotNull Path path) {
        return Companion.guessFormat(path);
    }

    public /* synthetic */ PrivateKeyFormat(String $enum$name, int $enum$ordinal, DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        PEM = new PEM("PEM", 0);
        DER = new DER("DER", 1);
        $VALUES = privateKeyFormatArray = new PrivateKeyFormat[]{PrivateKeyFormat.PEM, PrivateKeyFormat.DER};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        guessExplanation = ".pem, .key -> PEM; .der -> DER";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0017R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/httpClient/execution/ssl/PrivateKeyFormat$Companion;", "Lcom/intellij/httpClient/execution/ssl/SslFilesFormatGuessStrategy;", "Lcom/intellij/httpClient/execution/ssl/PrivateKeyFormat;", "<init>", "()V", "guessFormat", "path", "Ljava/nio/file/Path;", "guessExplanation", "", "getGuessExplanation", "()Ljava/lang/String;", "intellij.httpClient.executor"})
    public static final class Companion
    implements SslFilesFormatGuessStrategy<PrivateKeyFormat> {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @JvmStatic
        @Nullable
        public PrivateKeyFormat guessFormat(@NotNull Path path) {
            block6: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                var2_2 = PathsKt.getExtension((Path)path);
                switch (var2_2.hashCode()) {
                    case 99345: {
                        if (var2_2.equals("der")) break;
                        ** break;
                    }
                    case 110872: {
                        if (!var2_2.equals("pem")) {
                            ** break;
                        }
                        ** GOTO lbl13
                    }
                    case 106079: {
                        if (!var2_2.equals("key")) ** break;
lbl13:
                        // 2 sources

                        v0 = PrivateKeyFormat.PEM;
                        break block6;
                    }
                }
                v0 = PrivateKeyFormat.DER;
                break block6;
lbl17:
                // 4 sources

                v0 = null;
            }
            return v0;
        }

        @Override
        @NotNull
        public String getGuessExplanation() {
            return guessExplanation;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014\u00a8\u0006\b"}, d2={"com/intellij/httpClient/execution/ssl/PrivateKeyFormat.DER", "Lcom/intellij/httpClient/execution/ssl/PrivateKeyFormat;", "readKeyInfo", "Lorg/bouncycastle/asn1/pkcs/PrivateKeyInfo;", "path", "Ljava/nio/file/Path;", "passphrase", "", "intellij.httpClient.executor"})
    static final class DER
    extends PrivateKeyFormat {
        /*
         * WARNING - void declaration
         */
        DER() {
            void var1_1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected PrivateKeyInfo readKeyInfo(@NotNull Path path, @Nullable String passphrase) throws IOException {
            PrivateKeyInfo privateKeyInfo;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Closeable closeable = new FileInputStream(path.toFile());
            Throwable throwable = null;
            try {
                FileInputStream stream2 = (FileInputStream)closeable;
                boolean bl = false;
                AsymmetricKeyParameter asymmetricKeyParameter = PrivateKeyFactory.createKey((InputStream)stream2);
                PrivateKeyInfo privateKeyInfo2 = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)asymmetricKeyParameter);
                privateKeyInfo = privateKeyInfo2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Intrinsics.checkNotNullExpressionValue((Object)privateKeyInfo, (String)"use(...)");
            return privateKeyInfo;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0014\u00a8\u0006\b"}, d2={"com/intellij/httpClient/execution/ssl/PrivateKeyFormat.PEM", "Lcom/intellij/httpClient/execution/ssl/PrivateKeyFormat;", "readKeyInfo", "Lorg/bouncycastle/asn1/pkcs/PrivateKeyInfo;", "path", "Ljava/nio/file/Path;", "passphrase", "", "intellij.httpClient.executor"})
    @SourceDebugExtension(value={"SMAP\nsslFormats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 sslFormats.kt\ncom/intellij/httpClient/execution/ssl/PrivateKeyFormat$PEM\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
    static final class PEM
    extends PrivateKeyFormat {
        /*
         * WARNING - void declaration
         */
        PEM() {
            void var1_1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected PrivateKeyInfo readKeyInfo(@NotNull Path path, @Nullable String passphrase) throws IOException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Closeable closeable = (Closeable)new PEMParser((Reader)new FileReader(path.toFile()));
            Throwable throwable = null;
            try {
                PEMParser pemParser = (PEMParser)closeable;
                boolean bl = false;
                Object keyObject = pemParser.readObject();
                if (!PemHelper.INSTANCE.isKey(keyObject)) {
                    boolean bl2 = false;
                    String string = HttpClientExecutorBundle.message("http.request.ssl.no.key.in.file.error", new Object[0]);
                    throw new IllegalStateException(string.toString());
                }
                PrivateKeyInfo privateKeyInfo = PemHelper.INSTANCE.readKey(keyObject, passphrase);
                return privateKeyInfo;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
    }
}

