/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.core.claude.listeners.server;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.ProvenanceEntry;
import com.intellij.code.provenance.core.claude.listeners.server.DiffFileRequest;
import com.intellij.code.provenance.core.events.listeners.utils.Listener_toolsKt;
import com.intellij.code.provenance.core.events.utils.Path_utilsKt;
import com.intellij.code.provenance.core.events.utils.UtilsKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/code/provenance/core/claude/listeners/server/DiffHttpRequestProjectHandler;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "handle", "", "request", "Lcom/intellij/code/provenance/core/claude/listeners/server/DiffFileRequest;", "notifyDocumentChange", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.code.provenance.core.claude"})
@SourceDebugExtension(value={"SMAP\nDiffHttpRequestProjectHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiffHttpRequestProjectHandler.kt\ncom/intellij/code/provenance/core/claude/listeners/server/DiffHttpRequestProjectHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,51:1\n1#2:52\n13#3:53\n*S KotlinDebug\n*F\n+ 1 DiffHttpRequestProjectHandler.kt\ncom/intellij/code/provenance/core/claude/listeners/server/DiffHttpRequestProjectHandler\n*L\n21#1:53\n*E\n"})
public final class DiffHttpRequestProjectHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public DiffHttpRequestProjectHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean handle(@NotNull DiffFileRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        VirtualFile virtualFile = Path_utilsKt.findVirtualFileByPath((Project)this.project, (String)request.getFilePath(), (boolean)true);
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile virtualFile3;
            VirtualFile it = virtualFile3 = virtualFile;
            boolean bl = false;
            Object object = ReadAction.compute(() -> DiffHttpRequestProjectHandler.handle$lambda$0$0(this, it));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
            Object object2 = virtualFile2 = (Boolean)object != false ? virtualFile3 : null;
            if (virtualFile2 != null) {
                VirtualFile file = virtualFile2;
                boolean bl2 = false;
                this.notifyDocumentChange(file, request);
                return true;
            }
        }
        return false;
    }

    private final void notifyDocumentChange(VirtualFile file, DiffFileRequest request) {
        Long l;
        CharSequence charSequence = (CharSequence)ActionsKt.runReadAction(() -> DiffHttpRequestProjectHandler.notifyDocumentChange$lambda$0(file, this));
        if (charSequence != null) {
            CharSequence it = charSequence;
            boolean bl = false;
            l = UtilsKt.contentHash((CharSequence)it);
        } else {
            l = null;
        }
        Long newContentHash = l;
        long oldContentHash = UtilsKt.getEmptyHash();
        ProvenanceEntry.MetadataEntryOfDocumentChange documentChange = Listener_toolsKt.createToolDocumentChange((DocumentChangesKind)DocumentChangesKind.CLAUDE_CODE_GENERATION, (VirtualFile)file, (Long)oldContentHash, (Long)newContentHash, (long)request.getTimestamp(), (long)0L);
        Listener_toolsKt.saveToolChange((Project)this.project, (ProvenanceEntry.MetadataEntryOfDocumentChange)documentChange);
        LOG.debug("DocumentChange event dispatched to ProvenanceStorage for file: " + request.getFilePath());
    }

    private static final Boolean handle$lambda$0$0(DiffHttpRequestProjectHandler this$0, VirtualFile $it) {
        return ProjectFileIndex.getInstance((Project)this$0.project).isInContent($it);
    }

    private static final CharSequence notifyDocumentChange$lambda$0(VirtualFile $file, DiffHttpRequestProjectHandler this$0) {
        return UtilsKt.decodeCurrentContent((VirtualFile)$file, (Project)this$0.project);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DiffHttpRequestProjectHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/code/provenance/core/claude/listeners/server/DiffHttpRequestProjectHandler$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/intellij/code/provenance/core/claude/listeners/server/DiffHttpRequestProjectHandler;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.code.provenance.core.claude"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DiffHttpRequestProjectHandler getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(DiffHttpRequestProjectHandler.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (DiffHttpRequestProjectHandler)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

