/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.psi;

import com.intellij.database.dialects.oracle.types.OraTypeSystem;
import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlReferenceTypeElementImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraReferenceTypeElementImpl
extends SqlReferenceTypeElementImpl {
    public OraReferenceTypeElementImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            OraReferenceTypeElementImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @NotNull
    public DataType parseDataType() {
        SqlReferenceExpression referenceExpression = this.getReferenceExpression();
        if (referenceExpression == null) {
            DataType dataType = super.parseDataType();
            if (dataType == null) {
                OraReferenceTypeElementImpl.$$$reportNull$$$0(1);
            }
            return dataType;
        }
        DataType dasType = SqlImplUtil.getNormalizedDataType((SqlReferenceExpression)referenceExpression);
        PsiElement suffixToken = this.getSuffixToken();
        if (suffixToken != null) {
            DataType dataType = DataTypeFactory.withSuffix((DataType)dasType, (String)("%" + StringUtil.toUpperCase((String)suffixToken.getText())));
            if (dataType == null) {
                OraReferenceTypeElementImpl.$$$reportNull$$$0(2);
            }
            return dataType;
        }
        DataType dataType = dasType;
        if (dataType == null) {
            OraReferenceTypeElementImpl.$$$reportNull$$$0(3);
        }
        return dataType;
    }

    @Nullable
    public IElementType getSuffixTokenType() {
        IElementType lastType = PsiUtilCore.getElementType((PsiElement)this.getLastChild());
        return lastType == OraTypes.ORA_TYPE || lastType == OraTypes.ORA_ROWTYPE ? lastType : null;
    }

    @Nullable
    public PsiElement getSuffixToken() {
        return this.getSuffixTokenType() != null ? this.getLastChild() : null;
    }

    @NotNull
    protected DasType computeDasType() {
        String name2;
        DasType dasType;
        SqlReferenceExpression referenceExpression = this.getReferenceExpression();
        if (referenceExpression != null && (dasType = OraTypeSystem.predefinedTypes.get(StringUtil.toUpperCase((String)(name2 = referenceExpression.getName())))) instanceof DasBuiltinType) {
            DasBuiltinType builtinType = (DasBuiltinType)dasType;
            if (!builtinType.getTypeClass().getName().equals(name2)) {
                dasType = DasTypeUtilsKt.withName((DasBuiltinType)builtinType, (String)name2);
            }
            DasType dasType2 = dasType;
            if (dasType2 == null) {
                OraReferenceTypeElementImpl.$$$reportNull$$$0(4);
            }
            return dasType2;
        }
        DasType dasType3 = super.computeDasType();
        if (dasType3 == null) {
            OraReferenceTypeElementImpl.$$$reportNull$$$0(5);
        }
        return dasType3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/oracle/psi/OraReferenceTypeElementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/oracle/psi/OraReferenceTypeElementImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDataType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDasType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

