/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.dialog;

import com.google.common.base.Strings;
import com.intellij.jpa.jpb.model.backend.ds.DataSourceLoader;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.help.JpaHelpConstants;
import com.intellij.jpa.jpb.model.model.CustomDataStore;
import com.intellij.jpa.jpb.model.ui.StudioMigPanel;
import com.intellij.jpa.jpb.model.ui.component.DbDriverProblemPanel;
import com.intellij.jpa.jpb.model.ui.component.DbPropertiesEditor;
import com.intellij.jpa.jpb.model.ui.dialog.HDialogWrapper;
import com.intellij.jpa.jpb.model.ui.settings.DatabaseDriversConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Objects;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbConnectionEditorDialog
extends HDialogWrapper {
    private final CustomDataStore dataStore;
    private final DbPropertiesEditor dbComponents;
    private JTextField storeNameField;
    private boolean storeNameChanged;

    public DbConnectionEditorDialog(@NotNull Project project) {
        if (project == null) {
            DbConnectionEditorDialog.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    public DbConnectionEditorDialog(@NotNull Project project, @Nullable CustomDataStore dataStore) {
        if (project == null) {
            DbConnectionEditorDialog.$$$reportNull$$$0(1);
        }
        super(project);
        this.dataStore = dataStore == null ? new CustomDataStore(project, DbType.POSTGRES, UUID.randomUUID().toString()) : dataStore;
        this.dbComponents = new DbPropertiesEditor(project);
        this.dbComponents.addDbTypeListener(dbType -> {
            DbDriverProblemPanel dbDriverProblemPanel = this.dbComponents.dbDriverProblemPanel;
            int extraHeight = dbDriverProblemPanel.getHeight();
            dbDriverProblemPanel.updatePanelState((DbType)dbType);
            if (!dbDriverProblemPanel.isVisible()) {
                this.changeDialogHeight(extraHeight);
            }
        });
        this.init();
    }

    @Override
    @Nullable
    protected String getConfigurableName() {
        return DatabaseDriversConfigurable.Companion.getDISPLAY_NAME();
    }

    private JPanel getRdbmsLayout() {
        StudioMigPanel rdbmsLayout = new StudioMigPanel(new LC().insets("0px").hideMode(3));
        JPanel dbComponentsPanel = this.dbComponents.getMainPanel();
        dbComponentsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)JpaModelBundle.message("DataSourceEditor.database.properties", new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)JBUI.scale((int)4))));
        ((Container)((Object)rdbmsLayout)).add(dbComponentsPanel, new CC().spanX().growX().width("100%"));
        return rdbmsLayout;
    }

    @Override
    protected void init() {
        super.init();
        this.setValues();
        this.setTitle(JpaModelBundle.message("DataSourceEditor.caption", new Object[0]));
    }

    @Nullable
    protected JComponent createCenterPanel() {
        StudioMigPanel centerPanel = new StudioMigPanel();
        ((JComponent)((Object)centerPanel)).setPreferredSize(new Dimension(600, -1));
        JBLabel storeNameLab = new JBLabel(JpaModelBundle.message("DataStoreEditor.name", new Object[0]));
        ((Container)((Object)centerPanel)).add((Component)storeNameLab, new CC().gapLeft("3px"));
        this.storeNameField = new JBTextField();
        this.storeNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                DbConnectionEditorDialog.this.storeNameChanged = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/jpa/jpb/model/ui/dialog/DbConnectionEditorDialog$1", "textChanged"));
            }
        });
        this.storeNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                DbConnectionEditorDialog.this.updateDbName();
            }
        });
        this.storeNameField.addActionListener(e -> this.updateDbName());
        ((Container)((Object)centerPanel)).add(this.storeNameField, new CC().growX().width("100%").wrap());
        JPanel rdbmsLayout = this.getRdbmsLayout();
        ((Container)((Object)centerPanel)).add(rdbmsLayout, new CC().spanX().growX().width("100%"));
        return centerPanel;
    }

    private void updateDbName() {
        String name = this.storeNameField.getText();
        if (this.storeNameChanged && this.dbComponents != null && Strings.isNullOrEmpty((String)this.dbComponents.getDbName())) {
            this.dbComponents.setDbName(name);
        }
        this.storeNameChanged = false;
    }

    private void setValues() {
        this.storeNameField.setText(this.dataStore.getName());
        this.dbComponents.setValues(this.dataStore.getDbProperties());
    }

    @Override
    protected void doOKAction() {
        if (!this.getOKAction().isEnabled()) {
            return;
        }
        this.dataStore.setName(this.storeNameField.getText());
        this.updateDbName();
        this.dataStore.setDbProperties(this.dbComponents.createDbProperties());
        this.close(0);
    }

    @NotNull
    public CustomDataStore getDataStore() {
        CustomDataStore customDataStore = this.dataStore;
        if (customDataStore == null) {
            DbConnectionEditorDialog.$$$reportNull$$$0(2);
        }
        return customDataStore;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String dataStoreName = this.storeNameField.getText();
        if (Strings.isNullOrEmpty((String)dataStoreName)) {
            return new ValidationInfo(JpaModelBundle.message("DataStoreEditor.nameEmpty", new Object[0]), (JComponent)this.storeNameField);
        }
        boolean duplicateDbConnectionName = ContainerUtil.or(DataSourceLoader.getInstance(this.project).getCustomDataStores(), ds -> Objects.equals(ds.getName(), dataStoreName) && (!(ds instanceof CustomDataStore) || !Objects.equals(((CustomDataStore)ds).getId(), this.dataStore.getId())));
        if (duplicateDbConnectionName) {
            return new ValidationInfo(JpaModelBundle.message("duplicate.db.connection.name", dataStoreName), (JComponent)this.storeNameField);
        }
        return this.dbComponents.validate();
    }

    @NonNls
    @Nullable
    protected String getHelpId() {
        return JpaHelpConstants.PluginDoc.DatabaseConnection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/ui/dialog/DbConnectionEditorDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/ui/dialog/DbConnectionEditorDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataStore";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

