/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.bistro.corr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.GgplotKt;
import org.jetbrains.letsPlot.GgsizeKt;
import org.jetbrains.letsPlot.bistro.corr.CorrPlot;
import org.jetbrains.letsPlot.bistro.corr.CorrUtil;
import org.jetbrains.letsPlot.bistro.corr.CorrVar;
import org.jetbrains.letsPlot.bistro.corr.LayerParams;
import org.jetbrains.letsPlot.bistro.corr.Method;
import org.jetbrains.letsPlot.bistro.corr.OptionsConfigurator;
import org.jetbrains.letsPlot.coord.CoordKt;
import org.jetbrains.letsPlot.geom.geomPoint;
import org.jetbrains.letsPlot.geom.geomText;
import org.jetbrains.letsPlot.geom.geomTile;
import org.jetbrains.letsPlot.intern.Plot;
import org.jetbrains.letsPlot.intern.Scale;
import org.jetbrains.letsPlot.intern.ToSpecConvertersKt;
import org.jetbrains.letsPlot.intern.layer.SamplingOptions;
import org.jetbrains.letsPlot.label.GgtitleKt;
import org.jetbrains.letsPlot.sampling.SamplingKt;
import org.jetbrains.letsPlot.scale.ColorBrewerKt;
import org.jetbrains.letsPlot.scale.ColorContinuousKt;
import org.jetbrains.letsPlot.scale.IdentityKt;
import org.jetbrains.letsPlot.scale.XYDiscreteKt;
import org.jetbrains.letsPlot.themes.ThemeKt;
import org.jetbrains.letsPlot.themes.theme;
import org.jetbrains.letsPlot.tooltips.layerTooltips;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0019\u0018\u0000 .2\u00020\u0001:\u0001.BK\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fBs\b\u0002\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0000H\u0002J\u0018\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J;\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u0000J\u001e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0005J\u0006\u0010#\u001a\u00020\u0000J\u0006\u0010$\u001a\u00020\u0000J\u0006\u0010%\u001a\u00020\u0000J\u0006\u0010&\u001a\u00020\u0000J\u0006\u0010'\u001a\u00020\u0000J\u0006\u0010(\u001a\u00020\u0000J\u0006\u0010)\u001a\u00020\u0000J\u0006\u0010*\u001a\u00020\u0000J#\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020\u0005H\u0002J#\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010+R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/letsPlot/bistro/corr/CorrPlot;", "", "data", "", "title", "", "showLegend", "", "flip", "threshold", "", "adjustSize", "(Ljava/util/Map;Ljava/lang/String;ZZDD)V", "tiles", "Lorg/jetbrains/letsPlot/bistro/corr/LayerParams;", "points", "labels", "colorScale", "Lorg/jetbrains/letsPlot/intern/Scale;", "fillScale", "(Ljava/util/Map;Ljava/lang/String;ZZDDLorg/jetbrains/letsPlot/bistro/corr/LayerParams;Lorg/jetbrains/letsPlot/bistro/corr/LayerParams;Lorg/jetbrains/letsPlot/bistro/corr/LayerParams;Lorg/jetbrains/letsPlot/intern/Scale;Lorg/jetbrains/letsPlot/intern/Scale;)V", "build", "Lorg/jetbrains/letsPlot/intern/Plot;", "copy", "copyUpdateColors", "type", "diag", "mapSize", "color", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/String;)Lorg/jetbrains/letsPlot/bistro/corr/CorrPlot;", "paletteBrBG", "paletteGradient", "low", "mid", "high", "palettePRGn", "palettePiYG", "palettePuOr", "paletteRdBu", "paletteRdGy", "paletteRdYlBu", "paletteRdYlGn", "paletteSpectral", "(Ljava/lang/String;Ljava/lang/Boolean;)Lorg/jetbrains/letsPlot/bistro/corr/CorrPlot;", "setBrewerPalette", "palette", "Companion", "plot-api"})
@SourceDebugExtension(value={"SMAP\nCorrPlot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CorrPlot.kt\norg/jetbrains/letsPlot/bistro/corr/CorrPlot\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,537:1\n1549#2:538\n1620#2,3:539\n1549#2:542\n1620#2,3:543\n766#2:546\n857#2,2:547\n766#2:550\n857#2,2:551\n766#2:553\n857#2,2:554\n1#3:549\n*S KotlinDebug\n*F\n+ 1 CorrPlot.kt\norg/jetbrains/letsPlot/bistro/corr/CorrPlot\n*L\n248#1:538\n248#1:539,3\n259#1:542\n259#1:543,3\n260#1:546\n260#1:547,2\n356#1:550\n356#1:551,2\n357#1:553\n357#1:554,2\n*E\n"})
public final class CorrPlot {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<?, ?> data;
    @Nullable
    private final String title;
    private final boolean showLegend;
    private final boolean flip;
    private final double threshold;
    private final double adjustSize;
    @NotNull
    private final LayerParams tiles;
    @NotNull
    private final LayerParams points;
    @NotNull
    private final LayerParams labels;
    @NotNull
    private final Scale colorScale;
    @NotNull
    private final Scale fillScale;
    @NotNull
    private static final String VALUE_FORMAT = ".2f";
    @NotNull
    private static final String LEGEND_NAME = "";
    @NotNull
    private static final List<Double> SCALE_BREAKS;
    @NotNull
    private static final List<String> SCALE_LABELS;
    @NotNull
    private static final Pair<Double, Double> SCALE_LIMITS;
    private static final double DEF_THRESHOLD = 0.0;
    @NotNull
    private static final String DEF_LOW_COLOR = "#B3412C";
    @NotNull
    private static final String DEF_MID_COLOR = "#EDEDED";
    @NotNull
    private static final String DEF_HIGH_COLOR = "#326C81";
    private static final int COLUMN_WIDTH = 40;
    private static final int MIN_PLOT_WIDTH = 150;
    private static final int MAX_PLOT_WIDTH = 700;

    private CorrPlot(Map<?, ?> data, String title, boolean showLegend, boolean flip, double threshold, double adjustSize, LayerParams tiles, LayerParams points2, LayerParams labels, Scale colorScale, Scale fillScale) {
        this.data = data;
        this.title = title;
        this.showLegend = showLegend;
        this.flip = flip;
        this.threshold = threshold;
        this.adjustSize = adjustSize;
        this.tiles = tiles;
        this.points = points2;
        this.labels = labels;
        this.colorScale = colorScale;
        this.fillScale = fillScale;
    }

    /* synthetic */ CorrPlot(Map map2, String string, boolean bl, boolean bl2, double d, double d2, LayerParams layerParams, LayerParams layerParams2, LayerParams layerParams3, Scale scale2, Scale scale3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            d = 0.0;
        }
        if ((n & 0x20) != 0) {
            d2 = 1.0;
        }
        this(map2, string, bl, bl2, d, d2, layerParams, layerParams2, layerParams3, scale2, scale3);
    }

    public CorrPlot(@NotNull Map<?, ?> data, @Nullable String title, boolean showLegend, boolean flip, double threshold, double adjustSize) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this(data, title, showLegend, flip, threshold, adjustSize, new LayerParams(), new LayerParams(), new LayerParams(), CorrPlot.Companion.colorGradient(DEF_LOW_COLOR, DEF_MID_COLOR, DEF_HIGH_COLOR), CorrPlot.Companion.fillGradient(DEF_LOW_COLOR, DEF_MID_COLOR, DEF_HIGH_COLOR));
    }

    public /* synthetic */ CorrPlot(Map map2, String string, boolean bl, boolean bl2, double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        if ((n & 0x10) != 0) {
            d = 0.0;
        }
        if ((n & 0x20) != 0) {
            d2 = 1.0;
        }
        this(map2, string, bl, bl2, d, d2);
    }

    private final CorrPlot copy() {
        return new CorrPlot(this.data, this.title, this.showLegend, this.flip, this.threshold, this.adjustSize, this.tiles.copy(), this.points.copy(), this.labels.copy(), this.colorScale, this.fillScale);
    }

    private final CorrPlot copyUpdateColors(Scale colorScale, Scale fillScale) {
        return new CorrPlot(this.data, this.title, this.showLegend, this.flip, this.threshold, this.adjustSize, this.tiles.copy(), this.points.copy(), this.labels.copy(), colorScale, fillScale);
    }

    @NotNull
    public final CorrPlot tiles(@Nullable String type, @Nullable Boolean diag) {
        CorrPlot corrPlot;
        CorrPlot.Companion.checkTypeArg(type);
        CorrPlot $this$tiles_u24lambda_u240 = corrPlot = this.copy();
        boolean bl = false;
        $this$tiles_u24lambda_u240.tiles.setType(type);
        $this$tiles_u24lambda_u240.tiles.setDiag(diag);
        return corrPlot;
    }

    public static /* synthetic */ CorrPlot tiles$default(CorrPlot corrPlot, String string, Boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = null;
        }
        return corrPlot.tiles(string, bl);
    }

    @NotNull
    public final CorrPlot points(@Nullable String type, @Nullable Boolean diag) {
        CorrPlot corrPlot;
        CorrPlot.Companion.checkTypeArg(type);
        CorrPlot $this$points_u24lambda_u241 = corrPlot = this.copy();
        boolean bl = false;
        $this$points_u24lambda_u241.points.setType(type);
        $this$points_u24lambda_u241.points.setDiag(diag);
        return corrPlot;
    }

    public static /* synthetic */ CorrPlot points$default(CorrPlot corrPlot, String string, Boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = null;
        }
        return corrPlot.points(string, bl);
    }

    @NotNull
    public final CorrPlot labels(@Nullable String type, @Nullable Boolean diag, @Nullable Boolean mapSize, @Nullable String color) {
        CorrPlot corrPlot;
        CorrPlot.Companion.checkTypeArg(type);
        CorrPlot $this$labels_u24lambda_u242 = corrPlot = this.copy();
        boolean bl = false;
        $this$labels_u24lambda_u242.labels.setType(type);
        $this$labels_u24lambda_u242.labels.setDiag(diag);
        $this$labels_u24lambda_u242.labels.setMapSize(mapSize);
        $this$labels_u24lambda_u242.labels.setColor(color);
        return corrPlot;
    }

    public static /* synthetic */ CorrPlot labels$default(CorrPlot corrPlot, String string, Boolean bl, Boolean bl2, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = null;
        }
        if ((n & 4) != 0) {
            bl2 = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return corrPlot.labels(string, bl, bl2, string2);
    }

    @NotNull
    public final CorrPlot paletteGradient(@NotNull String low, @NotNull String mid, @NotNull String high) {
        Intrinsics.checkNotNullParameter((Object)low, (String)"low");
        Intrinsics.checkNotNullParameter((Object)mid, (String)"mid");
        Intrinsics.checkNotNullParameter((Object)high, (String)"high");
        return this.copyUpdateColors(CorrPlot.Companion.colorGradient(low, mid, high), CorrPlot.Companion.fillGradient(low, mid, high));
    }

    @NotNull
    public final CorrPlot paletteBrBG() {
        return this.setBrewerPalette("BrBG");
    }

    @NotNull
    public final CorrPlot palettePiYG() {
        return this.setBrewerPalette("PiYG");
    }

    @NotNull
    public final CorrPlot palettePRGn() {
        return this.setBrewerPalette("PRGn");
    }

    @NotNull
    public final CorrPlot palettePuOr() {
        return this.setBrewerPalette("PuOr");
    }

    @NotNull
    public final CorrPlot paletteRdBu() {
        return this.setBrewerPalette("RdBu");
    }

    @NotNull
    public final CorrPlot paletteRdGy() {
        return this.setBrewerPalette("RdGy");
    }

    @NotNull
    public final CorrPlot paletteRdYlBu() {
        return this.setBrewerPalette("RdYlBu");
    }

    @NotNull
    public final CorrPlot paletteRdYlGn() {
        return this.setBrewerPalette("RdYlGn");
    }

    @NotNull
    public final CorrPlot paletteSpectral() {
        return this.setBrewerPalette("Spectral");
    }

    private final CorrPlot setBrewerPalette(String palette) {
        return this.copyUpdateColors(CorrPlot.Companion.colorBrewer(palette), CorrPlot.Companion.fillBrewer(palette));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Plot build() {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Object element$iv$iv2;
        void $this$filterTo$iv$iv3;
        void $this$mapTo$iv$iv;
        Map<Pair<String, String>, Double> map2;
        Collection collection;
        void $this$mapTo$iv$iv22;
        if (!(this.tiles.getAdded() || this.points.getAdded() || this.labels.getAdded())) {
            return GgplotKt.letsPlot$default(null, null, 3, null);
        }
        OptionsConfigurator.INSTANCE.configure(this.tiles, this.points, this.labels, this.flip);
        Iterable $this$map$iv = this.data.keySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Object object = $this$mapTo$iv$iv22.iterator();
        while (object.hasNext()) {
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = object.next();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(String.valueOf(it));
        }
        List originalVariables = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        Map<String, List<Object>> data = ToSpecConvertersKt.asPlotData(this.data);
        boolean $this$mapTo$iv$iv22 = CorrUtil.INSTANCE.isCoefficientsMatrix(data);
        if ($this$mapTo$iv$iv22) {
            map2 = CorrUtil.INSTANCE.correlationsFromCoefficients(data);
        } else if (!$this$mapTo$iv$iv22) {
            map2 = CorrUtil.INSTANCE.correlations(data, (Function2<? super List<Double>, ? super List<Double>, Double>)((Function2)new Function2<List<? extends Double>, List<? extends Double>, Double>((Object)Method.INSTANCE){

                @NotNull
                public final Double invoke(@NotNull List<Double> p0, @NotNull List<Double> p1) {
                    Intrinsics.checkNotNullParameter(p0, (String)"p0");
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    return ((Method)this.receiver).correlationPearson(p0, p1);
                }
            }));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Map<Pair<String, String>, Double> correlations2 = map2;
        Iterable $this$map$iv2 = correlations2.keySet();
        boolean $i$f$map2 = false;
        object = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair2 = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add((String)it.getFirst());
        }
        Set varsInMatrix = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $this$filter$iv = originalVariables;
        boolean $i$f$filter = false;
        destination$iv$iv2 = $this$filter$iv;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv3) {
            String it = (String)element$iv$iv2;
            boolean bl = false;
            if (!varsInMatrix.contains(it)) continue;
            destination$iv$iv3.add(element$iv$iv2);
        }
        List varsInOrder = (List)destination$iv$iv3;
        boolean keepDiag = OptionsConfigurator.INSTANCE.getKeepMatrixDiag(this.tiles, this.points, this.labels);
        String combinedType = OptionsConfigurator.INSTANCE.getCombinedMatrixType(this.tiles, this.points, this.labels);
        Plot plot = null;
        plot = GgplotKt.letsPlot$default(null, null, 3, null).plus(this.colorScale).plus(this.fillScale);
        layerTooltips tooltips = new layerTooltips(new String[0]).format('@' + CorrVar.INSTANCE.getCORR(), VALUE_FORMAT).line('@' + CorrVar.INSTANCE.getCORR());
        if (this.tiles.getAdded()) {
            Map layerData = CorrPlot.Companion.layerData(this.tiles, correlations2, varsInOrder, keepDiag || Intrinsics.areEqual((Object)combinedType, (Object)"full"), this.threshold);
            boolean item$iv$iv = this.showLegend;
            element$iv$iv2 = SamplingKt.getSamplingNone();
            plot = plot.plus(new geomTile(layerData, null, null, item$iv$iv, null, null, (SamplingOptions)element$iv$iv2, tooltips, null, null, 1.002, 1.002, null, null, null, null, 0.0, null, null, null, null, build.1.INSTANCE, 2028342, null));
        }
        if (this.points.getAdded()) {
            Map layerData = CorrPlot.Companion.layerData(this.points, correlations2, varsInOrder, keepDiag || Intrinsics.areEqual((Object)combinedType, (Object)"full"), this.threshold);
            boolean item$iv$iv = this.showLegend;
            element$iv$iv2 = SamplingKt.getSamplingNone();
            plot = plot.plus(new geomPoint(layerData, null, null, item$iv$iv, null, null, (SamplingOptions)element$iv$iv2, tooltips, null, null, null, null, null, null, null, null, null, null, null, null, null, "x", null, null, build.2.INSTANCE, 14679862, null));
        }
        if (this.labels.getAdded()) {
            Map layerData = CorrPlot.Companion.layerData(this.labels, correlations2, varsInOrder, keepDiag || Intrinsics.areEqual((Object)combinedType, (Object)"full"), this.threshold);
            boolean item$iv$iv = this.showLegend;
            element$iv$iv2 = SamplingKt.getSamplingNone();
            Double it = Intrinsics.areEqual((Object)this.labels.getMapSize(), (Object)true) ? null : Double.valueOf(1.0);
            String bl = this.labels.getColor();
            plot = plot.plus(new geomText(layerData, null, null, item$iv$iv, null, null, (SamplingOptions)element$iv$iv2, tooltips, null, null, null, null, null, null, null, bl, it, null, null, null, null, null, null, VALUE_FORMAT, LEGEND_NAME, null, null, "x", null, null, null, build.3.INSTANCE, 1988001590, null));
        }
        Pair<List<String>, List<String>> pair3 = CorrUtil.INSTANCE.matrixXYSeries(correlations2, varsInOrder, combinedType, !keepDiag, this.threshold, !keepDiag, Intrinsics.areEqual((Object)combinedType, (Object)"full"));
        List xs = (List)pair3.component1();
        List ys = (List)pair3.component2();
        Pair plotSize2 = CorrPlot.Companion.plotSize(xs, ys, this.title != null, this.showLegend, this.adjustSize);
        plot = plot.plus(GgsizeKt.ggsize((Number)plotSize2.getFirst(), (Number)plotSize2.getSecond()));
        String string = this.title;
        if (string != null) {
            String $this$build_u24lambda_u246 = string;
            boolean bl = false;
            plot = plot.plus(GgtitleKt.ggtitle$default(this.title, null, 2, null));
        }
        Set xsSet = CollectionsKt.toSet((Iterable)CollectionsKt.distinct((Iterable)xs));
        Set ysSet = CollectionsKt.toSet((Iterable)CollectionsKt.distinct((Iterable)ys));
        Iterable $this$filter$iv2 = varsInOrder;
        boolean $i$f$filter2 = false;
        Iterable iterable2 = $this$filter$iv2;
        Iterable destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv3 : $this$filterTo$iv$iv2) {
            String it = (String)element$iv$iv3;
            boolean bl = false;
            if (!xsSet.contains(it)) continue;
            destination$iv$iv4.add(element$iv$iv3);
        }
        List plotX = (List)destination$iv$iv4;
        Iterable $this$filter$iv3 = varsInOrder;
        boolean $i$f$filter3 = false;
        destination$iv$iv4 = $this$filter$iv3;
        Collection destination$iv$iv5 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv4 : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv4;
            boolean bl = false;
            if (!ysSet.contains(it)) continue;
            destination$iv$iv5.add(element$iv$iv4);
        }
        List plotY = (List)destination$iv$iv5;
        boolean onlyTiles = this.tiles.getAdded() && !this.points.getAdded() && !this.labels.getAdded();
        return CorrPlot.Companion.addCommonParams(plot, plotX, plotY, onlyTiles, this.flip);
    }

    static {
        Object[] objectArray = new Double[]{-1.0, -0.5, 0.0, 0.5, 1.0};
        SCALE_BREAKS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"-1", "-0.5", "0", "0.5", "1"};
        SCALE_LABELS = CollectionsKt.listOf((Object[])objectArray);
        SCALE_LIMITS = TuplesKt.to((Object)-1.0, (Object)1.0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0012\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0006H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0006H\u0002J \u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006H\u0002J\u0010\u0010&\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0006H\u0002J \u0010'\u001a\u00020 2\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006H\u0002Jb\u0010(\u001a\u0016\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000f0)2\u0006\u0010*\u001a\u00020+2\u001e\u0010,\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0012\u0012\u0004\u0012\u00020\n0)2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010.\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\nH\u0002JH\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00122\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u00103\u001a\u00020\u001a2\u0006\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/letsPlot/bistro/corr/CorrPlot$Companion;", "", "()V", "COLUMN_WIDTH", "", "DEF_HIGH_COLOR", "", "DEF_LOW_COLOR", "DEF_MID_COLOR", "DEF_THRESHOLD", "", "LEGEND_NAME", "MAX_PLOT_WIDTH", "MIN_PLOT_WIDTH", "SCALE_BREAKS", "", "SCALE_LABELS", "SCALE_LIMITS", "Lkotlin/Pair;", "VALUE_FORMAT", "addCommonParams", "Lorg/jetbrains/letsPlot/intern/Plot;", "plot", "xValues", "yValues", "onlyTiles", "", "flipY", "checkTypeArg", "", "type", "colorBrewer", "Lorg/jetbrains/letsPlot/intern/Scale;", "palette", "colorGradient", "low", "mid", "high", "fillBrewer", "fillGradient", "layerData", "", "params", "Lorg/jetbrains/letsPlot/bistro/corr/LayerParams;", "correlations", "varsInOrder", "keepDiag", "threshold", "plotSize", "xs", "ys", "hasTitle", "hasLegend", "adjustSize", "plot-api"})
    @SourceDebugExtension(value={"SMAP\nCorrPlot.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CorrPlot.kt\norg/jetbrains/letsPlot/bistro/corr/CorrPlot$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,537:1\n1963#2,14:538\n*S KotlinDebug\n*F\n+ 1 CorrPlot.kt\norg/jetbrains/letsPlot/bistro/corr/CorrPlot$Companion\n*L\n492#1:538,14\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        private final void checkTypeArg(String type) {
            String string = type;
            if (string != null) {
                String $this$checkTypeArg_u24lambda_u241 = string;
                boolean bl = false;
                Object[] objectArray = new String[]{"upper", "lower", "full"};
                if (!CollectionsKt.listOf((Object[])objectArray).contains(type)) {
                    boolean bl2 = false;
                    String string2 = "The option 'type' must be \"upper\", \"lower\" or \"full\" but was: \"" + type + '\"';
                    throw new IllegalArgumentException(string2.toString());
                }
            }
        }

        private final Scale colorGradient(String low, String mid, String high) {
            return ColorContinuousKt.scaleColorGradient2$default(low, mid, high, 0.0, CorrPlot.LEGEND_NAME, SCALE_BREAKS, SCALE_LABELS, null, SCALE_LIMITS, "rgba(0,0,0,0)", null, null, null, 7304, null);
        }

        private final Scale fillGradient(String low, String mid, String high) {
            return ColorContinuousKt.scaleFillGradient2$default(low, mid, high, 0.0, CorrPlot.LEGEND_NAME, SCALE_BREAKS, SCALE_LABELS, null, SCALE_LIMITS, "rgba(0,0,0,0)", null, null, null, 7304, null);
        }

        private final Scale colorBrewer(String palette) {
            return ColorBrewerKt.scaleColorBrewer$default(null, palette, null, CorrPlot.LEGEND_NAME, SCALE_BREAKS, SCALE_LABELS, null, SCALE_LIMITS, "rgba(0,0,0,0)", null, null, null, 3653, null);
        }

        private final Scale fillBrewer(String palette) {
            return ColorBrewerKt.scaleFillBrewer$default(null, palette, null, CorrPlot.LEGEND_NAME, SCALE_BREAKS, SCALE_LABELS, null, SCALE_LIMITS, "rgba(0,0,0,0)", null, null, null, 3653, null);
        }

        private final Plot addCommonParams(Plot plot, List<String> xValues, List<String> yValues, boolean onlyTiles, boolean flipY) {
            Plot plot2 = plot;
            Map<String, Boolean> map2 = ThemeKt.elementBlank();
            Object[] objectArray = ThemeKt.elementBlank();
            Map map3 = ThemeKt.elementLine$default(null, null, null, false, 7, null);
            Map map4 = ThemeKt.elementLine$default(null, null, null, false, 7, null);
            Map<String, Boolean> map5 = ThemeKt.elementBlank();
            plot2 = plot2.plus(new theme(null, null, null, null, null, null, null, null, null, map2, null, null, null, null, null, null, map3, map4, null, null, null, null, null, null, objectArray, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, map5, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, -16974337, -32769, 0x3FFFFFF, null));
            plot2 = plot2.plus(IdentityKt.scaleSizeIdentity$default(null, null, null, null, null, 0, null, "none", 95, null));
            objectArray = new Double[]{0.0, 0.0};
            List expand = CollectionsKt.listOf((Object[])objectArray);
            plot2 = plot2.plus(XYDiscreteKt.scaleXDiscrete$default(null, xValues, null, null, xValues, expand, null, null, null, null, 973, null));
            plot2 = plot2.plus(XYDiscreteKt.scaleYDiscrete$default(null, yValues, null, null, flipY ? CollectionsKt.asReversed(yValues) : yValues, expand, null, null, null, null, 973, null));
            Pair xLim = new Pair((Object)-0.6, (Object)((double)(xValues.size() - 1) + 0.6));
            Pair yLim = new Pair((Object)-0.6, (Object)((double)(yValues.size() - 1) + 0.6));
            plot2 = plot2.plus(onlyTiles ? CoordKt.coordCartesian$default(xLim, yLim, false, 4, null) : CoordKt.coordFixed$default(null, xLim, yLim, false, 9, null));
            return plot2;
        }

        private final Pair<Integer, Integer> plotSize(List<String> xs, List<String> ys, boolean hasTitle, boolean hasLegend, double adjustSize) {
            int colCount = CollectionsKt.distinct((Iterable)xs).size();
            int titleHeight = hasTitle ? 20 : 0;
            int legendWidth = hasLegend ? 70 : 0;
            int geomWidth = (int)((double)Math.min(700, Math.max(150, colCount * 40)) * adjustSize);
            int labelWidthX = org.jetbrains.letsPlot.bistro.corr.CorrPlot$Companion.plotSize$axisLabelWidth(xs);
            int labelWidthY = org.jetbrains.letsPlot.bistro.corr.CorrPlot$Companion.plotSize$axisLabelWidth(ys);
            int colWidth = geomWidth / colCount;
            int labelHeightY = (double)labelWidthY * 1.0 > (double)colWidth ? labelWidthY / 2 : 20;
            int width2 = geomWidth + labelWidthX + legendWidth;
            int height = geomWidth + titleHeight + labelHeightY;
            return TuplesKt.to((Object)width2, (Object)height);
        }

        private final Map<String, List<Object>> layerData(LayerParams params, Map<Pair<String, String>, Double> correlations2, List<String> varsInOrder, boolean keepDiag, double threshold) {
            Boolean bl = params.getDiag();
            Intrinsics.checkNotNull((Object)bl);
            boolean diag = bl;
            String string = params.getType();
            Intrinsics.checkNotNull((Object)string);
            String type = string;
            Pair<List<String>, List<String>> pair2 = CorrUtil.INSTANCE.matrixXYSeries(correlations2, varsInOrder, type, !keepDiag, threshold, false, false);
            List xs = (List)pair2.component1();
            List ys = (List)pair2.component2();
            CorrUtil.CorrMatrix matrix = new CorrUtil.CorrMatrix(correlations2, !diag, threshold);
            return CorrUtil.INSTANCE.correlationsToDataframe(matrix, xs, ys);
        }

        private static final int plotSize$axisLabelWidth(List<String> labs) {
            Object v0;
            Iterable $this$maxByOrNull$iv = labs;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    String it = (String)maxElem$iv;
                    boolean bl = false;
                    int maxValue$iv = it.length();
                    do {
                        Object e$iv = iterator$iv.next();
                        String it2 = (String)e$iv;
                        $i$a$-maxByOrNull-CorrPlot$Companion$plotSize$axisLabelWidth$labelLen$1 = false;
                        int v$iv = it2.length();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            String string = v0;
            int labelLen = string != null ? string.length() : 0;
            return (int)((double)labelLen * 5.7);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

