/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.text;

import com.github.weisj.jsvg.attributes.FillRule;
import com.github.weisj.jsvg.attributes.text.GlyphRenderMethod;
import com.github.weisj.jsvg.attributes.text.Side;
import com.github.weisj.jsvg.attributes.text.Spacing;
import com.github.weisj.jsvg.geometry.SVGShape;
import com.github.weisj.jsvg.geometry.size.Length;
import com.github.weisj.jsvg.geometry.size.MeasureContext;
import com.github.weisj.jsvg.geometry.util.ReversePathIterator;
import com.github.weisj.jsvg.nodes.Anchor;
import com.github.weisj.jsvg.nodes.ShapeNode;
import com.github.weisj.jsvg.nodes.animation.Animate;
import com.github.weisj.jsvg.nodes.animation.AnimateTransform;
import com.github.weisj.jsvg.nodes.animation.Set;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.ElementCategories;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import com.github.weisj.jsvg.nodes.text.GlyphCursor;
import com.github.weisj.jsvg.nodes.text.PathGlyphCursor;
import com.github.weisj.jsvg.nodes.text.TextContainer;
import com.github.weisj.jsvg.nodes.text.TextSpan;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.renderer.RenderContext;
import com.github.weisj.jsvg.util.PathUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import org.jetbrains.annotations.NotNull;

@ElementCategories(value={Category.Graphic, Category.TextContent, Category.TextContentChild})
@PermittedContent(categories={Category.Descriptive}, anyOf={Anchor.class, TextSpan.class, Animate.class, AnimateTransform.class, Set.class}, charData=true)
public final class TextPath
extends TextContainer {
    public static final String TAG = "textpath";
    private static final boolean DEBUG = false;
    private SVGShape pathShape;
    private Spacing spacing;
    private GlyphRenderMethod renderMethod;
    private Side side;
    private Length startOffset;

    @Override
    @NotNull
    public String tagName() {
        return TAG;
    }

    @Override
    public void build(@NotNull AttributeNode attributeNode) {
        super.build(attributeNode);
        this.renderMethod = attributeNode.getEnum("method", GlyphRenderMethod.Align);
        this.side = attributeNode.getEnum("side", Side.Left);
        this.spacing = attributeNode.getEnum("spacing", Spacing.Auto);
        this.startOffset = attributeNode.getLength("startOffset", 0.0f);
        String pathData = attributeNode.getValue("path");
        if (pathData != null) {
            this.pathShape = PathUtil.parseFromPathData(pathData, FillRule.EvenOdd);
        } else {
            String href2 = attributeNode.getHref();
            ShapeNode shaped = attributeNode.getElementByHref(ShapeNode.class, Category.Shape, href2);
            if (shaped != null) {
                this.pathShape = shaped.shape();
            }
        }
    }

    @Override
    public boolean isVisible(@NotNull RenderContext context) {
        return this.pathShape != null && super.isVisible(context);
    }

    @Override
    @NotNull
    public Shape untransformedElementShape(@NotNull RenderContext context) {
        Path2D.Float textPath = new Path2D.Float();
        this.appendTextShape(this.createCursor(context), textPath, context);
        return textPath;
    }

    @Override
    public void render(@NotNull RenderContext context, @NotNull Graphics2D g) {
        this.renderSegment(this.createCursor(context), context, g);
    }

    @NotNull
    private PathGlyphCursor createCursor(@NotNull RenderContext context) {
        return new PathGlyphCursor(this.createPathIterator(context), this.startOffset.resolveLength(context.measureContext()));
    }

    private void paintDebugPath(@NotNull RenderContext context, @NotNull Graphics2D g) {
        PathIterator pathIterator = this.createPathIterator(context);
        float startX = 0.0f;
        float startY = 0.0f;
        float curX = 0.0f;
        float curY = 0.0f;
        g.setStroke(new BasicStroke(0.5f));
        float[] cord = new float[2];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(cord)) {
                case 1: {
                    g.setColor(Color.MAGENTA);
                    g.draw(new Line2D.Float(curX, curY, cord[0], cord[1]));
                    g.setColor(Color.RED);
                    g.fillRect((int)curX - 2, (int)curY - 2, 4, 4);
                    g.fillRect((int)cord[0] - 2, (int)cord[1] - 2, 4, 4);
                    curX = cord[0];
                    curY = cord[1];
                    break;
                }
                case 0: {
                    curX = cord[0];
                    curY = cord[1];
                    startX = curX;
                    startY = curY;
                    break;
                }
                case 4: {
                    g.setColor(Color.MAGENTA);
                    g.draw(new Line2D.Float(curX, curY, startX, startY));
                    g.setColor(Color.RED);
                    g.fillRect((int)curX - 2, (int)curY - 2, 4, 4);
                    g.fillRect((int)startX - 2, (int)startY - 2, 4, 4);
                    curX = startX;
                    curY = startY;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            pathIterator.next();
        }
    }

    @NotNull
    private PathIterator createPathIterator(@NotNull RenderContext context) {
        MeasureContext measureContext = context.measureContext();
        Shape path2 = this.pathShape.shape(context);
        float flatness = 0.1f * measureContext.ex();
        switch (this.side) {
            case Left: {
                return path2.getPathIterator(null, flatness);
            }
            case Right: {
                return new ReversePathIterator(path2.getPathIterator(null, flatness));
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected GlyphCursor createLocalCursor(@NotNull RenderContext context, @NotNull GlyphCursor current) {
        return new PathGlyphCursor(current, this.startOffset.resolveLength(context.measureContext()), this.createPathIterator(context));
    }

    @Override
    protected void cleanUpLocalCursor(@NotNull GlyphCursor current, @NotNull GlyphCursor local) {
        current.updateFrom(local);
    }
}

