/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.actions;

import com.intellij.ide.IdeView;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.ws.rest.utils.RSUtils;
import java.util.Arrays;
import java.util.Set;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

final class RSTemplatesHelper {
    RSTemplatesHelper() {
    }

    static boolean isTemplateAvailable(DataContext dataContext, Set<? extends JpsModuleSourceRootType<?>> requiredRootTypes) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || view == null) {
            return false;
        }
        PsiDirectory[] directories = view.getDirectories();
        if (directories.length == 0) {
            return false;
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        boolean underRoot = Arrays.stream(directories).map(PsiDirectory::getVirtualFile).anyMatch(virtualFile -> index.isUnderSourceRootOfType(virtualFile, requiredRootTypes));
        if (!underRoot) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)directories[0].getVirtualFile(), (Project)project);
        return RSUtils.hasRestLibrary(module);
    }
}

