/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.util.DumbIncompleteModeUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PsiAnnotationSearchUtil {
    @Nullable
    public static PsiAnnotation findAnnotation(@NotNull PsiModifierListOwner psiModifierListOwner, @NotNull String annotationFQN) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(0);
        }
        if (annotationFQN == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(1);
        }
        if (DumbIncompleteModeUtil.isDumbOrIncompleteMode((PsiElement)psiModifierListOwner)) {
            return DumbIncompleteModeUtil.findAnnotationInDumbOrIncompleteMode(psiModifierListOwner, annotationFQN);
        }
        return psiModifierListOwner.getAnnotation(annotationFQN);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@NotNull PsiModifierListOwner psiModifierListOwner, String ... annotationFQNs) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(2);
        }
        if (annotationFQNs == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(3);
        }
        boolean isDumbMode = DumbIncompleteModeUtil.isDumbOrIncompleteMode((PsiElement)psiModifierListOwner);
        for (String annotationFQN : annotationFQNs) {
            PsiAnnotation annotation = isDumbMode ? DumbIncompleteModeUtil.findAnnotationInDumbOrIncompleteMode(psiModifierListOwner, annotationFQN) : psiModifierListOwner.getAnnotation(annotationFQN);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static boolean isAnnotatedWith(@NotNull PsiModifierListOwner psiModifierListOwner, @NotNull String annotationFQN) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(4);
        }
        if (annotationFQN == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(5);
        }
        if (DumbIncompleteModeUtil.isDumbOrIncompleteMode((PsiElement)psiModifierListOwner)) {
            return DumbIncompleteModeUtil.findAnnotationInDumbOrIncompleteMode(psiModifierListOwner, annotationFQN) != null;
        }
        return psiModifierListOwner.hasAnnotation(annotationFQN);
    }

    public static boolean isNotAnnotatedWith(@NotNull PsiModifierListOwner psiModifierListOwner, String annotationTypeName) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(6);
        }
        return !PsiAnnotationSearchUtil.isAnnotatedWith(psiModifierListOwner, annotationTypeName);
    }

    public static boolean isAnnotatedWith(@NotNull PsiModifierListOwner psiModifierListOwner, String ... annotationTypes) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(7);
        }
        if (annotationTypes == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(8);
        }
        return null != PsiAnnotationSearchUtil.findAnnotation(psiModifierListOwner, annotationTypes);
    }

    public static boolean isNotAnnotatedWith(@NotNull PsiModifierListOwner psiModifierListOwner, String ... annotationTypes) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(9);
        }
        if (annotationTypes == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(10);
        }
        return !PsiAnnotationSearchUtil.isAnnotatedWith(psiModifierListOwner, annotationTypes);
    }

    @NotNull
    public static String getShortNameOf(@NotNull PsiAnnotation psiAnnotation) {
        PsiJavaCodeReferenceElement referenceElement;
        if (psiAnnotation == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(11);
        }
        String string = StringUtil.notNullize((String)(null == (referenceElement = psiAnnotation.getNameReferenceElement()) ? null : referenceElement.getReferenceName()));
        if (string == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static boolean checkAnnotationsSimpleNameExistsIn(@NotNull PsiModifierListOwner modifierListOwner, @NotNull Collection<String> annotationNames) {
        if (modifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(13);
        }
        if (annotationNames == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(14);
        }
        for (PsiAnnotation psiAnnotation : modifierListOwner.getAnnotations()) {
            String shortName = PsiAnnotationSearchUtil.getShortNameOf(psiAnnotation);
            if (!annotationNames.contains(shortName)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiAnnotation findAnnotationByShortNameOnly(@NotNull PsiModifierListOwner psiModifierListOwner, String ... annotationFQNs) {
        if (psiModifierListOwner == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(15);
        }
        if (annotationFQNs == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(16);
        }
        if (annotationFQNs.length > 0) {
            List possibleShortNames = ContainerUtil.map((Object[])annotationFQNs, StringUtil::getShortName);
            for (PsiAnnotation psiAnnotation : psiModifierListOwner.getAnnotations()) {
                String shortNameOfAnnotation = PsiAnnotationSearchUtil.getShortNameOf(psiAnnotation);
                if (!possibleShortNames.contains(shortNameOfAnnotation)) continue;
                return psiAnnotation;
            }
        }
        return null;
    }

    public static boolean checkAnnotationHasOneOfFQNs(@NotNull PsiAnnotation psiAnnotation, String ... annotationFQNs) {
        if (psiAnnotation == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(17);
        }
        if (annotationFQNs == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(18);
        }
        if (DumbIncompleteModeUtil.isDumbOrIncompleteMode((PsiElement)psiAnnotation)) {
            return ContainerUtil.or((Object[])annotationFQNs, fqn -> DumbIncompleteModeUtil.hasQualifiedNameInDumbOrIncompleteMode(psiAnnotation, fqn));
        }
        return ContainerUtil.or((Object[])annotationFQNs, arg_0 -> ((PsiAnnotation)psiAnnotation).hasQualifiedName(arg_0));
    }

    public static boolean checkAnnotationHasOneOfFQNs(@NotNull PsiAnnotation psiAnnotation, @NotNull Set<String> annotationFQNs) {
        if (psiAnnotation == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(19);
        }
        if (annotationFQNs == null) {
            PsiAnnotationSearchUtil.$$$reportNull$$$0(20);
        }
        if (DumbIncompleteModeUtil.isDumbOrIncompleteMode((PsiElement)psiAnnotation)) {
            return ContainerUtil.or(annotationFQNs, fqn -> DumbIncompleteModeUtil.hasQualifiedNameInDumbOrIncompleteMode(psiAnnotation, fqn));
        }
        return ContainerUtil.or(annotationFQNs, arg_0 -> ((PsiAnnotation)psiAnnotation).hasQualifiedName(arg_0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiModifierListOwner";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 3: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQNs";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationTypes";
                break;
            }
            case 11: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/util/PsiAnnotationSearchUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierListOwner";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/util/PsiAnnotationSearchUtil";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortNameOf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatedWith";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isNotAnnotatedWith";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getShortNameOf";
                break;
            }
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotationsSimpleNameExistsIn";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationByShortNameOnly";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotationHasOneOfFQNs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }
}

