/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.users;

import com.intellij.cwm.plugin.common.control.following.CodeWithMeEditorMarkService;
import com.intellij.cwm.plugin.common.toolbar.CodeWithMeUsersGroupKt;
import com.intellij.cwm.plugin.common.users.ConnectableUser;
import com.intellij.cwm.plugin.common.users.UserManagerKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.codeWithMe.model.RdUserId;
import com.jetbrains.codeWithMe.model.RdUserModel;
import com.jetbrains.codeWithMe.model.RdUserProperties;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IMutableViewableList;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.IViewableList;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rd.util.reactive.ViewableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 N2\u00020\u0001:\u0001NB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0004J\u0010\u0010;\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\nH&J\u0010\u0010<\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\nH&J\u0006\u0010=\u001a\u00020\u001aJ\b\u0010>\u001a\u00020\u001aH&J\u0018\u0010?\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010@\u001a\u00020\u0012H&J\u0010\u0010A\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\nH&J\u0006\u0010B\u001a\u00020\u001aJ\u0012\u0010C\u001a\u0004\u0018\u00010\n2\u0006\u0010D\u001a\u00020EH&J\u0012\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010\u001d\u001a\u00020\nH&J\u000e\u0010H\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\nJ\u0016\u0010I\u001a\b\u0012\u0004\u0012\u00020J0%2\u0006\u0010\u001d\u001a\u00020\nH\u0016J\u0014\u0010K\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u001fJ\u0006\u0010L\u001a\u00020MR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00160\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010!R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0019\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0017\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010!R\u0019\u0010.\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0)\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010+R\"\u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010+\"\u0004\b2\u00103R\u0017\u00104\u001a\b\u0012\u0004\u0012\u00020\u00120)\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010+R\u0017\u00106\u001a\b\u0012\u0004\u0012\u00020\u00120)\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010+R\u0014\u00108\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:\u00a8\u0006O"}, d2={"Lcom/intellij/cwm/plugin/common/users/UserManager;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "followersList", "Lcom/jetbrains/rd/util/reactive/ViewableList;", "Lcom/jetbrains/codeWithMe/model/RdUserModel;", "getFollowersList", "()Lcom/jetbrains/rd/util/reactive/ViewableList;", "leadProperty", "Lcom/jetbrains/rd/util/reactive/Property;", "getLeadProperty", "()Lcom/jetbrains/rd/util/reactive/Property;", "sessionEnabledProperty", "", "getSessionEnabledProperty", "usersList", "myConnectableUsersList", "Lcom/intellij/cwm/plugin/common/users/ConnectableUser;", "meProperty", "hasGuestsProperty", "registerUser", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "user", "users", "Lcom/jetbrains/rd/util/reactive/IViewableList;", "getUsers", "()Lcom/jetbrains/rd/util/reactive/IViewableList;", "connectableUsers", "getConnectableUsers", "connectedUsers", "", "getConnectedUsers", "()Ljava/util/List;", "me", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "getMe", "()Lcom/jetbrains/rd/util/reactive/IPropertyView;", "followers", "getFollowers", "lead", "getLead", "recentLead", "getRecentLead", "setRecentLead", "(Lcom/jetbrains/rd/util/reactive/IPropertyView;)V", "sessionEnabled", "getSessionEnabled", "hasGuests", "getHasGuests", "cwmActionsAllowed", "getCwmActionsAllowed", "()Z", "jumpTo", "startFollowing", "stopFollowingOrSync", "stopFollowing", "requestFollowing", "force", "requestStopFollowing", "requestOtherToFollow", "getUserById", "id", "Lcom/jetbrains/codeWithMe/model/RdUserId;", "getUserProperties", "Lcom/jetbrains/codeWithMe/model/RdUserProperties;", "isFullSyncWith", "createUserActions", "Lcom/intellij/openapi/actionSystem/AnAction;", "hasRecentLead", "getCWMActionName", "", "Companion", "intellij.cwm.plugin.common"})
@SourceDebugExtension(value={"SMAP\nUserManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserManager.kt\ncom/intellij/cwm/plugin/common/users/UserManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,221:1\n60#2,5:222\n60#2,5:227\n13#2:242\n774#3:232\n865#3,2:233\n1563#3:235\n1634#3,3:236\n1761#3,3:239\n*S KotlinDebug\n*F\n+ 1 UserManager.kt\ncom/intellij/cwm/plugin/common/users/UserManager\n*L\n65#1:222,5\n68#1:227,5\n37#1:242\n84#1:232\n84#1:233,2\n84#1:235\n84#1:236,3\n51#1:239,3\n*E\n"})
public abstract class UserManager
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ViewableList<RdUserModel> followersList;
    @NotNull
    private final Property<RdUserModel> leadProperty;
    @NotNull
    private final Property<Boolean> sessionEnabledProperty;
    @NotNull
    private final ViewableList<RdUserModel> usersList;
    @NotNull
    private final ViewableList<ConnectableUser> myConnectableUsersList;
    @NotNull
    private final Property<RdUserModel> meProperty;
    @NotNull
    private final Property<Boolean> hasGuestsProperty;
    @NotNull
    private final IViewableList<RdUserModel> users;
    @NotNull
    private final IViewableList<ConnectableUser> connectableUsers;
    @NotNull
    private final IPropertyView<RdUserModel> me;
    @NotNull
    private final IViewableList<RdUserModel> followers;
    @NotNull
    private final IPropertyView<RdUserModel> lead;
    @NotNull
    private IPropertyView<RdUserModel> recentLead;
    @NotNull
    private final IPropertyView<Boolean> sessionEnabled;
    @NotNull
    private final IPropertyView<Boolean> hasGuests;
    private final boolean cwmActionsAllowed;
    @NotNull
    private static final Logger logger;

    public UserManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.followersList = new ViewableList(null, 1, null);
        this.leadProperty = new Property(null);
        this.sessionEnabledProperty = new Property((Object)false);
        this.usersList = new ViewableList(null, 1, null);
        this.myConnectableUsersList = new ViewableList(null, 1, null);
        this.meProperty = new Property(null);
        this.hasGuestsProperty = new Property((Object)false);
        this.usersList.advise(this.getServiceLifetime(), arg_0 -> UserManager._init_$lambda$0(this, arg_0));
        SourceExKt.flowInto((ISource)((ISource)this.usersList), (Lifetime)this.getServiceLifetime(), (IMutableViewableList)((IMutableViewableList)this.myConnectableUsersList), UserManager::_init_$lambda$1);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            SourceExKt.adviseOnce((ISource)((ISource)this.usersList), (Lifetime)this.getServiceLifetime(), arg_0 -> UserManager._init_$lambda$2(this, arg_0));
        }
        this.users = (IViewableList)this.usersList;
        this.connectableUsers = (IViewableList)this.myConnectableUsersList;
        this.me = (IPropertyView)this.meProperty;
        this.followers = (IViewableList)this.followersList;
        this.lead = (IPropertyView)this.leadProperty;
        this.recentLead = (IPropertyView)new Property(null);
        this.sessionEnabled = (IPropertyView)this.sessionEnabledProperty;
        this.hasGuests = (IPropertyView)this.hasGuestsProperty;
        this.cwmActionsAllowed = true;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final ViewableList<RdUserModel> getFollowersList() {
        return this.followersList;
    }

    @NotNull
    protected final Property<RdUserModel> getLeadProperty() {
        return this.leadProperty;
    }

    @NotNull
    protected final Property<Boolean> getSessionEnabledProperty() {
        return this.sessionEnabledProperty;
    }

    protected final void registerUser(@NotNull Lifetime lifetime, @NotNull RdUserModel user) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        if (UserManagerKt.isMe(user)) {
            Logger $this$debug_u24default$iv = logger;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Register new user. Me: " + user.getUserId().getClientIdValue() + " : " + user.getName(), e$iv);
            }
            InterfacesKt.setValue((IProperty)((IProperty)this.meProperty), (Lifetime)lifetime, (Object)user);
        } else {
            Logger $this$debug_u24default$iv = logger;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Register new user. New user: " + user.getUserId().getClientIdValue() + " : " + user.getName(), e$iv);
            }
            CollectionExKt.addUnique((Collection)((Collection)this.usersList), (Lifetime)lifetime, (Object)user);
        }
    }

    @NotNull
    public final IViewableList<RdUserModel> getUsers() {
        return this.users;
    }

    @NotNull
    public final IViewableList<ConnectableUser> getConnectableUsers() {
        return this.connectableUsers;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<RdUserModel> getConnectedUsers() {
        void $this$mapTo$iv$iv;
        ConnectableUser user;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CollectionsKt.toList((Iterable)((Iterable)this.myConnectableUsersList));
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            user = (ConnectableUser)element$iv$iv;
            boolean bl = false;
            if (!((Boolean)user.getConnected().getValue()).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            user = (ConnectableUser)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUser());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final IPropertyView<RdUserModel> getMe() {
        return this.me;
    }

    @NotNull
    public final IViewableList<RdUserModel> getFollowers() {
        return this.followers;
    }

    @NotNull
    public final IPropertyView<RdUserModel> getLead() {
        return this.lead;
    }

    @NotNull
    public final IPropertyView<RdUserModel> getRecentLead() {
        return this.recentLead;
    }

    public final void setRecentLead(@NotNull IPropertyView<RdUserModel> iPropertyView) {
        Intrinsics.checkNotNullParameter(iPropertyView, (String)"<set-?>");
        this.recentLead = iPropertyView;
    }

    @NotNull
    public final IPropertyView<Boolean> getSessionEnabled() {
        return this.sessionEnabled;
    }

    @NotNull
    public final IPropertyView<Boolean> getHasGuests() {
        return this.hasGuests;
    }

    public boolean getCwmActionsAllowed() {
        return this.cwmActionsAllowed;
    }

    public abstract void jumpTo(@NotNull RdUserModel var1);

    public abstract void startFollowing(@NotNull RdUserModel var1);

    public final void stopFollowingOrSync() {
        RdUserModel userWeAreFollowingNow = (RdUserModel)this.lead.getValue();
        if (userWeAreFollowingNow != null && this.isFullSyncWith(userWeAreFollowingNow)) {
            this.requestStopFollowing(userWeAreFollowingNow);
        }
        this.stopFollowing();
    }

    public abstract void stopFollowing();

    public abstract void requestFollowing(@NotNull RdUserModel var1, boolean var2);

    public abstract void requestStopFollowing(@NotNull RdUserModel var1);

    public final void requestOtherToFollow() {
        this.stopFollowing();
        for (RdUserModel user : this.users) {
            this.requestFollowing(user, true);
        }
    }

    @Nullable
    public abstract RdUserModel getUserById(@NotNull RdUserId var1);

    @Nullable
    public abstract RdUserProperties getUserProperties(@NotNull RdUserModel var1);

    public final boolean isFullSyncWith(@NotNull RdUserModel user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return Intrinsics.areEqual((Object)this.lead.getValue(), (Object)user) && this.followers.contains((Object)user);
    }

    @NotNull
    public List<AnAction> createUserActions(@NotNull RdUserModel user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Object[] objectArray = new AnAction[]{CodeWithMeUsersGroupKt.createJumpToAction(this, user), CodeWithMeUsersGroupKt.createFollowAction(this, user), CodeWithMeUsersGroupKt.createStopFollowingAction(this, user), CodeWithMeUsersGroupKt.createFullSyncAction(this, user)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public final boolean hasRecentLead(@NotNull IViewableList<RdUserModel> users) {
        Intrinsics.checkNotNullParameter(users, (String)"users");
        if (this.recentLead.getValue() == null) {
            return false;
        }
        RdUserModel rdUserModel = (RdUserModel)this.recentLead.getValue();
        String recentClientId = rdUserModel != null && (rdUserModel = rdUserModel.getUserId()) != null ? rdUserModel.getClientIdValue() : null;
        return users.stream().anyMatch(arg_0 -> UserManager.hasRecentLead$lambda$1(arg_0 -> UserManager.hasRecentLead$lambda$0(recentClientId, arg_0), arg_0));
    }

    @NotNull
    public final String getCWMActionName() {
        RdUserModel rdUserModel = (RdUserModel)this.me.getValue();
        return (rdUserModel != null ? UserManagerKt.isHost(rdUserModel) : false) ? "CWMHostShowPopupAction" : "CWMThinClientShowPopupAction";
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$0(UserManager this$0, IViewableList.Event it) {
        boolean bl;
        Property<Boolean> property;
        block3: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Iterable iterable = (Iterable)this$0.usersList;
            property = this$0.hasGuestsProperty;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    RdUserModel it2 = (RdUserModel)element$iv;
                    boolean bl2 = false;
                    if (!(!UserManagerKt.isOwner(it2) && !UserManagerKt.isMe(it2))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean bl3 = bl;
        property.setValue((Object)bl3);
        return Unit.INSTANCE;
    }

    private static final ConnectableUser _init_$lambda$1(RdUserModel user) {
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        return new ConnectableUser(user, (IProperty<Boolean>)((IProperty)new Property((Object)true)));
    }

    private static final Unit _init_$lambda$2(UserManager this$0, IViewableList.Event it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        CodeWithMeEditorMarkService.Companion.getInstance(this$0.project);
        return Unit.INSTANCE;
    }

    private static final boolean hasRecentLead$lambda$0(String $recentClientId, RdUserModel user) {
        return Intrinsics.areEqual((Object)user.getUserId().getClientIdValue(), (Object)$recentClientId);
    }

    private static final boolean hasRecentLead$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(UserManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        UserManager.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/cwm/plugin/common/users/UserManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/cwm/plugin/common/users/UserManager;", "project", "Lcom/intellij/openapi/project/Project;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.cwm.plugin.common"})
    @SourceDebugExtension(value={"SMAP\nUserManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserManager.kt\ncom/intellij/cwm/plugin/common/users/UserManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,221:1\n30#2,2:222\n*S KotlinDebug\n*F\n+ 1 UserManager.kt\ncom/intellij/cwm/plugin/common/users/UserManager$Companion\n*L\n36#1:222,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UserManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<UserManager> serviceClass$iv = UserManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (UserManager)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

