/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa;

import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.jpa.ConsoleTarget;
import com.intellij.jpa.JpaConsoleProvider;
import com.intellij.jpa.JpaConsoleUtils;
import com.intellij.jpa.engine.EelJpaHelperKt;
import com.intellij.jpa.engine.JakartaConsole;
import com.intellij.jpa.engine.JpaConsoleBase;
import com.intellij.jpa.engine.QlScriptModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.model.PersistencePackagePointer;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JakartaConsoleProvider
extends JpaConsoleProvider {
    @Override
    @NotNull
    protected JpaConsoleProvider.MyRunner createRunner(Project project, PersistencePackagePointer unitFile) {
        return new JakartaRunner(project, unitFile);
    }

    @Override
    protected JpaConsoleProvider.MyQueryRunner createQueryRunner(Module module, List<PersistencePackagePointer> unitFiles, QlScriptModel model) {
        return new JakartaQueryRunner(module.getProject(), unitFiles, model);
    }

    @Override
    protected boolean isAvailable(Module module) {
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)"jakarta.persistence.EntityManager");
    }

    public static class JakartaRunner
    extends JpaConsoleProvider.MyRunner {
        private final PersistencePackagePointer myUnitFile;

        public JakartaRunner(Project project, PersistencePackagePointer unitFile) {
            super(project, unitFile);
            this.myUnitFile = unitFile;
        }

        @Override
        protected void runInner(@NotNull ConsoleRunConfiguration configuration) {
            ConsoleTarget target;
            if (configuration == null) {
                JakartaRunner.$$$reportNull$$$0(0);
            }
            if ((target = JpaConsoleUtils.suggestAssignDatasourceIfNeeded(this.myUnitFile)) == null) {
                return;
            }
            if (!EelJpaHelperKt.canRunPersistenceConsole(this.getProject(), this.myUnitFile)) {
                return;
            }
            JakartaConsole.newConsole(target.getPersistencePackage()).withRunConfiguration(configuration).build().showConsole(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/jpa/JakartaConsoleProvider$JakartaRunner", "runInner"));
        }
    }

    public static class JakartaQueryRunner
    extends JpaConsoleProvider.MyQueryRunner {
        public JakartaQueryRunner(Project project, List<? extends PersistencePackagePointer> units, QlScriptModel model) {
            super(project, units, model);
        }

        @Override
        protected JpaConsoleBase createConsole(@NotNull PersistencePackagePointer unit, @NotNull ConsoleRunConfiguration configuration, String query) {
            if (unit == null) {
                JakartaQueryRunner.$$$reportNull$$$0(0);
            }
            if (configuration == null) {
                JakartaQueryRunner.$$$reportNull$$$0(1);
            }
            return JakartaConsole.newConsole(unit).withRunConfiguration(configuration).withQuery(query).build();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "unit";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "configuration";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jpa/JakartaConsoleProvider$JakartaQueryRunner";
            objectArray[2] = "createConsole";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

