/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.utils.persistence.data.parser.domain;

import com.intellij.javaee.utils.persistence.data.parser.PartTreeParserContext;
import com.intellij.javaee.utils.persistence.data.parser.domain.PropertyPath;
import com.intellij.javaee.utils.persistence.data.parser.domain.Sort;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class OrderBySource {
    private static final String BLOCK_SPLIT = "(?<=Asc|Desc)(?=\\p{Lu})";
    private static final Pattern DIRECTION_SPLIT = Pattern.compile("(.+?)(Asc|Desc)?$");
    private static final String INVALID_ORDER_SYNTAX = "Invalid order syntax for part %s!";
    private static final Set<String> DIRECTION_KEYWORDS = Set.of("Asc", "Desc");
    private final List<Sort.Order> orders;
    private final String mySource;

    public OrderBySource(@NotNull String clause, @NotNull PsiClass domainClass, @NotNull PartTreeParserContext parserContext) {
        if (clause == null) {
            OrderBySource.$$$reportNull$$$0(0);
        }
        if (domainClass == null) {
            OrderBySource.$$$reportNull$$$0(1);
        }
        if (parserContext == null) {
            OrderBySource.$$$reportNull$$$0(2);
        }
        this.mySource = clause;
        this.orders = new ArrayList<Sort.Order>();
        if (StringUtil.isNotEmpty((String)clause)) {
            for (String part : parserContext.splitOrderBy(clause)) {
                Sort.Direction direction;
                Matcher matcher = DIRECTION_SPLIT.matcher(part);
                if (!matcher.find()) continue;
                String propertyString = matcher.group(1);
                String directionString = matcher.group(2);
                if (propertyString != null && DIRECTION_KEYWORDS.contains(propertyString) && directionString == null) {
                    direction = StringUtil.isNotEmpty((String)propertyString) ? Sort.Direction.fromString(propertyString) : null;
                    this.orders.add(OrderBySource.createOrder("", direction, domainClass, part));
                    continue;
                }
                direction = StringUtil.isNotEmpty((String)directionString) ? Sort.Direction.fromString(directionString) : null;
                this.orders.add(OrderBySource.createOrder(propertyString, direction, domainClass, part));
            }
        }
    }

    public static String[] splitOrderClause(@NotNull String orderClause) {
        if (orderClause == null) {
            OrderBySource.$$$reportNull$$$0(3);
        }
        return orderClause.split(BLOCK_SPLIT);
    }

    private static Sort.Order createOrder(String propertySource, Sort.Direction direction, @NotNull PsiClass domainClass, String sortExpression) {
        if (domainClass == null) {
            OrderBySource.$$$reportNull$$$0(4);
        }
        PropertyPath propertyPath = PropertyPath.from(propertySource, (PsiType)JavaPsiFacade.getElementFactory((Project)domainClass.getProject()).createType(domainClass, PsiSubstitutor.EMPTY));
        return new Sort.Order(direction, propertyPath, propertySource, sortExpression);
    }

    public Sort toSort() {
        return this.orders.isEmpty() ? null : new Sort(this.orders);
    }

    public String toString() {
        return "ORDER_BY ('" + this.mySource + "')";
    }

    public List<Sort.Order> getOrders() {
        return this.orders;
    }

    public String getSource() {
        return this.mySource;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clause";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parserContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderClause";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/utils/persistence/data/parser/domain/OrderBySource";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "splitOrderClause";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createOrder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

