/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.polyglot.DefaultTopScope;
import com.oracle.truffle.polyglot.EngineAccessor;
import com.oracle.truffle.polyglot.OptionValuesImpl;
import com.oracle.truffle.polyglot.PolyglotBindings;
import com.oracle.truffle.polyglot.PolyglotContextConfig;
import com.oracle.truffle.polyglot.PolyglotContextImpl;
import com.oracle.truffle.polyglot.PolyglotEngineException;
import com.oracle.truffle.polyglot.PolyglotEngineImpl;
import com.oracle.truffle.polyglot.PolyglotFastThreadLocals;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguage;
import com.oracle.truffle.polyglot.PolyglotLanguageContextFactory;
import com.oracle.truffle.polyglot.PolyglotLanguageInstance;
import com.oracle.truffle.polyglot.PolyglotSharingLayer;
import com.oracle.truffle.polyglot.PolyglotSourceCache;
import com.oracle.truffle.polyglot.PolyglotThread;
import com.oracle.truffle.polyglot.PolyglotThreadInfo;
import com.oracle.truffle.polyglot.PolyglotValueDispatch;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class PolyglotLanguageContext
implements PolyglotImpl.VMObject {
    private static final TruffleLogger LOG = TruffleLogger.getLogger("engine", PolyglotLanguageContext.class);
    final PolyglotContextImpl context;
    final PolyglotLanguage language;
    final boolean eventsEnabled;
    private Thread creatingThread;
    private volatile boolean created;
    private volatile boolean initialized;
    private boolean initializing;
    volatile boolean finalized;
    volatile TruffleLanguage.ExitMode exited;
    @CompilerDirectives.CompilationFinal
    private volatile Object hostBindings;
    @CompilerDirectives.CompilationFinal
    private volatile Lazy lazy;
    @CompilerDirectives.CompilationFinal
    volatile TruffleLanguage.Env env;
    @CompilerDirectives.CompilationFinal
    private volatile List<Object> languageServices = Collections.emptyList();

    PolyglotLanguageContext(PolyglotContextImpl context, PolyglotLanguage language) {
        this.context = context;
        this.language = language;
        this.eventsEnabled = !language.isHost();
    }

    boolean isPolyglotBindingsAccessAllowed() {
        if (this.context.config.polyglotAccess == this.language.getAPIAccess().getPolyglotAccessAll()) {
            return true;
        }
        Set<String> accessibleLanguages = this.getAPIAccess().getBindingsAccess(this.context.config.polyglotAccess);
        if (accessibleLanguages == null) {
            return true;
        }
        return accessibleLanguages.contains(this.language.getId());
    }

    boolean isPolyglotEvalAllowed(String targetLanguage) {
        if (this.context.config.polyglotAccess == this.language.getAPIAccess().getPolyglotAccessAll()) {
            return true;
        }
        if (targetLanguage != null && this.language.getId().equals(targetLanguage)) {
            return true;
        }
        Set<String> accessibleLanguages = this.getAPIAccess().getEvalAccess(this.context.config.polyglotAccess, this.language.getId());
        if (accessibleLanguages == null || accessibleLanguages.isEmpty()) {
            return false;
        }
        if (accessibleLanguages.size() > 1 || !accessibleLanguages.iterator().next().equals(this.language.getId())) {
            return targetLanguage == null || accessibleLanguages.contains(targetLanguage);
        }
        return false;
    }

    Thread.UncaughtExceptionHandler getPolyglotExceptionHandler() {
        assert (this.env != null);
        return this.lazy.uncaughtExceptionHandler;
    }

    Map<String, LanguageInfo> getAccessibleLanguages(boolean allowInternalAndDependent) {
        Lazy l = this.lazy;
        if (l != null) {
            if (allowInternalAndDependent) {
                return this.lazy.accessibleInternalLanguages;
            }
            return this.lazy.accessiblePublicLanguages;
        }
        return null;
    }

    PolyglotLanguageInstance getLanguageInstanceOrNull() {
        Lazy l = this.lazy;
        if (l == null) {
            return null;
        }
        return l.languageInstance;
    }

    PolyglotLanguageInstance getLanguageInstance() {
        assert (this.env != null);
        return this.lazy.languageInstance;
    }

    private void checkThreadAccess(TruffleLanguage.Env localEnv) {
        assert (Thread.holdsLock(this.context));
        boolean singleThreaded = this.context.isSingleThreaded();
        Thread firstFailingThread = null;
        for (PolyglotThreadInfo threadInfo : this.context.getSeenThreads().values()) {
            if (EngineAccessor.LANGUAGE.isThreadAccessAllowed(localEnv, threadInfo.getThread(), singleThreaded)) continue;
            firstFailingThread = threadInfo.getThread();
            break;
        }
        if (firstFailingThread != null) {
            throw PolyglotContextImpl.throwDeniedThreadAccess(firstFailingThread, singleThreaded, Arrays.asList(this.language));
        }
    }

    Object getContextImpl() {
        TruffleLanguage.Env localEnv = this.env;
        if (localEnv != null) {
            return EngineAccessor.LANGUAGE.getContext(localEnv);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return null;
    }

    Object getPublicFileSystemContext() {
        Lazy l = this.lazy;
        if (l != null) {
            return l.publicFileSystemContext;
        }
        return null;
    }

    Object getInternalFileSystemContext() {
        Lazy l = this.lazy;
        if (l != null) {
            return l.internalFileSystemContext;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getHostBindings() {
        assert (this.initialized);
        if (this.hostBindings == null) {
            PolyglotLanguageContext polyglotLanguageContext = this;
            synchronized (polyglotLanguageContext) {
                if (this.hostBindings == null) {
                    Object prev = this.language.engine.enterIfNeeded(this.context, true);
                    try {
                        Object scope = EngineAccessor.LANGUAGE.getScope(this.env);
                        if (scope == null) {
                            scope = new DefaultTopScope();
                        }
                        this.hostBindings = this.asValue(scope);
                    }
                    finally {
                        this.language.engine.leaveIfNeeded(prev, this.context);
                    }
                }
            }
        }
        return this.hostBindings;
    }

    Object getPolyglotGuestBindings() {
        assert (this.isInitialized());
        return this.lazy.polyglotGuestBindings;
    }

    boolean isInitialized() {
        return this.initialized;
    }

    CallTarget parseCached(PolyglotLanguage accessingLanguage, Source source, String[] argumentNames) throws AssertionError {
        this.ensureInitialized(accessingLanguage);
        PolyglotSourceCache cache = this.context.layer.getSourceCache();
        assert (cache != null);
        return cache.parseCached(this, source, argumentNames);
    }

    TruffleLanguage.Env requireEnv() {
        TruffleLanguage.Env localEnv = this.env;
        if (localEnv == null) {
            throw CompilerDirectives.shouldNotReachHere("No language context is active on this thread.");
        }
        return localEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean finalizeContext(boolean mustSuceed, boolean notifyInstruments) {
        boolean performFinalize = false;
        PolyglotContextImpl polyglotContextImpl = this.context;
        synchronized (polyglotContextImpl) {
            this.waitWhileInitializing();
            if (!this.initialized) {
                return false;
            }
            if (!this.finalized) {
                this.finalized = true;
                performFinalize = true;
            }
        }
        if (performFinalize) {
            try {
                EngineAccessor.LANGUAGE.finalizeContext(this.env);
            }
            catch (Throwable t) {
                if (!mustSuceed || PolyglotContextImpl.isInternalError(t)) {
                    throw t;
                }
                assert (this.context.state.isClosing());
                assert (this.context.state.isInvalidOrClosed());
                this.context.engine.getEngineLogger().log(Level.FINE, "Exception was thrown while finalizing a polyglot context that is being cancelled or exited. Such exceptions are expected during cancelling or exiting.", t);
            }
            if (this.eventsEnabled && notifyInstruments) {
                EngineAccessor.INSTRUMENT.notifyLanguageContextFinalized(this.context.engine, this.context.creatorTruffleContext, this.language.info);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean exitContext(TruffleLanguage.ExitMode exitMode, int exitCode) {
        boolean performExit = false;
        PolyglotContextImpl polyglotContextImpl = this.context;
        synchronized (polyglotContextImpl) {
            this.waitWhileInitializing();
            if (!this.initialized) {
                return false;
            }
            if (this.exited == null || exitMode.ordinal() > this.exited.ordinal()) {
                this.exited = exitMode;
                performExit = true;
            }
        }
        if (performExit) {
            try {
                EngineAccessor.LANGUAGE.exitContext(this.env, exitMode, exitCode);
            }
            catch (Throwable t) {
                if (exitMode == TruffleLanguage.ExitMode.NATURAL || !(t instanceof AbstractTruffleException) && !(t instanceof PolyglotContextImpl.ExitException)) {
                    throw t;
                }
                if (t instanceof AbstractTruffleException && !this.context.state.isCancelling()) {
                    this.context.engine.getEngineLogger().log(Level.WARNING, "TruffleException thrown during exit notification! Languages are supposed to handle this kind of exceptions.", t);
                }
                this.context.engine.getEngineLogger().log(Level.FINE, "Exception thrown during exit notification!", t);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean dispose() {
        try {
            TruffleLanguage.Env localEnv;
            PolyglotContextImpl polyglotContextImpl = this.context;
            synchronized (polyglotContextImpl) {
                localEnv = this.env;
                if (localEnv != null) {
                    if (!this.lazy.ownedAlivePolyglotThreads.isEmpty()) {
                        throw new IllegalStateException("The language did not complete all polyglot threads but should have: " + String.valueOf(this.lazy.ownedAlivePolyglotThreads));
                    }
                    for (PolyglotThreadInfo threadInfo : this.context.getSeenThreads().values()) {
                        assert (threadInfo != PolyglotThreadInfo.NULL);
                        Thread thread = threadInfo.getThread();
                        if (thread == null) continue;
                        assert (!threadInfo.isPolyglotThread(this.context)) : "Polyglot threads must no longer be active in TruffleLanguage.finalizeContext, but polyglot thread " + thread.getName() + " is still active.";
                        if (!threadInfo.isCurrent() && threadInfo.isActive() && !this.context.state.isInvalidOrClosed()) {
                            throw PolyglotEngineException.illegalState("Another main thread was started while closing a polyglot context!");
                        }
                        EngineAccessor.LANGUAGE.disposeThread(localEnv, thread);
                    }
                }
            }
            if (localEnv != null) {
                EngineAccessor.LANGUAGE.dispose(localEnv);
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            if (!PolyglotContextImpl.isInternalError(t)) {
                throw new IllegalStateException("Guest language code was run during language disposal!", t);
            }
            throw t;
        }
    }

    void notifyDisposed(boolean notifyInstruments) {
        if (this.eventsEnabled && notifyInstruments) {
            EngineAccessor.INSTRUMENT.notifyLanguageContextDisposed(this.context.engine, this.context.creatorTruffleContext, this.language.info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] enterThread(PolyglotThread thread) {
        assert (this.isInitialized());
        assert (Thread.currentThread() == thread);
        PolyglotContextImpl polyglotContextImpl = this.context;
        synchronized (polyglotContextImpl) {
            this.context.checkClosedOrDisposing(false);
            if (this.context.finalizingEmbedderThreads) {
                throw PolyglotEngineException.closedException("The Context is already closed.");
            }
            this.lazy.ownedAlivePolyglotThreads.add(thread);
        }
        try {
            if (thread.beforeEnter != null) {
                thread.setEnterAllowed(false);
                try {
                    thread.beforeEnter.run();
                }
                finally {
                    thread.setEnterAllowed(true);
                }
            }
            return this.context.enterThreadChanged(false, true, false, true, false);
        }
        catch (Throwable t) {
            PolyglotContextImpl polyglotContextImpl2 = this.context;
            synchronized (polyglotContextImpl2) {
                this.lazy.ownedAlivePolyglotThreads.remove(thread);
                this.context.notifyAll();
            }
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void leaveAndDisposePolyglotThread(Object[] prev, PolyglotThread thread) {
        block14: {
            assert (this.isInitialized());
            try {
                this.context.leaveThreadChanged(prev, true, true);
                if (thread.afterLeave == null) break block14;
                thread.setEnterAllowed(false);
                try {
                    thread.afterLeave.run();
                }
                finally {
                    thread.setEnterAllowed(true);
                }
            }
            finally {
                PolyglotContextImpl polyglotContextImpl = this.context;
                synchronized (polyglotContextImpl) {
                    boolean removed = this.lazy.ownedAlivePolyglotThreads.remove(thread);
                    this.context.notifyAll();
                    assert (removed) : "thread was not removed from language context";
                }
            }
        }
    }

    boolean isCreated() {
        return this.created;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureCreated(PolyglotLanguage accessingLanguage) {
        if (this.creatingThread == Thread.currentThread()) {
            throw PolyglotEngineException.illegalState(String.format("Cyclic access to language context for language %s. The context is currently being created.", this.language.getId()));
        }
        if (!this.created) {
            PolyglotLanguageInstance languageInstance;
            if (this.context.finalizingEmbedderThreads) {
                throw PolyglotEngineException.illegalState(String.format("Creation of context for language %s is no longer allowed. Language contexts are finalized when embedder threads are being finalized.", this.language.getId()));
            }
            this.language.validateSandbox(this.context.config.sandboxPolicy);
            this.checkAccess(accessingLanguage);
            Map<String, Object> creatorConfig = this.context.creator == this.language ? this.context.config.creatorArguments : Collections.emptyMap();
            PolyglotContextConfig contextConfig = this.context.config;
            PolyglotSharingLayer layer = this.context.layer;
            Object object = this.context.engine.lock;
            synchronized (object) {
                if (this.language.isHost()) {
                    languageInstance = layer.isClaimed() && layer.hostLanguage == null ? layer.patchHostLanguage(this.language) : layer.allocateHostLanguage(this.language);
                } else {
                    this.context.claimSharingLayer(this.language);
                    languageInstance = layer.allocateInstance(this.context, this.language);
                }
            }
            object = this.context;
            synchronized (object) {
                if (!this.created) {
                    if (this.eventsEnabled) {
                        EngineAccessor.INSTRUMENT.notifyLanguageContextCreate(this.context.engine, this.context.creatorTruffleContext, this.language.info);
                    }
                    boolean wasCreated = false;
                    try {
                        TruffleLanguage.Env localEnv = EngineAccessor.LANGUAGE.createEnv(this, languageInstance.spi, contextConfig.out, contextConfig.err, contextConfig.in, creatorConfig, contextConfig.getLanguageOptionValues(this.language).copy(), contextConfig.getApplicationArguments(this.language));
                        Lazy localLazy = new Lazy(languageInstance, contextConfig);
                        if (layer.isSingleContext()) {
                            languageInstance.singleLanguageContext.update(this);
                        } else {
                            languageInstance.singleLanguageContext.invalidate();
                        }
                        this.checkThreadAccess(localEnv);
                        this.creatingThread = Thread.currentThread();
                        this.env = localEnv;
                        this.lazy = localLazy;
                        assert (EngineAccessor.LANGUAGE.getLanguage(this.env) != null);
                        try {
                            ArrayList<Object> languageServicesCollector = new ArrayList<Object>();
                            Object contextImpl = EngineAccessor.LANGUAGE.createEnvContext(localEnv, languageServicesCollector);
                            this.language.initializeContextClass(contextImpl);
                            String errorMessage = PolyglotLanguageContext.verifyServices(this.language.info, languageServicesCollector, this.language.cache.getServices());
                            if (errorMessage != null) {
                                throw PolyglotEngineException.illegalState(errorMessage);
                            }
                            PolyglotFastThreadLocals.notifyLanguageCreated(this);
                            this.languageServices = languageServicesCollector;
                            if (this.language.isHost()) {
                                this.context.initializeHostContext(this, this.context.config);
                            }
                            wasCreated = true;
                            if (this.eventsEnabled) {
                                EngineAccessor.INSTRUMENT.notifyLanguageContextCreated(this.context.engine, this.context.creatorTruffleContext, this.language.info);
                            }
                            this.context.invokeContextLocalsFactory(this.context.contextLocals, languageInstance.contextLocalLocations);
                            this.context.invokeContextThreadLocalFactory(languageInstance.contextThreadLocalLocations);
                            languageInstance = null;
                        }
                        catch (Throwable e) {
                            this.env = null;
                            this.lazy = null;
                            throw e;
                        }
                        finally {
                            this.creatingThread = null;
                        }
                        this.created = true;
                    }
                    finally {
                        if (!wasCreated && this.eventsEnabled) {
                            EngineAccessor.INSTRUMENT.notifyLanguageContextCreateFailed(this.context.engine, this.context.creatorTruffleContext, this.language.info);
                        }
                    }
                }
            }
        }
    }

    void close() {
        assert (Thread.holdsLock(this.context));
        this.created = false;
        this.lazy = null;
        this.env = null;
    }

    private static String verifyServices(LanguageInfo info, List<Object> registeredServices, Collection<String> expectedServices) {
        for (String expectedService : expectedServices) {
            boolean found = false;
            for (Object registeredService : registeredServices) {
                if (!PolyglotLanguageContext.isSubType(registeredService.getClass(), expectedService)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return String.format("Language %s declares service %s but doesn't register it", info.getName(), expectedService);
        }
        return null;
    }

    private static boolean isSubType(Class<?> clazz, String serviceClass) {
        if (clazz == null) {
            return false;
        }
        if (serviceClass.equals(clazz.getName()) || serviceClass.equals(clazz.getCanonicalName())) {
            return true;
        }
        if (PolyglotLanguageContext.isSubType(clazz.getSuperclass(), serviceClass)) {
            return true;
        }
        for (Class<?> implementedInterface : clazz.getInterfaces()) {
            if (!PolyglotLanguageContext.isSubType(implementedInterface, serviceClass)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean ensureInitialized(PolyglotLanguage accessingLanguage) {
        PolyglotContextImpl polyglotContextImpl;
        this.ensureCreated(accessingLanguage);
        if (this.initialized) {
            return false;
        }
        if (this.context.finalizingEmbedderThreads) {
            throw PolyglotEngineException.illegalState(String.format("Initialization of context for language %s is no longer allowed. Language contexts are finalized when embedder threads are being finalized.", this.language.getId()));
        }
        PolyglotContextImpl polyglotContextImpl2 = this.context;
        synchronized (polyglotContextImpl2) {
            this.waitWhileInitializing();
            if (this.initialized) {
                return false;
            }
            this.initializing = true;
        }
        try {
            assert (!this.initialized);
            boolean threadInitialized = false;
            if (this.eventsEnabled) {
                EngineAccessor.INSTRUMENT.notifyLanguageContextInitialize(this.context.engine, this.context.creatorTruffleContext, this.language.info);
            }
            this.initialized = true;
            try {
                if (!this.language.isHost()) {
                    PolyglotContextImpl polyglotContextImpl3 = this.context;
                    synchronized (polyglotContextImpl3) {
                        PolyglotThreadInfo polyglotThreadInfo = this.context.getCurrentThreadInfo();
                        polyglotThreadInfo.initializeLanguageContext(this);
                        threadInitialized = true;
                    }
                }
                EngineAccessor.LANGUAGE.postInitEnv(this.env);
            }
            catch (Throwable e) {
                this.initialized = false;
                if (threadInitialized && !this.language.isHost()) {
                    PolyglotContextImpl polyglotThreadInfo = this.context;
                    synchronized (polyglotThreadInfo) {
                        PolyglotThreadInfo polyglotThreadInfo2 = this.context.getCurrentThreadInfo();
                        polyglotThreadInfo2.clearLanguageContextInitialized(this.language);
                    }
                }
                try {
                    if (this.eventsEnabled) {
                        EngineAccessor.INSTRUMENT.notifyLanguageContextInitializeFailed(this.context.engine, this.context.creatorTruffleContext, this.language.info);
                    }
                }
                catch (Throwable inner) {
                    e.addSuppressed(inner);
                }
                throw e;
            }
            if (this.eventsEnabled) {
                EngineAccessor.INSTRUMENT.notifyLanguageContextInitialized(this.context.engine, this.context.creatorTruffleContext, this.language.info);
            }
        }
        finally {
            polyglotContextImpl = this.context;
            synchronized (polyglotContextImpl) {
                this.initializing = false;
                this.context.notifyAll();
            }
        }
        polyglotContextImpl = this.context;
        synchronized (polyglotContextImpl) {
            this.ensureMultiThreadingInitialized(false);
            for (PolyglotThreadInfo threadInfo : this.context.getSeenThreads().values()) {
                Thread thread = threadInfo.getThread();
                if (thread == Thread.currentThread() || threadInfo.isLanguageContextInitialized(this.language) || threadInfo.isFinalizationComplete()) continue;
                threadInfo.initializeLanguageContext(this);
            }
        }
        return true;
    }

    private void waitWhileInitializing() {
        assert (Thread.holdsLock(this.context));
        while (this.initializing) {
            try {
                this.context.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void ensureMultiThreadingInitialized(boolean mustSucceed) {
        assert (Thread.holdsLock(this.context));
        Lazy l = this.lazy;
        assert (l != null);
        if (!l.multipleThreadsInitialized && !this.context.isSingleThreaded()) {
            try {
                EngineAccessor.LANGUAGE.initializeMultiThreading(this.env);
            }
            catch (Throwable t) {
                if (!mustSucceed || PolyglotContextImpl.isInternalError(t)) {
                    throw t;
                }
                assert (this.context.state.isClosing());
                assert (this.context.state.isInvalidOrClosed());
                this.context.engine.getEngineLogger().log(Level.FINE, "Exception was thrown while initializing multi-threading for a polyglot context that is being cancelled or exited. Such exceptions are expected during cancelling or exiting.", t);
            }
            l.multipleThreadsInitialized = true;
        }
    }

    void checkAccess(PolyglotLanguage accessingLanguage) {
        this.context.checkClosedOrDisposing(false);
        if (!this.context.config.isAccessPermitted(accessingLanguage, this.language)) {
            throw PolyglotEngineException.illegalArgument(String.format("Access to language '%s' is not permitted. ", this.language.getId()));
        }
        RuntimeException initError = this.language.initError;
        if (initError != null) {
            throw PolyglotEngineException.illegalState(String.format("Initialization error: %s", initError.getMessage(), initError));
        }
    }

    @Override
    public PolyglotEngineImpl getEngine() {
        return this.context.engine;
    }

    @Override
    public AbstractPolyglotImpl.APIAccess getAPIAccess() {
        return this.context.engine.apiAccess;
    }

    @Override
    public PolyglotImpl getImpl() {
        return this.context.engine.impl;
    }

    boolean patch(PolyglotContextConfig newConfig) {
        boolean requested;
        Set<PolyglotLanguage> configuredLanguages = newConfig.getConfiguredLanguages();
        boolean bl = requested = this.language.isHost() || this.language.cache.isInternal() || configuredLanguages.isEmpty() || configuredLanguages.contains(this.language);
        if (requested && this.isCreated()) {
            try {
                OptionValuesImpl newOptionValues = newConfig.getLanguageOptionValues(this.language).copy();
                this.lazy.computeAccessPermissions(newConfig);
                TruffleLanguage.Env newEnv = EngineAccessor.LANGUAGE.patchEnvContext(this.env, newConfig.out, newConfig.err, newConfig.in, Collections.emptyMap(), newOptionValues, newConfig.getApplicationArguments(this.language));
                if (newEnv != null) {
                    this.env = newEnv;
                    if (!this.language.isHost()) {
                        LOG.log(Level.FINE, "Successfully patched context of language: {0}", this.language.getId());
                    }
                    return true;
                }
                LOG.log(Level.FINE, "Failed to patch context of language: {0}", this.language.getId());
                return false;
            }
            catch (Throwable t) {
                LOG.log(Level.FINE, "Exception during patching context of language: {0}", this.language.getId());
                throw PolyglotLanguageContext.silenceException(RuntimeException.class, t);
            }
        }
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "The language context patching for {0} is being skipped due to requested: {1}, created: {2}.", new Object[]{this.language.getId(), requested, this.isCreated()});
        }
        return true;
    }

    static <E extends Throwable> RuntimeException silenceException(Class<E> type, Throwable ex) throws E {
        throw ex;
    }

    <S> S lookupService(Class<S> type) {
        for (Object languageService : this.languageServices) {
            if (!type.isInstance(languageService)) continue;
            return type.cast(languageService);
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    Object asValue(Object guestValue) {
        AbstractPolyglotImpl.APIAccess api = this.context.getAPIAccess();
        assert (this.lazy != null);
        assert (guestValue != null);
        assert (!api.isValue(guestValue));
        assert (!api.isProxy(guestValue));
        PolyglotValueDispatch cache = this.getLanguageInstance().lookupValueCache(this.context, guestValue);
        return api.newValue(cache, this, guestValue);
    }

    public Object toGuestValue(Node node, Object receiver) {
        return this.context.toGuestValue(node, receiver, false);
    }

    @CompilerDirectives.TruffleBoundary
    Object[] toHostValues(Object[] values, int startIndex) {
        Object[] args = this.getAPIAccess().newValueArray(values.length - startIndex);
        for (int i = startIndex; i < values.length; ++i) {
            args[i - startIndex] = this.asValue(values[i]);
        }
        return args;
    }

    @CompilerDirectives.TruffleBoundary
    Object[] toHostValues(Object[] values) {
        Object[] args = this.getAPIAccess().newValueArray(values.length);
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.asValue(values[i]);
        }
        return args;
    }

    public String toString() {
        return "PolyglotLanguageContext [language=" + String.valueOf(this.language) + ", initialized=" + (this.env != null) + "]";
    }

    public Object getLanguageView(Object receiver) {
        EngineAccessor.INTEROP.checkInteropType(receiver);
        InteropLibrary lib = InteropLibrary.getFactory().getUncached(receiver);
        if (lib.hasLanguage(receiver)) {
            try {
                if (!this.isCreated()) {
                    throw PolyglotEngineException.illegalState("Language not yet created. Initialize the language first to request a language view.");
                }
                if (lib.getLanguage(receiver) == this.lazy.languageInstance.spi.getClass()) {
                    return receiver;
                }
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere(e);
            }
        }
        return this.getLanguageViewNoCheck(receiver);
    }

    private boolean validLanguageView(Object result) {
        InteropLibrary lib = InteropLibrary.getFactory().getUncached(result);
        Class<?> languageClass = EngineAccessor.LANGUAGE.getLanguage(this.env).getClass();
        try {
            assert (lib.hasLanguage(result) && lib.getLanguage(result) == languageClass) : String.format("The returned language view of language '%s' must return the class '%s' for InteropLibrary.getLanguage.Fix the implementation of %s.getLanguageView to resolve this.", languageClass.getTypeName(), languageClass.getTypeName(), languageClass.getTypeName());
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
        return true;
    }

    private boolean validScopedView(Object result, Node location) {
        InteropLibrary lib = InteropLibrary.getFactory().getUncached(result);
        Class<?> languageClass = EngineAccessor.LANGUAGE.getLanguage(this.env).getClass();
        try {
            assert (lib.hasLanguage(result) && lib.getLanguage(result) == languageClass) : String.format("The returned scoped view of language '%s' must return the class '%s' for InteropLibrary.getLanguage.Fix the implementation of %s.getView to resolve this.", languageClass.getTypeName(), languageClass.getTypeName(), location.getClass().getTypeName());
        }
        catch (UnsupportedMessageException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
        return true;
    }

    public Object getLanguageViewNoCheck(Object receiver) {
        Object result = EngineAccessor.LANGUAGE.getLanguageView(this.env, receiver);
        assert (this.validLanguageView(result));
        return result;
    }

    public Object getScopedView(Node location, Frame frame, Object value) {
        PolyglotLanguageContext.validateLocationAndFrame(this.language.info, location, frame);
        Object languageView = this.getLanguageView(value);
        Object result = NodeLibrary.getUncached().getView(location, frame, languageView);
        assert (this.validScopedView(result, location));
        return result;
    }

    private static void validateLocationAndFrame(LanguageInfo viewLanguage, Node location, Frame frame) {
        RootNode rootNode = location.getRootNode();
        if (rootNode == null) {
            throw PolyglotEngineException.illegalArgument(String.format("The location '%s' does not have a RootNode.", location));
        }
        LanguageInfo nodeLocation = rootNode.getLanguageInfo();
        if (nodeLocation == null) {
            throw PolyglotEngineException.illegalArgument(String.format("The location '%s' does not have a language associated.", location));
        }
        if (nodeLocation != viewLanguage) {
            throw PolyglotEngineException.illegalArgument(String.format("The view language '%s' must match the language of the location %s.", viewLanguage, nodeLocation));
        }
        if (!EngineAccessor.INSTRUMENT.isInstrumentable(location)) {
            throw PolyglotEngineException.illegalArgument(String.format("The location '%s' is not instrumentable but must be to request scoped views.", location));
        }
        if (!rootNode.getFrameDescriptor().equals(frame.getFrameDescriptor())) {
            throw PolyglotEngineException.illegalArgument(String.format("The frame provided does not originate from the location. Expected frame descriptor '%s' but was '%s'.", rootNode.getFrameDescriptor(), frame.getFrameDescriptor()));
        }
    }

    void patchInstance(PolyglotLanguageInstance hostInstance) {
        if (this.lazy != null) {
            this.lazy.languageInstance = hostInstance;
        }
    }

    Set<PolyglotThread> getOwnedAlivePolyglotThreads() {
        assert (Thread.holdsLock(this.context));
        Lazy l = this.lazy;
        if (l != null) {
            return l.ownedAlivePolyglotThreads;
        }
        return null;
    }

    final class Lazy {
        final Set<PolyglotThread> ownedAlivePolyglotThreads;
        final Object polyglotGuestBindings;
        final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
        @CompilerDirectives.CompilationFinal
        PolyglotLanguageInstance languageInstance;
        @CompilerDirectives.CompilationFinal
        Map<String, LanguageInfo> accessibleInternalLanguages;
        @CompilerDirectives.CompilationFinal
        Map<String, LanguageInfo> accessiblePublicLanguages;
        final Object internalFileSystemContext;
        final Object publicFileSystemContext;
        private boolean multipleThreadsInitialized;

        Lazy(PolyglotLanguageInstance languageInstance, PolyglotContextConfig config) {
            this.languageInstance = languageInstance;
            this.ownedAlivePolyglotThreads = new HashSet<PolyglotThread>();
            this.polyglotGuestBindings = new PolyglotBindings(PolyglotLanguageContext.this);
            this.uncaughtExceptionHandler = new PolyglotUncaughtExceptionHandler();
            this.computeAccessPermissions(config);
            this.publicFileSystemContext = EngineAccessor.LANGUAGE.createFileSystemContext(PolyglotLanguageContext.this, config.fileSystemConfig.fileSystem);
            this.internalFileSystemContext = EngineAccessor.LANGUAGE.createFileSystemContext(PolyglotLanguageContext.this, config.fileSystemConfig.internalFileSystem);
        }

        void computeAccessPermissions(PolyglotContextConfig config) {
            this.accessibleInternalLanguages = this.computeAccessibleLanguages(config, true);
            this.accessiblePublicLanguages = this.computeAccessibleLanguages(config, false);
        }

        private Map<String, LanguageInfo> computeAccessibleLanguages(PolyglotContextConfig config, boolean internal) {
            HashSet<String> resolveLanguages;
            PolyglotLanguage thisLanguage = this.languageInstance.language;
            if (thisLanguage.isHost()) {
                return this.languageInstance.getEngine().idToInternalLanguageInfo;
            }
            boolean embedderAllAccess = config.allowedPublicLanguages.isEmpty();
            PolyglotEngineImpl engine = this.languageInstance.getEngine();
            Set<String> configuredAccess = null;
            Set<String> configured = engine.getAPIAccess().getEvalAccess(config.polyglotAccess, thisLanguage.getId());
            if (configured != null) {
                configuredAccess = new HashSet<String>(configured);
            }
            if (embedderAllAccess) {
                if (configuredAccess == null) {
                    if (internal) {
                        return engine.idToInternalLanguageInfo;
                    }
                    resolveLanguages = new HashSet();
                    resolveLanguages.addAll(engine.idToInternalLanguageInfo.keySet());
                } else {
                    resolveLanguages = new HashSet<String>(configuredAccess);
                    resolveLanguages.add(thisLanguage.getId());
                }
            } else {
                if (configuredAccess == null) {
                    configuredAccess = config.allowedPublicLanguages;
                }
                resolveLanguages = new HashSet<String>(configuredAccess);
                resolveLanguages.add(thisLanguage.getId());
            }
            LinkedHashMap<String, LanguageInfo> resolvedLanguages = new LinkedHashMap<String, LanguageInfo>();
            for (String string : resolveLanguages) {
                PolyglotLanguage resolvedLanguage = engine.idToLanguage.get(string);
                if (resolvedLanguage == null || !internal && resolvedLanguage.cache.isInternal()) continue;
                resolvedLanguages.put(string, resolvedLanguage.info);
            }
            if (internal) {
                this.addDependentLanguages(engine, resolvedLanguages, thisLanguage);
            }
            if (internal) {
                for (Map.Entry entry : this.languageInstance.getEngine().idToLanguage.entrySet()) {
                    if (!((PolyglotLanguage)entry.getValue()).cache.isInternal()) continue;
                    resolvedLanguages.put((String)entry.getKey(), ((PolyglotLanguage)entry.getValue()).info);
                }
                assert (this.assertPermissionsConsistent(resolvedLanguages, this.languageInstance.language, config));
            }
            return resolvedLanguages;
        }

        private boolean assertPermissionsConsistent(Map<String, LanguageInfo> resolvedLanguages, PolyglotLanguage thisLanguage, PolyglotContextConfig config) {
            for (Map.Entry<String, PolyglotLanguage> entry : this.languageInstance.getEngine().idToLanguage.entrySet()) {
                boolean permitted = config.isAccessPermitted(thisLanguage, entry.getValue());
                assert (permitted == resolvedLanguages.containsKey(entry.getKey())) : "inconsistent access permissions";
            }
            return true;
        }

        private void addDependentLanguages(PolyglotEngineImpl engine, Map<String, LanguageInfo> resolvedLanguages, PolyglotLanguage currentLanguage) {
            for (String dependentLanguage : currentLanguage.cache.getDependentLanguages()) {
                PolyglotLanguage dependent = engine.idToLanguage.get(dependentLanguage);
                if (dependent == null || resolvedLanguages.containsKey(dependentLanguage)) continue;
                resolvedLanguages.put(dependentLanguage, dependent.info);
                this.addDependentLanguages(engine, resolvedLanguages, dependent);
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class ToGuestValuesNode
    extends Node {
        ToGuestValuesNode() {
        }

        abstract Object[] execute(Node var1, PolyglotLanguageContext var2, Object[] var3);

        @Specialization(guards={"args.length == 0"})
        static Object[] doZero(PolyglotLanguageContext context, Object[] args) {
            return args;
        }

        @ExplodeLoop
        @Specialization(replaces={"doZero"}, guards={"args.length == toGuestValues.length"}, limit="1")
        static Object[] doCached(Node node, PolyglotLanguageContext context, Object[] args, @Cached(value="createArray(args.length)") ToGuestValueNode[] toGuestValues, @Cached.Shared(value="needsCopy") @Cached InlinedBranchProfile needsCopyProfile) {
            boolean needsCopy = needsCopyProfile.wasEntered(node);
            Object[] newArgs = needsCopy ? new Object[toGuestValues.length] : args;
            for (int i = 0; i < toGuestValues.length; ++i) {
                Object arg = args[i];
                Object newArg = toGuestValues[i].execute(toGuestValues[i], context, arg);
                if (needsCopy) {
                    newArgs[i] = newArg;
                    continue;
                }
                if (arg == newArg) continue;
                needsCopyProfile.enter(node);
                needsCopy = true;
                newArgs = new Object[toGuestValues.length];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                newArgs[i] = newArg;
            }
            return newArgs;
        }

        @Specialization(replaces={"doZero", "doCached"})
        static Object[] doGeneric(Node node, PolyglotLanguageContext context, Object[] args, @Cached ToGuestValueNode toGuest, @Cached.Shared(value="needsCopy") @Cached InlinedBranchProfile needsCopyProfile) {
            boolean needsCopy = needsCopyProfile.wasEntered(node);
            Object[] newArgs = needsCopy ? new Object[args.length] : args;
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                Object newArg = toGuest.execute(node, context, arg);
                if (needsCopy) {
                    newArgs[i] = newArg;
                    continue;
                }
                if (arg == newArg) continue;
                needsCopyProfile.enter(node);
                needsCopy = true;
                newArgs = new Object[args.length];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                newArgs[i] = newArg;
            }
            return newArgs;
        }

        @NeverDefault
        static ToGuestValueNode[] createArray(int length) {
            ToGuestValueNode[] nodes = new ToGuestValueNode[length];
            for (int i = 0; i < nodes.length; ++i) {
                nodes[i] = PolyglotLanguageContextFactory.ToGuestValueNodeGen.create();
            }
            return nodes;
        }
    }

    @GenerateUncached
    @GenerateInline
    static abstract class ToGuestValueNode
    extends Node {
        ToGuestValueNode() {
        }

        abstract Object execute(Node var1, PolyglotLanguageContext var2, Object var3);

        @Specialization(guards={"receiver == null"})
        static Object doNull(Node node, PolyglotLanguageContext context, Object receiver) {
            return context.toGuestValue(node, receiver);
        }

        @Specialization(guards={"receiver != null", "receiver.getClass() == cachedReceiver"}, limit="3")
        static Object doCached(Node node, PolyglotLanguageContext context, Object receiver, @Cached(value="receiver.getClass()") Class<?> cachedReceiver) {
            return context.toGuestValue(node, cachedReceiver.cast(receiver));
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static Object doUncached(Node node, PolyglotLanguageContext context, Object receiver) {
            return context.toGuestValue(node, receiver);
        }
    }

    private class PolyglotUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private PolyglotUncaughtExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (!(e instanceof ThreadDeath)) {
                TruffleLanguage.Env currentEnv = PolyglotLanguageContext.this.env;
                if (currentEnv != null) {
                    try {
                        e.printStackTrace(new PrintStream(currentEnv.err()));
                    }
                    catch (Throwable exc) {
                        e.printStackTrace();
                    }
                } else {
                    e.printStackTrace();
                }
            }
        }
    }

    static final class ValueMigrationException
    extends AbstractTruffleException {
        ValueMigrationException(String message, Node location) {
            super(message, location);
        }
    }

    @GenerateInline(value=true)
    @GenerateCached(value=false)
    static abstract class ToHostValueNode
    extends Node {
        ToHostValueNode() {
        }

        abstract Object execute(Node var1, PolyglotLanguageContext var2, Object var3);

        @Specialization(guards={"value.getClass() == cachedClass"}, limit="3")
        Object doCached(PolyglotLanguageContext languageContext, Object value, @Cached(value="value.getClass()") Class<?> cachedClass, @Cached(value="lookupDispatch(languageContext, value)") PolyglotValueDispatch cachedValue) {
            Object receiver = CompilerDirectives.inInterpreter() ? value : CompilerDirectives.castExact(value, cachedClass);
            return cachedValue.impl.getAPIAccess().newValue(cachedValue, languageContext, receiver);
        }

        @Specialization(replaces={"doCached"})
        Object doGeneric(PolyglotLanguageContext languageContext, Object value) {
            return languageContext.asValue(value);
        }

        @NeverDefault
        static PolyglotValueDispatch lookupDispatch(PolyglotLanguageContext languageContext, Object value) {
            return languageContext.lazy.languageInstance.lookupValueCache(languageContext.context, value);
        }
    }

    static final class Generic {
        private Generic() {
            throw CompilerDirectives.shouldNotReachHere("no instances");
        }
    }
}

