/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.trace.consent.actions;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.platform.trace.consent.TraceConsentBundle;
import com.intellij.platform.trace.consent.model.ConsentState;
import com.intellij.platform.trace.consent.model.TraceStateEvent;
import com.intellij.platform.trace.consent.storage.serialization.TraceStateEventDeserializer;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/trace/consent/actions/DecryptTraceEventAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "Companion", "intellij.platform.trace.consent"})
@SourceDebugExtension(value={"SMAP\nDecryptTraceEventAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DecryptTraceEventAction.kt\ncom/intellij/platform/trace/consent/actions/DecryptTraceEventAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
final class DecryptTraceEventAction
extends AnAction
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TRACE_DECRYPT_EVENT_VM_OPTION = "idea.trace.decrypt.event.action";
    @NotNull
    private static final String NOTIFICATION_GROUP_ID = "TRACE.DecryptEvent";

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean enabled = Boolean.getBoolean(TRACE_DECRYPT_EVENT_VM_OPTION);
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Object it;
        StringBuilder stringBuilder2;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        try {
            Transferable transferable = CopyPasteManager.getInstance().getContents();
            object2 = transferable != null ? transferable.getTransferData(DataFlavor.stringFlavor) : null;
            object2 = object2 instanceof String ? (String)object2 : null;
        }
        catch (Exception exception) {
            object2 = null;
        }
        Object clipboardContent = object2;
        Project project2 = project;
        String string = TraceConsentBundle.message("dialog.decrypt.trace.event.message", new Object[0]);
        String string2 = TraceConsentBundle.message("dialog.decrypt.trace.event.title", new Object[0]);
        Icon icon = Messages.getQuestionIcon();
        Object object3 = clipboardContent;
        if (object3 != null) {
            void it2;
            Object object4 = exception = object3;
            Icon icon2 = icon;
            String string3 = string2;
            String string4 = string;
            Project project3 = project2;
            boolean stringBuilder2 = false;
            boolean bl = !StringsKt.isBlank((CharSequence)((CharSequence)it2));
            project2 = project3;
            string = string4;
            string2 = string3;
            icon = icon2;
            object = bl ? exception : null;
        } else {
            object = null;
        }
        String encryptedData = Messages.showInputDialog((Project)project2, (String)string, (String)string2, (Icon)icon, object, null);
        Object exception = encryptedData;
        if (exception == null || StringsKt.isBlank((CharSequence)exception)) {
            return;
        }
        TraceStateEvent event = TraceStateEventDeserializer.INSTANCE.deserializeEncrypted(encryptedData);
        if (event == null) {
            Notification notification = new Notification(NOTIFICATION_GROUP_ID, TraceConsentBundle.message("notification.title.decrypt.trace.event.failed", new Object[0]), TraceConsentBundle.message("notification.content.decrypt.trace.event.failed", new Object[0]), NotificationType.ERROR);
            Notifications.Bus.notify((Notification)notification, (Project)project);
            return;
        }
        StringBuilder $this$actionPerformed_u24lambda_u241 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$actionPerformed_u24lambda_u241.append("IDE Name: " + event.getIdeName()).append('\n');
        $this$actionPerformed_u24lambda_u241.append("IDE Version: " + event.getIdeVersion()).append('\n');
        $this$actionPerformed_u24lambda_u241.append("Consent Type: " + event.getConsentType()).append('\n');
        $this$actionPerformed_u24lambda_u241.append("Consent State: " + event.getConsentState()).append('\n');
        $this$actionPerformed_u24lambda_u241.append("Timestamp: " + event.getTimestamp()).append('\n');
        ConsentState consentState = event.getPreviousConsentState();
        if (consentState != null) {
            it = consentState;
            boolean bl2 = false;
            $this$actionPerformed_u24lambda_u241.append("Previous Consent State: " + it).append('\n');
        }
        Long l = event.getPreviousConsentTimestamp();
        if (l != null) {
            long it3 = ((Number)l).longValue();
            boolean bl3 = false;
            $this$actionPerformed_u24lambda_u241.append("Previous Consent Timestamp: " + it3).append('\n');
        }
        String string5 = event.getProjectIdHash();
        if (string5 != null) {
            it = string5;
            boolean bl4 = false;
            $this$actionPerformed_u24lambda_u241.append("Project ID Hash: " + (String)it).append('\n');
        }
        $this$actionPerformed_u24lambda_u241.append("License Changed: " + event.isLicenseChange()).append('\n');
        String eventDetails = stringBuilder2.toString();
        Notification notification = new Notification(NOTIFICATION_GROUP_ID, TraceConsentBundle.message("notification.title.decrypt.trace.event.success", new Object[0]), ((Object)StringsKt.trim((CharSequence)eventDetails)).toString(), NotificationType.INFORMATION);
        notification.addAction((AnAction)NotificationAction.createSimple((String)TraceConsentBundle.message("notification.action.copy.to.clipboard", new Object[0]), () -> DecryptTraceEventAction.actionPerformed$lambda$2(eventDetails)));
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    private static final void actionPerformed$lambda$2(String $eventDetails) {
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(((Object)StringsKt.trim((CharSequence)$eventDetails)).toString()));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/platform/trace/consent/actions/DecryptTraceEventAction$Companion;", "", "<init>", "()V", "TRACE_DECRYPT_EVENT_VM_OPTION", "", "NOTIFICATION_GROUP_ID", "intellij.platform.trace.consent"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

