/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.factories;

import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.impl.cache.RecordUtil;
import com.intellij.psi.impl.java.stubs.FunctionalExpressionStub;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.LightTreeUtil;
import com.intellij.psi.impl.source.tree.java.PsiLambdaExpressionImpl;
import com.intellij.psi.stubs.LightStubElementFactory;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LambdaExpressionStubFactory
implements LightStubElementFactory<FunctionalExpressionStub<PsiLambdaExpression>, PsiLambdaExpression> {
    @NotNull
    public FunctionalExpressionStub<PsiLambdaExpression> createStub(@NotNull LighterAST tree, @NotNull LighterASTNode node, @NotNull StubElement<?> parentStub) {
        if (tree == null) {
            LambdaExpressionStubFactory.$$$reportNull$$$0(0);
        }
        if (node == null) {
            LambdaExpressionStubFactory.$$$reportNull$$$0(1);
        }
        if (parentStub == null) {
            LambdaExpressionStubFactory.$$$reportNull$$$0(2);
        }
        return new FunctionalExpressionStub<PsiLambdaExpression>(parentStub, JavaStubElementTypes.LAMBDA_EXPRESSION, LambdaExpressionStubFactory.getPresentableText(tree, node));
    }

    public PsiLambdaExpression createPsi(@NotNull FunctionalExpressionStub<PsiLambdaExpression> stub) {
        if (stub == null) {
            LambdaExpressionStubFactory.$$$reportNull$$$0(3);
        }
        return new PsiLambdaExpressionImpl(stub);
    }

    @NotNull
    public FunctionalExpressionStub<PsiLambdaExpression> createStub(@NotNull PsiLambdaExpression psi, @Nullable StubElement parentStub) {
        if (psi == null) {
            LambdaExpressionStubFactory.$$$reportNull$$$0(4);
        }
        String message = "Should not be called. Element=" + psi + "; class" + psi.getClass() + "; file=" + (psi.isValid() ? psi.getContainingFile() : "-");
        throw new UnsupportedOperationException(message);
    }

    @NotNull
    private static String getPresentableText(@NotNull LighterAST tree, @NotNull LighterASTNode funExpr) {
        if (tree == null) {
            LambdaExpressionStubFactory.$$$reportNull$$$0(5);
        }
        if (funExpr == null) {
            LambdaExpressionStubFactory.$$$reportNull$$$0(6);
        }
        LighterASTNode parameterList = Objects.requireNonNull(LightTreeUtil.firstChildOfType((LighterAST)tree, (LighterASTNode)funExpr, (IElementType)JavaStubElementTypes.PARAMETER_LIST));
        String string = LambdaExpressionStubFactory.getLambdaPresentableText(tree, parameterList);
        if (string == null) {
            LambdaExpressionStubFactory.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static String getLambdaPresentableText(@NotNull LighterAST tree, @NotNull LighterASTNode parameterList) {
        if (tree == null) {
            LambdaExpressionStubFactory.$$$reportNull$$$0(8);
        }
        if (parameterList == null) {
            LambdaExpressionStubFactory.$$$reportNull$$$0(9);
        }
        StringBuilder buf = new StringBuilder(parameterList.getEndOffset() - parameterList.getStartOffset());
        LambdaExpressionStubFactory.formatParameterList(tree, parameterList, buf);
        buf.append(" -> {...}");
        return buf.toString();
    }

    private static void formatParameterList(@NotNull LighterAST tree, @NotNull LighterASTNode parameterList, StringBuilder buf) {
        if (tree == null) {
            LambdaExpressionStubFactory.$$$reportNull$$$0(10);
        }
        if (parameterList == null) {
            LambdaExpressionStubFactory.$$$reportNull$$$0(11);
        }
        List children = tree.getChildren(parameterList);
        boolean isFirstParameter = true;
        boolean appendCloseBracket = false;
        for (LighterASTNode node : children) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaTokenType.LPARENTH) {
                buf.append('(');
                appendCloseBracket = true;
                continue;
            }
            if (tokenType != JavaStubElementTypes.PARAMETER) continue;
            if (!isFirstParameter) {
                buf.append(", ");
            }
            LambdaExpressionStubFactory.formatParameter(tree, node, buf);
            if (!isFirstParameter) continue;
            isFirstParameter = false;
        }
        if (appendCloseBracket) {
            buf.append(')');
        }
    }

    private static void formatParameter(@NotNull LighterAST tree, @NotNull LighterASTNode parameter, StringBuilder buf) {
        if (tree == null) {
            LambdaExpressionStubFactory.$$$reportNull$$$0(12);
        }
        if (parameter == null) {
            LambdaExpressionStubFactory.$$$reportNull$$$0(13);
        }
        List children = tree.getChildren(parameter);
        for (LighterASTNode node : children) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaElementType.TYPE) {
                LambdaExpressionStubFactory.formatType(tree, node, buf);
                buf.append(' ');
                continue;
            }
            if (tokenType != JavaTokenType.IDENTIFIER) continue;
            buf.append(RecordUtil.intern(tree.getCharTable(), node));
        }
    }

    private static void formatType(LighterAST tree, LighterASTNode typeElement, StringBuilder buf) {
        for (LighterASTNode node : tree.getChildren(typeElement)) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaElementType.JAVA_CODE_REFERENCE) {
                LambdaExpressionStubFactory.formatCodeReference(tree, node, buf);
                continue;
            }
            if (tokenType == JavaElementType.TYPE) {
                LambdaExpressionStubFactory.formatType(tree, node, buf);
                continue;
            }
            if (tokenType == JavaTokenType.QUEST) {
                buf.append("? ");
                continue;
            }
            if (ElementType.KEYWORD_BIT_SET.contains(tokenType)) {
                buf.append(RecordUtil.intern(tree.getCharTable(), node));
                if (ElementType.PRIMITIVE_TYPE_BIT_SET.contains(tokenType)) continue;
                buf.append(" ");
                continue;
            }
            if (tokenType == JavaTokenType.ELLIPSIS) {
                buf.append("...");
                continue;
            }
            if (tokenType == JavaTokenType.RBRACKET) {
                buf.append("]");
                continue;
            }
            if (tokenType != JavaTokenType.LBRACKET) continue;
            buf.append("[");
        }
    }

    private static void formatCodeReference(LighterAST tree, LighterASTNode codeRef, StringBuilder buf) {
        for (LighterASTNode node : tree.getChildren(codeRef)) {
            IElementType tokenType = node.getTokenType();
            if (tokenType == JavaTokenType.IDENTIFIER) {
                buf.append(RecordUtil.intern(tree.getCharTable(), node));
                continue;
            }
            if (tokenType != JavaElementType.REFERENCE_PARAMETER_LIST) continue;
            LambdaExpressionStubFactory.formatTypeParameters(tree, node, buf);
        }
    }

    private static void formatTypeParameters(LighterAST tree, LighterASTNode typeParameters, StringBuilder buf) {
        List children = LightTreeUtil.getChildrenOfType((LighterAST)tree, (LighterASTNode)typeParameters, (IElementType)JavaElementType.TYPE);
        if (children.isEmpty()) {
            return;
        }
        buf.append('<');
        for (int i = 0; i < children.size(); ++i) {
            LighterASTNode child = (LighterASTNode)children.get(i);
            LambdaExpressionStubFactory.formatType(tree, child, buf);
            if (i == children.size() - 1) continue;
            buf.append(", ");
        }
        buf.append('>');
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentStub";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funExpr";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/factories/LambdaExpressionStubFactory";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/factories/LambdaExpressionStubFactory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createStub";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPsi";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableText";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLambdaPresentableText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "formatParameterList";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "formatParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

