/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.autowire;

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.highlighting.autowire.SpringUastAutowiredMembersChecker;
import com.intellij.spring.model.highlighting.autowire.SpringUastConstructorAutowiringChecker;
import com.intellij.spring.model.highlighting.autowire.SpringUastInjectionPointsAutowiringChecker;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.uast.UastHintedVisitorAdapter;
import com.intellij.util.containers.FactoryMap;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public final class SpringAutowiringInspection
extends LocalInspectionTool {
    private final Class<? extends UElement>[] myElementTypesHint = new Class[]{UClass.class, UField.class, UMethod.class};

    public PsiNamedElement getProblemElement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            SpringAutowiringInspection.$$$reportNull$$$0(0);
        }
        return (PsiNamedElement)PsiTreeUtil.findFirstParent((PsiElement)psiElement, (Condition)AbstractBaseUastLocalInspectionTool.PROBLEM_ELEMENT_CONDITION);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Module module;
        if (holder == null) {
            SpringAutowiringInspection.$$$reportNull$$$0(1);
        }
        if (!SpringLibraryUtil.hasSpringLibrary((Module)(module = ModuleUtilCore.findModuleForFile((PsiFile)holder.getFile())))) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                SpringAutowiringInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        final Map mappedBeanInfos = Collections.synchronizedMap(FactoryMap.create(aClass -> {
            if (aClass.getQualifiedName() == null) {
                return null;
            }
            return SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)aClass).resolve();
        }));
        final Map springModels = Collections.synchronizedMap(FactoryMap.create(aClass -> SpringAutowireUtil.getProcessingSpringModel(aClass)));
        PsiElementVisitor psiElementVisitor = UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(this){

            public boolean visitClass(@NotNull UClass node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                SpringUastAutowiredMembersChecker.checkClass(node, holder, mappedBeanInfos);
                SpringUastConstructorAutowiringChecker.checkClass(node, holder, mappedBeanInfos);
                return true;
            }

            public boolean visitMethod(@NotNull UMethod node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                SpringUastInjectionPointsAutowiringChecker.checkMethod(node, holder, springModels);
                return true;
            }

            public boolean visitField(@NotNull UField node) {
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                SpringUastInjectionPointsAutowiringChecker.checkField(node, holder, springModels);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/SpringAutowiringInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitClass";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethod";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitField";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Class[])this.myElementTypesHint);
        if (psiElementVisitor == null) {
            SpringAutowiringInspection.$$$reportNull$$$0(3);
        }
        return psiElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/autowire/SpringAutowiringInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/SpringAutowiringInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProblemElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

