/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.extensions.stateMachine;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringImplicitBean;
import com.intellij.spring.model.custom.CustomLocalComponentsDiscoverer;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringStateMachineBeansProvider
extends CustomLocalComponentsDiscoverer {
    private static final String ENABLE_STATE_MACHINE = "org.springframework.statemachine.config.EnableStateMachine";
    private static final String ENABLE_STATE_MACHINE_FACTORY = "org.springframework.statemachine.config.EnableStateMachineFactory";
    private static final String STATE_MACHINE_CONFIGURER = "org.springframework.statemachine.config.builders.StateMachineConfigurer";
    private static final String STATE_MACHINE_FACTORY = "org.springframework.statemachine.config.StateMachineFactory";
    public static final String STATE_MACHINE = "org.springframework.statemachine.StateMachine";
    public static final String DEFAULT_ID_STATEMACHINE = "stateMachine";
    public static final String DEFAULT_ID_STATEMACHINEFACTORY = "stateMachineFactory";

    @NotNull
    public Collection<CommonSpringBean> getCustomComponents(@NotNull LocalModel<?> model) {
        Module module;
        if (model == null) {
            SpringStateMachineBeansProvider.$$$reportNull$$$0(0);
        }
        if ((module = model.getModule()) == null || module.isDisposed() || !(model instanceof LocalAnnotationModel)) {
            Set<CommonSpringBean> set = Collections.emptySet();
            if (set == null) {
                SpringStateMachineBeansProvider.$$$reportNull$$$0(1);
            }
            return set;
        }
        PsiClass psiClass = ((LocalAnnotationModel)model).getConfig();
        HashSet<CommonSpringBean> beans = new HashSet<CommonSpringBean>();
        beans.addAll(SpringStateMachineBeansProvider.getStateMachineBeans(module, psiClass, ENABLE_STATE_MACHINE, STATE_MACHINE));
        beans.addAll(SpringStateMachineBeansProvider.getStateMachineBeans(module, psiClass, ENABLE_STATE_MACHINE_FACTORY, STATE_MACHINE_FACTORY));
        HashSet<CommonSpringBean> hashSet = beans;
        if (hashSet == null) {
            SpringStateMachineBeansProvider.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    @NotNull
    private static Collection<CommonSpringBean> getStateMachineBeans(@NotNull Module module, @NotNull PsiClass configurationClass, @NotNull String enableStateMachineAnno, String ... stateMachineClasses) {
        if (module == null) {
            SpringStateMachineBeansProvider.$$$reportNull$$$0(3);
        }
        if (configurationClass == null) {
            SpringStateMachineBeansProvider.$$$reportNull$$$0(4);
        }
        if (enableStateMachineAnno == null) {
            SpringStateMachineBeansProvider.$$$reportNull$$$0(5);
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)configurationClass, (String)enableStateMachineAnno, (int)0)) {
            SmartList beans = new SmartList();
            PsiClassType psiClassType = PsiTypesUtil.getClassType((PsiClass)configurationClass);
            PsiType stateType = PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)STATE_MACHINE_CONFIGURER, (int)0, (boolean)false);
            PsiType eventType = PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)STATE_MACHINE_CONFIGURER, (int)1, (boolean)false);
            if (stateType != null && eventType != null) {
                for (String stateMachineClass : stateMachineClasses) {
                    String name = SpringStateMachineBeansProvider.getStateMachineName(configurationClass, enableStateMachineAnno);
                    ContainerUtil.addIfNotNull((Collection)beans, (Object)SpringStateMachineBeansProvider.createImplicitBean(module, stateMachineClass, name, stateType, eventType, SpringStateMachineBeansProvider.getIdentifyingElement(configurationClass, enableStateMachineAnno)));
                }
            }
            SmartList smartList = beans;
            if (smartList == null) {
                SpringStateMachineBeansProvider.$$$reportNull$$$0(6);
            }
            return smartList;
        }
        List<CommonSpringBean> list = Collections.emptyList();
        if (list == null) {
            SpringStateMachineBeansProvider.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    private static String getStateMachineName(@NotNull PsiClass configurationClass, @NotNull String enableStateMachineAnno) {
        String name;
        PsiAnnotation annotation;
        if (configurationClass == null) {
            SpringStateMachineBeansProvider.$$$reportNull$$$0(8);
        }
        if (enableStateMachineAnno == null) {
            SpringStateMachineBeansProvider.$$$reportNull$$$0(9);
        }
        if ((annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)configurationClass, (String[])new String[]{enableStateMachineAnno})) != null && StringUtil.isNotEmpty((String)(name = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, (String)"name")))) {
            String string = name;
            if (string == null) {
                SpringStateMachineBeansProvider.$$$reportNull$$$0(10);
            }
            return string;
        }
        return enableStateMachineAnno.equals(ENABLE_STATE_MACHINE_FACTORY) ? DEFAULT_ID_STATEMACHINEFACTORY : DEFAULT_ID_STATEMACHINE;
    }

    private static PsiElement getIdentifyingElement(@NotNull PsiClass configurationClass, @NotNull String enableStateMachineAnno) {
        PsiAnnotation annotation;
        if (configurationClass == null) {
            SpringStateMachineBeansProvider.$$$reportNull$$$0(11);
        }
        if (enableStateMachineAnno == null) {
            SpringStateMachineBeansProvider.$$$reportNull$$$0(12);
        }
        return (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)configurationClass, (String[])new String[]{enableStateMachineAnno})) != null ? annotation : configurationClass;
    }

    private static SpringImplicitBean createImplicitBean(@NotNull Module module, @NotNull String beanClass, @NotNull String beanName, @NotNull PsiType stateType, @NotNull PsiType eventType, final @NotNull PsiElement identifyingElement) {
        PsiClass stateMachineClass;
        if (module == null) {
            SpringStateMachineBeansProvider.$$$reportNull$$$0(13);
        }
        if (beanClass == null) {
            SpringStateMachineBeansProvider.$$$reportNull$$$0(14);
        }
        if (beanName == null) {
            SpringStateMachineBeansProvider.$$$reportNull$$$0(15);
        }
        if (stateType == null) {
            SpringStateMachineBeansProvider.$$$reportNull$$$0(16);
        }
        if (eventType == null) {
            SpringStateMachineBeansProvider.$$$reportNull$$$0(17);
        }
        if (identifyingElement == null) {
            SpringStateMachineBeansProvider.$$$reportNull$$$0(18);
        }
        if ((stateMachineClass = SpringCommonUtils.findLibraryClass((Module)module, (String)beanClass)) != null) {
            final PsiClassType stateMachineType = JavaPsiFacade.getElementFactory((Project)module.getProject()).createType(stateMachineClass, new PsiType[]{stateType, eventType});
            return new SpringImplicitBean("SpringStateMachineBeansProvider", stateMachineClass, beanName){

                @NotNull
                public PsiType getBeanType() {
                    PsiClassType psiClassType = stateMachineType;
                    if (psiClassType == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return psiClassType;
                }

                @NotNull
                public PsiElement getIdentifyingPsiElement() {
                    PsiElement psiElement = identifyingElement;
                    if (psiElement == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return psiElement;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = "com/intellij/spring/model/extensions/stateMachine/SpringStateMachineBeansProvider$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getBeanType";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getIdentifyingPsiElement";
                            break;
                        }
                    }
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
                }
            };
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6, 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/extensions/stateMachine/SpringStateMachineBeansProvider";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationClass";
                break;
            }
            case 5: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enableStateMachineAnno";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifyingElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/extensions/stateMachine/SpringStateMachineBeansProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomComponents";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateMachineBeans";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getStateMachineName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomComponents";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStateMachineBeans";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getStateMachineName";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifyingElement";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createImplicitBean";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6, 7, 10 -> new IllegalStateException(string);
        };
    }
}

