/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.factories.resolvers;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.factories.ObjectTypeResolver;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.xml.util.SpringConstant;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UtilConstantTypeResolver
implements ObjectTypeResolver {
    @NonNls
    private static final String FACTORY_CLASS = "org.springframework.beans.factory.config.FieldRetrievingFactoryBean";
    @NonNls
    private static final char SEPARATOR = '.';

    @Override
    @NotNull
    public Set<PsiType> getObjectType(@Nullable CommonSpringBean context) {
        SpringConstant constant;
        String staticField;
        int lastDotIndex;
        if (context instanceof SpringConstant && (lastDotIndex = (staticField = StringUtil.notNullize((String)(constant = (SpringConstant)context).getStaticField().getStringValue())).lastIndexOf(46)) != -1) {
            PsiField psiField;
            String className = staticField.substring(0, lastDotIndex);
            String fieldName = staticField.substring(lastDotIndex + 1);
            PsiClass psiClass = UtilConstantTypeResolver.findClassByExternalName(context, className);
            if (psiClass != null && (psiField = psiClass.findFieldByName(fieldName, true)) != null) {
                Set<PsiType> set = Collections.singleton(psiField.getType());
                if (set == null) {
                    UtilConstantTypeResolver.$$$reportNull$$$0(0);
                }
                return set;
            }
        }
        Set<PsiType> set = Collections.emptySet();
        if (set == null) {
            UtilConstantTypeResolver.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Nullable
    private static PsiClass findClassByExternalName(@NotNull CommonSpringBean context, @NotNull String externalName) {
        Module module;
        if (context == null) {
            UtilConstantTypeResolver.$$$reportNull$$$0(2);
        }
        if (externalName == null) {
            UtilConstantTypeResolver.$$$reportNull$$$0(3);
        }
        if ((module = context.getModule()) != null) {
            GlobalSearchScope scope = SpringGlobalSearchScopes.runtime((Module)module, (boolean)false);
            PsiManager psiManager = context.getPsiManager();
            String className = externalName.replace('$', '.');
            return JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(className, scope);
        }
        return null;
    }

    @Override
    public boolean accept(@NotNull String factoryClassName) {
        if (factoryClassName == null) {
            UtilConstantTypeResolver.$$$reportNull$$$0(4);
        }
        return factoryClassName.equals(FACTORY_CLASS);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/factories/resolvers/UtilConstantTypeResolver";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryClassName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/factories/resolvers/UtilConstantTypeResolver";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findClassByExternalName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

